/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2011 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_GG)


#include "iggcontrolscript.h"


#include "icommandinterpreter.h"
#include "ierror.h"
#include "istring.h"


using namespace iParameter;


#define curScript	iRequiredCast<iggControlScript>(INFO,me)


iggControlScript::iggControlScript(iControlModule *cm, iScript *parent) : iControlScript(cm,parent)
{
	mCommandInterpreter = 0;
}


iggControlScript::~iggControlScript()
{
}


//
//  use CommandInterpreter for console functions
//
void iggControlScript::AttachCommandInterpreter(const iCommandInterpreter *ci)
{
	mCommandInterpreter = ci;
}


void iggControlScript::OutputText(const iString &s) const
{
	if(mCommandInterpreter != 0)
	{
		mCommandInterpreter->DislayLineOfText(s,CommandInterpreterType::Result);
	}
	else
	{
		iString ws(s);
		ws.ReformatHTMLToText();
		iConsole::Display(iConsole::_Info,ws);
	}
}


void iggControlScript::OutputError(const iString &s) const
{
	if(mCommandInterpreter != 0)
	{
		mCommandInterpreter->DislayLineOfText(s,CommandInterpreterType::Error);
	}
	else
	{
		iString ws(s);
		ws.ReformatHTMLToText();
		iConsole::Display(iConsole::_LowError,ws);
	}
}

#endif
