/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2006 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iviewsubjectobserver.h"


#include "icontrolmodule.h"
#include "idata.h"
#include "idatareader.h"
#include "ierror.h"
#include "iviewmodule.h"
#include "iviewsubject.h"


using namespace iParameter;


iViewSubjectObserver *iViewSubjectObserver::New(iViewSubject *vo)
{
	IERROR_ASSERT(vo);
	return new iViewSubjectObserver(vo);
}


iViewSubjectObserver::iViewSubjectObserver(iViewSubject *vo)
{
	mSubject = vo;
	mIsoSurfaceData.Var = 0;
	mIsoSurfaceData.Level = 0.0f;
}


iViewSubjectObserver::~iViewSubjectObserver()
{
}


int iViewSubjectObserver::GetSubjectId() const
{
	if(mSubject != 0) return mSubject->GetSubjectId(); else return ViewSubject::Id::Undefined;
}


const iString& iViewSubjectObserver::GetSubjectName() const
{
	static const iString none("Unknown");
	if(mSubject != 0) return mSubject->GetSubjectName(); else return none;
}


const iDataType& iViewSubjectObserver::GetDataType() const
{
	if(mSubject != 0) return mSubject->GetDataType(); else return iDataType::Null();
}

