/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

/////////////////////////////////////////////////////////////////////////
// IceMenuCompiler.h - headerfile for IceMenuScanner and IceMenuInParser
// created:       mig 000720
// modified:      mig 001001
/////////////////////////////////////////////////////////////////////////

#ifndef ICEMENUINCOMPILER_H
#define ICEMENUINCOMPILER_H

#include "IceMC.h"

class IceMenuScanner {
public:
  // data
  enum symbolCode { noSy, eolSy, eofSy, quoteSy, lBraceSy, rBraceSy,
		    menuSy, progSy, restartSy, separatorSy, identSy, quotedIdentSy};
  // methods
  IceMenuScanner();
  IceMenuScanner(const QString filePath);
  virtual ~IceMenuScanner();
  virtual void setFile(const QString filePath);
  virtual symbolCode newSy();
  virtual QString getIdentStr() const;
  virtual void getActPos(int& line, int& sy);
protected:
  // data
  symbolCode sy;
  QString identStr;
  QString srcLine;
  uint synr;
  int lnr;
  QChar ch;
  QFile* src;
  QTextStream* srcStream;
  // methods
  virtual QChar newChar();
};

class IceMenuInParser {
public:
  IceMenuInParser();
  virtual ~IceMenuInParser();
  virtual void parseFile(IceListView* menuList, const QString filePath);
  virtual void errorPos(int& lineNr, int& charNr);
  virtual bool successful();

protected:
	// data
  IceMenuScanner* scanner;
  IceMenuScanner::symbolCode sy;
  bool success;
  int errlnr;
  int errcnr;
	// methods
  virtual void identifier(QString& identStr);
  virtual void syntaxError();  
  virtual void semError(QString errorMsg);

private:
  virtual void s(IceListView* menuList);
  virtual void entry(IceListView* menuList, IceListViewItem* subList);
  virtual void menu(IceListViewItem* e);
  virtual void prog(IceListViewItem* e); // also handles restart
  virtual QString name();
  virtual QString icon();
  virtual QString exec();
};

#endif







