/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

#include "IceListView.h"

#include "IceFileSearch.h"
#include "IceMainWindow.h"

#include <qpixmap.h>

#include "noIcon.xpm"

//////////////////////////////////////////////
// constructors & destructor
//////////////////////////////////////////////

IceListViewItem::IceListViewItem ( IceListView* parent) : QListViewItem (parent) 
{ 
  color = QColor(0,0,0);
}

IceListViewItem::IceListViewItem ( IceListView* parent, QString infoStr, QString label1 = QString::null,
				   QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, 
				   QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, 
				   QString label8 = QString::null )
  : QListViewItem ( parent, label1, label2, label3, label4, label5, label6, label7, label8 ), info(infoStr)
{ 
  color = QColor(0,0,0);
}

IceListViewItem::IceListViewItem ( IceListView* parent, IceListViewItem* after, QString infoStr, QString label1 = QString::null,
				   QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, 
				   QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, 
				   QString label8 = QString::null )
  : QListViewItem ( parent, after, label1, label2, label3, label4, label5, label6, label7, label8 ), info(infoStr)
{ 
  color = QColor(0,0,0);
}

IceListViewItem::IceListViewItem ( IceListViewItem* parent, IceListViewItem* after, QString infoStr, QString label1 = QString::null,
				   QString label2 = QString::null, QString label3 = QString::null, QString label4 = QString::null, 
				   QString label5 = QString::null, QString label6 = QString::null, QString label7 = QString::null, 
				   QString label8 = QString::null )
  : QListViewItem ( parent, after, label1, label2, label3, label4, label5, label6, label7, label8 ), info(infoStr) 
{ 
  color = QColor(0,0,0);
}

IceListViewItem::~IceListViewItem() // virtual
{
}

/////////////////////////////////////////////
// public methods
/////////////////////////////////////////////

IceListViewItem* IceListViewItem::firstChild() const // virtual
{
  return (IceListViewItem*) (QListViewItem::firstChild());
}

IceListViewItem* IceListViewItem::nextSibling() const // virtual
{
  return (IceListViewItem*) (QListViewItem::nextSibling());
}

IceListViewItem* IceListViewItem::parent() const // virtual 
{
  return (IceListViewItem*) (QListViewItem::parent());
}

IceListViewItem* IceListViewItem::itemAbove() // virtual
{
  return (IceListViewItem*) (QListViewItem::itemAbove());
}

IceListViewItem* IceListViewItem::itemBelow() // virtual
{
  return (IceListViewItem*) (QListViewItem::itemBelow());
}
 
QString IceListViewItem::getInfo() const // virtual 
{
  return info;
}

QColor IceListViewItem::getColor() const // virtual
{
  return color;
}

void IceListViewItem::setInfo(QString infoStr) // virtual
{
  info = infoStr;
}

void IceListViewItem::setColor(QColor newColor) // virtual 
{
  color = newColor;
}

void IceListViewItem::paintCell ( QPainter * p, const QColorGroup & cg, int column, int width, int align ) // virtual
{
  QColorGroup colorGroup(cg);
  colorGroup.setColor(QColorGroup::Text,color);
  QListViewItem::paintCell(p,colorGroup,column,width,align);
}

// deepCopy makes a deep copy of 'this' making 'copy' the parent item of the copy
// IMPORTANT: 'this' and 'copy' have to be members of a ListView !
void IceListViewItem::deepCopy(IceListViewItem* copy) // virtual
{
  ;//qDebug("DEBUG: IceListViewItem::deepCopy(...)");

  if (copy) {

    IceListViewItem* thisChild;
    IceListViewItem* tempItem;
    
    copy->setInfo(this->getInfo());
    copy->setText(0,this->text(0));
    copy->setText(1,this->text(1));
    copy->setText(2,this->text(2));
    
    if (this->isExpandable())
      copy->setExpandable(true);
    
    thisChild = this->firstChild();
    
    if (thisChild) {
      tempItem = copy;
      thisChild->deepCopyFolder(tempItem);
    }
  }
  else
    qWarning("WARNING: IceListViewItem::deepCopy(...) null pointer");
}

bool IceListViewItem::setExecState() // virtual
{
  QString exec, temp;
  bool isExec = false;
  
  temp = this->getInfo();
  if ((temp != "separator") && (temp != "menu")) {
    exec = this->text(2);
    if (exec.contains(' ') > 0) {
      int count = 0;
      temp = "";
      while (exec.at(count) != ' ') {
	temp += exec.at(count);
	count++;
      }
      exec = temp;
    }
    IceFileSearch* search = new IceFileSearch();
    if (search->fileExecutable(exec, IceListView::path) != "") { // executable
      this->setColor(IceListView::executable);
      isExec = true;
      ;//qDebug("DEBUG: executable");
    }
    else {
      this->setColor(IceListView::notExecutable);
    }
    delete search;
  }
  else {
    if (temp == "separator") {
      this->setColor(IceListView::executable);
      isExec = true;
    }
    else  // == menu
      this->setColor(IceListView::notExecutable); // warum da?
  } // end if

  return isExec;
}

void IceListViewItem::setIcon() // virtual
{
  QString icon;
  IceFileSearch* search = new IceFileSearch();

  icon = search->iconReadable(this->text(1), IceListView::iconPath);
  delete search;
  
  if (this->getInfo() == "separator")
    this->setPixmap(0,0);
  else if (icon != "")
    this->setPixmap(0,QPixmap(icon));
  else
    this->setPixmap(0,QPixmap(noIcon));

  ;//qDebug("DEBUG: setIcon: " + this->text(0));
}

//////////////////////////////////////////////////////////////
// protected methods
//////////////////////////////////////////////////////////////

void IceListViewItem::deepCopyFolder(IceListViewItem* copy) // virtual
{
  ;//qDebug("DEBUG: IceListViewItem::deepCopyFolder() ");
  IceListViewItem* sibling;
  IceListViewItem* item;
  IceListViewItem* tempChild;
  IceListViewItem* tempItem;

  item = new IceListViewItem(copy,copy,this->getInfo(),this->text(0),this->text(1),this->text(2));
  if (this->isExpandable())
    item->setExpandable(true);

  // deepcopy this if it is a folder
  if ((tempChild = this->firstChild())) {
    tempItem = item;
    tempChild->deepCopyFolder(tempItem);
  }

  sibling = this;

  // copy siblings
  while ((sibling = sibling->nextSibling())) {
    item = new IceListViewItem(copy,item,sibling->getInfo(),sibling->text(0),sibling->text(1),sibling->text(2));
    if ((tempChild = sibling->firstChild())) {
      tempItem = item;
      tempChild->deepCopyFolder(tempItem);
    }
    else if (sibling->isExpandable()) // just test when 'else' 
      item->setExpandable(true);      // (if child then automatically expandable)
  }
}









