/**
 * IceMC - a menu editor for IceWM
 * Copyright (c) 2000 Georg Mittendorfer
 */

#include "IceFileSearch.h"

////////////////////////////////////////
// constructors & destructors
////////////////////////////////////////

IceFileSearch::IceFileSearch()
{
  fInfo = new QFileInfo();
}

IceFileSearch::~IceFileSearch() // virtual
{
  delete fInfo;
}

///////////////////////////////////////
// public methods
///////////////////////////////////////

QString IceFileSearch::fileReadable(QString name, QString path=0) // virtual
{
  QString file;
  file = lookupFile(name,path);
  fInfo->setFile(file);
  if (fInfo->isReadable())
    return file;
  else
    return "";
}

QString IceFileSearch::fileExecutable(QString name, QString path=0) // virtual
{
  QString file;
  //file = lookupFile(name,path);
  file = lookupExecutable(name,path);
//    fInfo->setFile(file);
//    if (fInfo->isExecutable())
//      return file;
//    else
//      return "";
  return file;
}

QString IceFileSearch::dirReadable(QString name, QString path=0) // virtual
{
  QString dir;
  dir = lookupFile(name,path,true);
  fInfo->setFile(dir);
  if (fInfo->isReadable())
    return dir;
  else
    return "";
}

QString IceFileSearch::iconReadable(QString name, QString path=0) // virtual
{
  QString icon;
  icon = lookupFile((name + "_16x16.xpm"),path);
  fInfo->setFile(icon);
  if (fInfo->isReadable())
    return icon;
  else
    return "";
}

// TODO: FINISH FOLLOWING METHOD !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
QString IceFileSearch::getArgument(QString file, QString pattern) // virtual
{
  // this method is just a dirty case oriented solution
  // parser will be used later 
  // (for reading all parameters of the preferences file)

  // TODO:
  // skip spaces
  // skip lines starting with '#'
  // skip lines not starting with right letter
  // if length of string doesn't fit pattern -> skip line
  // if length fits check for match
  // if match get param

  QFile* src = new QFile();
  QTextStream* srcStream = new QTextStream();
  QString srcLine = "";
  int count = 0;
  int sLen;
  int pLen = pattern.length();

  src->setName(file);
  src->open(IO_ReadOnly);
  srcStream->setDevice(src);
  srcLine = srcStream->readLine();

  while (!srcStream->atEnd()) {
    sLen = srcLine.length();

    while ((count < (sLen-pLen)-3) && (srcLine.at(count).isSpace())) {
      count ++;
    }
    
    if (srcLine.at(count) == '#')
      srcLine = srcStream->readLine();
    else if (srcLine.contains(pattern) < 1)
      srcLine = srcStream->readLine();
    else {
      // get argument
    }
  }
    
  src->close();

  delete srcStream;
  delete src;
}

///////////////////////////////////////
// private methods
///////////////////////////////////////

/**
 * Searches for an executable file. This method duplicates some code (lookupFile
 * is quite similar).
 */
QString IceFileSearch::lookupExecutable(QString name, const QString path=0) {
  QString fullPath;
  QString s = path;
  uint sLen = s.length();
  fInfo->setFile(name);
  uint pos = 0;

  if (fInfo->isExecutable()) // name == correct absolute filename
    fullPath = name;
  else { // analyse path
    do {
      pos = 0;
      while ((pos<sLen) && (s.at(pos) != ':'))
	pos++;   
      
      fullPath = s.left(pos);
      
      if ((pos > 0) && (fullPath.at(pos-1) != '/'))
	fullPath += '/';
      fullPath += name;
      
      if (sLen>pos)
	s = s.right(sLen-(pos+1));
      else
	s = "";
      sLen = s.length();
      
      // test if exists
      fInfo->setFile(fullPath);
      if (fInfo->isExecutable()) {
	sLen = 0; // break
      } else 
	fullPath = "";      
    } while (sLen > 0);
  }
  return fullPath; // might also return a relative path!
}  

QString IceFileSearch::lookupFile(QString name, const QString path=0, bool dir=false) // virtual
{
  QString fullPath;
  QString s = path;
  uint sLen = s.length();
  fInfo->setFile(name);
  uint pos = 0;

  if (fInfo->exists()) // name == correct absolute filename
    fullPath = name;
  else {
    // analyse path
    do {
      pos = 0;
      while ((pos<sLen) && (s.at(pos) != ':'))
	pos++;   
      
      fullPath = s.left(pos);
      
      if ((pos > 0) && (fullPath.at(pos-1) != '/'))
	fullPath += '/';
      fullPath += name;
      
      if (sLen>pos)
	s = s.right(sLen-(pos+1));
      else
	s = "";
      sLen = s.length();
      
      // test if exists
      fInfo->setFile(fullPath);
      if (fInfo->exists()) {
	sLen = 0; // break
      } else 
	fullPath = "";
      
    } while (sLen > 0);
  }
  
  // test if correct file type
  if (dir) {
    if (!fInfo->isDir())
      fullPath = "";
  }
  
  return fullPath; // might also return a relative path!
}

//////////////////////////////////////
// garbage
//////////////////////////////////////

/*
QString IceMainWindow::searchPref(QString file, QString p)
{
  QFile src;
  QTextStream srcStream;
  src.setName(tempStr);
  src.open(IO_ReadOnly);
  srcStream.setDevice(&src);
  srcLine = srcStream.readLine();
  ch = ' ';
  src.close();
  */


  /* 
  skip spaces
  skip lines starting with '#'
  skip lines not starting with right letter
  if length of string doesn't fit pattern -> skip line
  if length fits check for match
  if match get param
}  */




