#ifndef _TERM_H
#define _TERM_H 1

extern int LI, CO;
extern char term_name[], *HO, *ME, *MR, *US, *CL, *CM, *CE, *CS, *DC, *IC;

extern int term_putc (int c);
extern int term_init (void);
extern void term_install_signal_handlers (void);
extern void term_puts (const char *buf, unsigned int len);
extern void term_printf (const char *fmt, ...) __attribute__((__format__(printf, 1, 2)));
extern void term_set_scroll_region (int first, int last);
extern void term_scroll_up (void);
extern void term_scroll_down (void);
extern void term_ce (void);
extern void term_clear (void);
extern void term_home (void);
extern void term_goto_line (int line);
extern void term_move_cursor (int line, int column);
extern void term_char_insert (void);
extern void term_char_delete (void);
extern void term_mode_clear (void);
extern void term_mode_underline (void);
extern void term_mode_reverse (void);
extern void term_reset (void);
extern void term_sigwinch (void);
extern void term_sigtstp (void);
extern void term_sigcont (void);

#define term_colour(c) (colour_str[c])
extern char const *colour_str[];
enum color_attributes {	
	BLACK = 0,
	BLUE,
	GREEN,
	CYAN,
	RED,
	MAGENTA,
	YELLOW,
	WHITE, 
	BLACK_BOLD,
	BLUE_BOLD,
	GREEN_BOLD,
	CYAN_BOLD,
	RED_BOLD,
	MAGENTA_BOLD,
	YELLOW_BOLD,
	WHITE_BOLD,
	DEFAULT, 
	BACK_BLACK,
	BACK_RED,
	BACK_GREEN,
	BACK_YELLOW,
	BACK_BLUE,
	BACK_MAGENTA,
	BACK_CYAN,
	BACK_WHITE, 
	BACK_BLACK_BOLD,
	BACK_RED_BOLD,
	BACK_GREEN_BOLD,
	BACK_YELLOW_BOLD,
	BACK_BLUE_BOLD,
	BACK_MAGENTA_BOLD,
	BACK_CYAN_BOLD,
	BACK_WHITE_BOLD,
	REVERSE,
	BOLD,
	BLINK,
	UNDERLINE
};

#endif /* !_TERM_H */
