#include "hx_types.h"
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <stdio.h>
#include <unistd.h>
#include <getopt.h>
#include "screen.h"
#include "term.h"
#include "cmd.h"
#include "hxlib.h"
#include "htlc.h"
#include "hxlib.h"
#include "xmalloc.h"
#include "auto_array.h"

struct hx_preferences hx_prefs = {
	500,
	"\0"
};

char homedir[1024] = "./";

void
hx_input_fun (struct input *ip)
{
	ip->buf[ip->len] = 0;
	if (ip->buf[0] == '/') {
		cmd_exec(&(ip->buf[1]), 1);
	} else if (hx_sock >= 0) {
		auto_array(ip->buf, s, ip->len);
		strexpand(s);
		colourz(s);
		auto_free(s);
	}
}


extern int cmd_load (int, char *const *);

static struct option main_opts[] = {
	{"nickname",	1, 0,	'n'},
	{"icon",	1, 0,	'i'},
	{"rcfile",	1, 0,	'l'},
	{"norcfile",	0, 0,	'q'},
	{"version",	0, 0,	'V'},
	{0, 0, 0, 0}
};

int
main (int argc, char *const *argv)
{
	int longind, o;
	char *ep, *rcfile;
	struct passwd *pwe = 0;

	rcfile = getenv("HXRC");
	if (!(ep = getenv("HXNICK"))) {
		if (!(pwe = getpwuid(getuid()))) {
			perror("getpwuid");
			exit(-1);
		}
		ep = pwe->pw_name;
	}
	snprintf(hx_prefs.nick, sizeof hx_prefs.nick, "%s", ep);
	if ((ep = getenv("HXICON")))
		hx_prefs.icon = atou16(ep);
	if (!(ep = getenv("HOME"))) {
		if (!pwe && !(pwe = getpwuid(getuid()))) {
			perror("getpwuid");
			exit(-1);
		}
		ep = pwe->pw_dir;
	}
	snprintf(homedir, sizeof homedir, "%s", ep);

	optind = 0;
	while ((o = getopt_long(argc, argv, "n:i:l:qV", main_opts, &longind)) != EOF) {
		if (o == 0)
			o = main_opts[longind].val;
		switch (o) {
			case 'n':
				snprintf(hx_prefs.nick, sizeof hx_prefs.nick, "%s", optarg);
				break;
			case 'i':
				hx_prefs.icon = atou16(optarg);
				break;
			case 'l':
				rcfile = optarg;
				break;
			case 'q':
				rcfile = (char *)-1;
				break;
			case 'V':
				term_printf("%s\n", hx_version_string);
				exit(0);
			default:
				term_printf(
					"usage: %s [options]\n"
					"  -n, --nickname <nickname>\n"
					"  -i, --icon <icon>\n"
					"  -l, --rcfile <rcfile>\n"
					"  -q, --norcfile\n"
					"  -V, --version\n",
					argv[0]);
				exit(1);
		}
	}
	if (term_init() == -1)
		exit(-1);
	if (scr_init(LI - 4, CO))
		hx_exit(-1);
	term_sigwinch();
	if (rcfile != (char *)-1) {
		char _load[]= "load", _path[] = "~/.hxrc", *av[3];

		av[0] = _load;
		av[1] = rcfile ? rcfile : _path;
		av[2] = 0;
		cmd_load(2, av);
	}
	scr_draw(curscr);
	hx_loop();
}
