AC_DEFUN([GCC_WARNINGS],
[
changequote(,)dnl
cat > conftest.$ac_ext <<EOF
#line __oline__ "configure"
int main(int argc, char *argv[]) { return argv[argc-1] == 0; }
EOF
changequote([,])dnl
AC_CHECKING([for gcc warning options (\$(WARN))])
for cf_opt in \
	bad-function-cast \
	cast-align \
	cast-qual \
	inline \
	missing-declarations \
	missing-prototypes \
	nested-externs \
	pointer-arith \
	shadow \
	strict-prototypes \
	write-strings
do
	if AC_TRY_EVAL(ac_compile); then
		test -n "$verbose" && AC_MSG_RESULT(... -W$cf_opt)
		WARN="$WARN -W$cf_opt"
	fi
done
rm -f conftest*
])

AC_DEFUN(DECL_SYS_ERRLIST,
[AC_CACHE_CHECK([for sys_errlist declaration in stdio.h],
  ac_cv_decl_sys_errlist,
[AC_TRY_COMPILE([#include <sys/types.h>
#include <stdio.h>
], [char *msg = *(sys_errlist + 1);],
  ac_cv_decl_sys_errlist=yes, ac_cv_decl_sys_errlist=no)])
if test $ac_cv_decl_sys_errlist = yes; then
  AC_DEFINE(SYS_ERRLIST_DECLARED)
fi
])
