#!/bin/bash

set -e
export BUILD_HSAILASM=1
export BUILD_LIBBRIGDWARF=1
export ELFTOOLCHAIN_PATH=/srv/hsa/drivers/hsa/contrib/elftoolchain
export LIBELF_PATH=$ELFTOOLCHAIN_PATH/libelf
export LIBDWARF_PATH=/srv/hsa/drivers/sc/HSAIL/hsail-tools/libdwarf
export RE2C_EXECUTABLE=/srv/dk/lnx/re2c/re2c

cd ..

mkdir -p build/lnx32
cd build/lnx32
export BUILD_SUBDIR=build/lnx/B_dbg
cmake -DCMAKE_BUILD_TYPE=Debug -G "Unix Makefiles" -DBUILD_HSAILASM=$BUILD_HSAILASM -DBUILD_LIBBRIGDWARF=$BUILD_LIBBRIGDWARF -DLIBELF_INCLUDE_DIRS="$LIBELF_PATH;$LIBELF_PATH/../common" -DLIBDWARF_INCLUDE_DIRS=$LIBDWARF_PATH/src -DLIBELF_LIBRARIES=$LIBELF_PATH/$BUILD_SUBDIR/libelf.a -DLIBDWARF_LIBRARIES=$LIBDWARF_PATH/$BUILD_SUBDIR/libdwarf.a -DRE2C_EXECUTABLE=$RE2C_EXECUTABLE -DCMAKE_C_FLAGS=-m32 -DCMAKE_CXX_FLAGS=-m32 -DCMAKE_SHARED_LINKER_FLAGS=-m32 -DCMAKE_INSTALL_PREFIX=dist "$@" ../..
cd ../..

mkdir -p build/lnx64
cd build/lnx64
export BUILD_SUBDIR=build/lnx64a/B_dbg
cmake -DCMAKE_BUILD_TYPE=Debug -G "Unix Makefiles" -DBUILD_HSAILASM=$BUILD_HSAILASM -DBUILD_LIBBRIGDWARF=$BUILD_LIBBRIGDWARF -DLIBELF_INCLUDE_DIRS="$LIBELF_PATH;$LIBELF_PATH/../common;$LIBDWARF_PATH/src" -DLIBDWARF_INCLUDE_DIRS=$LIBDWARF_PATH/src -DLIBELF_LIBRARIES=$LIBELF_PATH/$BUILD_SUBDIR/libelf.a -DLIBDWARF_LIBRARIES=$LIBDWARF_PATH/$BUILD_SUBDIR/libdwarf.a -DRE2C_EXECUTABLE=$RE2C_EXECUTABLE -DCMAKE_C_FLAGS=-m64 -DCMAKE_CXX_FLAGS=-m64 -DCMAKE_SHARED_LINKER_FLAGS=-m64 -DCMAKE_INSTALL_PREFIX=dist "$@" ../..
cd ../..
