/*****************************************************************************\
  dj8xx.h : Interface for the DJ8xx class

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#ifndef APDK_DJ8XX_H
#define APDK_DJ8XX_H

APDK_BEGIN_NAMESPACE

extern char *ModelString[MAX_ID_STRING];

/*!
\internal
*/
class DJ8xx : public Printer
{
public:
    DJ8xx(SystemServices* pSS,int numfonts=0, BOOL proto=FALSE);

    PrintMode* GetMode(int index);

    virtual Header* SelectHeader(PrintContext* pc);
    virtual DRIVER_ERROR VerifyPenInfo();
    virtual DRIVER_ERROR ParsePenInfo(PEN_TYPE& ePen, BOOL QueryPrinter=TRUE);
    virtual DISPLAY_STATUS ParseError(BYTE status_reg);

    Compressor* CreateCompressor(unsigned int RasterSize);

    virtual BOOL UseGUIMode(PrintMode* pPrintMode);
    DRIVER_ERROR CleanPen();

protected:

}; //DJ8xx


class VeniceMode1 : public PrintMode
{
public:
    VeniceMode1();
}; //VeniceMode1


class VeniceMode2 : public PrintMode
{
public:
    VeniceMode2();
}; //VeniceMode2


class VeniceMode3 : public PrintMode
{
public:
    VeniceMode3();
}; //VeniceMode3


#ifdef APDK_PROTO
extern PEN_TYPE ProtoPenType;
/*!
\internal
*/
class ProtoDJ8xx : public DJ8xx
{
public:
    ProtoDJ8xx(ProtoServices* pSS);

    DRIVER_ERROR ParsePenInfo(PEN_TYPE& ePen) { ePen=ProtoPenType; return NO_ERROR; }
}; //ProtoDJ8xx


#endif //APDK_PROTO

APDK_END_NAMESPACE

#endif //APDK_DJ8XX_H
