{- This module was generated from data in the Kate syntax
   highlighting file yacc.xml, version 1.03, by Jan Villat (jan.villat@net2000.ch) -}

module Text.Highlighting.Kate.Syntax.Yacc
          (highlight, parseExpression, syntaxName, syntaxExtensions)
where
import Text.Highlighting.Kate.Types
import Text.Highlighting.Kate.Common
import qualified Text.Highlighting.Kate.Syntax.Cpp
import Text.ParserCombinators.Parsec hiding (State)
import Control.Monad.State
import Data.Char (isSpace)

-- | Full name of language.
syntaxName :: String
syntaxName = "Yacc/Bison"

-- | Filename extensions for this language.
syntaxExtensions :: String
syntaxExtensions = "*.y;*.yy"

-- | Highlight source code using this syntax definition.
highlight :: String -> [SourceLine]
highlight input = evalState (mapM parseSourceLine $ lines input) startingState

parseSourceLine :: String -> State SyntaxState SourceLine
parseSourceLine = mkParseSourceLine (parseExpression Nothing)

-- | Parse an expression using appropriate local context.
parseExpression :: Maybe (String,String)
                -> KateParser Token
parseExpression mbcontext = do
  (lang,cont) <- maybe currentContext return mbcontext
  result <- parseRules (lang,cont)
  optional $ do eof
                updateState $ \st -> st{ synStPrevChar = '\n' }
                pEndLine
  return result

startingState = SyntaxState {synStContexts = [("Yacc/Bison","Pre Start")], synStLineNumber = 0, synStPrevChar = '\n', synStPrevNonspace = False, synStCaseSensitive = True, synStKeywordCaseSensitive = True, synStCaptures = []}

pEndLine = do
  updateState $ \st -> st{ synStPrevNonspace = False }
  context <- currentContext
  contexts <- synStContexts `fmap` getState
  if length contexts >= 2
    then case context of
      ("Yacc/Bison","Pre Start") -> return ()
      ("Yacc/Bison","C Declarations") -> return ()
      ("Yacc/Bison","Declarations") -> return ()
      ("Yacc/Bison","Union Start") -> return ()
      ("Yacc/Bison","Union In") -> return ()
      ("Yacc/Bison","Union InIn") -> return ()
      ("Yacc/Bison","Rules") -> return ()
      ("Yacc/Bison","Rule In") -> return ()
      ("Yacc/Bison","User Code") -> return ()
      ("Yacc/Bison","Percent Command") -> (popContext) >> pEndLine
      ("Yacc/Bison","Percent Command In") -> (popContext >> popContext) >> pEndLine
      ("Yacc/Bison","PC type") -> (popContext >> popContext >> popContext) >> pEndLine
      ("Yacc/Bison","Comment") -> return ()
      ("Yacc/Bison","CommentStar") -> return ()
      ("Yacc/Bison","CommentSlash") -> return ()
      ("Yacc/Bison","StringOrChar") -> return ()
      ("Yacc/Bison","String") -> (popContext) >> pEndLine
      ("Yacc/Bison","Char") -> (popContext) >> pEndLine
      ("Yacc/Bison","Normal C Bloc") -> return ()
      ("Yacc/Bison","Dol") -> return ()
      ("Yacc/Bison","DolEnd") -> return ()
      _ -> return ()
    else return ()

withAttribute attr txt = do
  when (null txt) $ fail "Parser matched no text"
  updateState $ \st -> st { synStPrevChar = last txt
                          , synStPrevNonspace = synStPrevNonspace st || not (all isSpace txt) }
  return (attr, txt)


regex_'2e = compileRegex True "."
regex_'5cW = compileRegex True "\\W"
regex_'5b'5e'5c'5c'5d'24 = compileRegex True "[^\\\\]$"
regex_'5c'5c'2e = compileRegex True "\\\\."
regex_'3c'5b'5e'3e'5d'2b'3e = compileRegex True "<[^>]+>"
regex_'5cd'2b = compileRegex True "\\d+"

parseRules ("Yacc/Bison","Pre Start") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pColumn 0 >> pDetect2Chars False '%' '{' >>= withAttribute BaseNTok) >>~ pushContext ("Yacc/Bison","C Declarations"))
   <|>
   ((lookAhead (pRegExpr regex_'2e) >> pushContext ("Yacc/Bison","Declarations") >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Pre Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","C Declarations") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((pColumn 0 >> pDetect2Chars False '%' '}' >>= withAttribute BaseNTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","C Declarations")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Declarations") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((pString False "%union" >>= withAttribute KeywordTok) >>~ pushContext ("Yacc/Bison","Union Start"))
   <|>
   ((pDetect2Chars False '%' '%' >>= withAttribute BaseNTok) >>~ pushContext ("Yacc/Bison","Rules"))
   <|>
   ((pColumn 0 >> pDetect2Chars False '%' '{' >>= withAttribute BaseNTok) >>~ pushContext ("Yacc/Bison","C Declarations"))
   <|>
   ((pDetectChar False '%' >>= withAttribute KeywordTok) >>~ pushContext ("Yacc/Bison","Percent Command"))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Declarations")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Union Start") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((pDetectSpaces >>= withAttribute NormalTok))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Yacc/Bison","Union In"))
   <|>
   ((pRegExpr regex_'2e >>= withAttribute AlertTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Union Start")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Union In") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Yacc/Bison","Union InIn"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext >> popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Union In")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Union InIn") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Yacc/Bison","Union InIn"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Union InIn")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Rules") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((pDetect2Chars False '%' '%' >>= withAttribute BaseNTok) >>~ pushContext ("Yacc/Bison","User Code"))
   <|>
   ((pDetectChar False ':' >>= withAttribute NormalTok) >>~ pushContext ("Yacc/Bison","Rule In"))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Rules")) >> pDefault >>= withAttribute StringTok))

parseRules ("Yacc/Bison","Rule In") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((pDetectChar False ';' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Yacc/Bison","Normal C Bloc"))
   <|>
   ((pDetectChar False '|' >>= withAttribute NormalTok))
   <|>
   ((parseRules ("Yacc/Bison","StringOrChar")))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Rule In")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","User Code") =
  (((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","User Code")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Percent Command") =
  (((parseRules ("Yacc/Bison","Comment")))
   <|>
   ((lookAhead (pRegExpr regex_'5cW) >> pushContext ("Yacc/Bison","Percent Command In") >> currentContext >>= parseRules))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Percent Command")) >> pDefault >>= withAttribute KeywordTok))

parseRules ("Yacc/Bison","Percent Command In") =
  (((parseRules ("Yacc/Bison","StringOrChar")))
   <|>
   ((pDetectChar False '<' >>= withAttribute DataTypeTok) >>~ pushContext ("Yacc/Bison","PC type"))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Percent Command In")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","PC type") =
  (((pDetectChar False '>' >>= withAttribute DataTypeTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","PC type")) >> pDefault >>= withAttribute DataTypeTok))

parseRules ("Yacc/Bison","Comment") =
  (((pDetect2Chars False '/' '*' >>= withAttribute CommentTok) >>~ pushContext ("Yacc/Bison","CommentStar"))
   <|>
   ((pDetect2Chars False '/' '/' >>= withAttribute CommentTok) >>~ pushContext ("Yacc/Bison","CommentSlash"))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Comment")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Yacc/Bison","CommentStar") =
  (((pDetect2Chars False '*' '/' >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","CommentStar")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Yacc/Bison","CommentSlash") =
  (((pRegExpr regex_'5b'5e'5c'5c'5d'24 >>= withAttribute CommentTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","CommentSlash")) >> pDefault >>= withAttribute CommentTok))

parseRules ("Yacc/Bison","StringOrChar") =
  (((pDetectChar False '\'' >>= withAttribute CharTok) >>~ pushContext ("Yacc/Bison","Char"))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ pushContext ("Yacc/Bison","String"))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","StringOrChar")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","String") =
  (((pRegExpr regex_'5c'5c'2e >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '"' >>= withAttribute StringTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","String")) >> pDefault >>= withAttribute StringTok))

parseRules ("Yacc/Bison","Char") =
  (((pRegExpr regex_'5c'5c'2e >>= withAttribute StringTok))
   <|>
   ((pDetectChar False '\'' >>= withAttribute CharTok) >>~ (popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Char")) >> pDefault >>= withAttribute CharTok))

parseRules ("Yacc/Bison","Normal C Bloc") =
  (((pDetectChar False '{' >>= withAttribute NormalTok) >>~ pushContext ("Yacc/Bison","Normal C Bloc"))
   <|>
   ((pDetectChar False '}' >>= withAttribute NormalTok) >>~ (popContext))
   <|>
   ((Text.Highlighting.Kate.Syntax.Cpp.parseExpression (Just ("C++",""))))
   <|>
   ((pDetectChar False '$' >>= withAttribute KeywordTok) >>~ pushContext ("Yacc/Bison","Dol"))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","Normal C Bloc")) >> pDefault >>= withAttribute NormalTok))

parseRules ("Yacc/Bison","Dol") =
  (((pRegExpr regex_'3c'5b'5e'3e'5d'2b'3e >>= withAttribute DataTypeTok) >>~ pushContext ("Yacc/Bison","DolEnd"))
   <|>
   (pushContext ("Yacc/Bison","DolEnd") >> currentContext >>= parseRules))

parseRules ("Yacc/Bison","DolEnd") =
  (((pRegExpr regex_'5cd'2b >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   ((pDetectChar False '$' >>= withAttribute KeywordTok) >>~ (popContext >> popContext))
   <|>
   (currentContext >>= \x -> guard (x == ("Yacc/Bison","DolEnd")) >> pDefault >>= withAttribute NormalTok))

parseRules ("C++", _) = Text.Highlighting.Kate.Syntax.Cpp.parseExpression Nothing

parseRules x = parseRules ("Yacc/Bison","Pre Start") <|> fail ("Unknown context" ++ show x)
