#if the headers are not installed, the newer apis won't be activated

#find which version of SDL we are building against
find_file(sdl_h SDL_version.h ${SDL_INCLUDE_DIR})
if(sdl_h)
    file(STRINGS ${sdl_h} sdl_majorversion_tmp REGEX "SDL_MAJOR_VERSION[\t' ']+[0-9]+")
    file(STRINGS ${sdl_h} sdl_minorversion_tmp REGEX "SDL_MINOR_VERSION[\t' ']+[0-9]+")
    file(STRINGS ${sdl_h} sdl_patchversion_tmp REGEX "SDL_PATCHLEVEL[\t' ']+[0-9]+")
    string(REGEX MATCH ".([0-9]+)" sdl_majorversion "${sdl_majorversion_tmp}")
    string(REGEX MATCH ".([0-9]+)" sdl_minorversion "${sdl_minorversion_tmp}")
    string(REGEX MATCH ".([0-9]+)" sdl_patchversion "${sdl_patchversion_tmp}")
    math(EXPR sdl_version "${sdl_majorversion}*10000 + ${sdl_minorversion}*100 + ${sdl_patchversion}")

    if(NOT (sdl_version LESS "010300"))
        message(STATUS "Enabling SDL-1.3+ calls")
        set(pascal_compiler_flags_cmn "-dSDL13" ${pascal_compiler_flags_cmn})
    endif()
endif()

#find which version of SDL_mixer we have (for Mix_Init)
find_file(sdlmixer_h SDL_mixer.h ${SDLMIXER_INCLUDE_DIR})
if(sdlmixer_h)
    file(STRINGS ${sdlmixer_h} sdlmixer_majorversion_tmp REGEX "SDL_MIXER_MAJOR_VERSION[\t' ']+[0-9]+")
    file(STRINGS ${sdlmixer_h} sdlmixer_minorversion_tmp REGEX "SDL_MIXER_MINOR_VERSION[\t' ']+[0-9]+")
    file(STRINGS ${sdlmixer_h} sdlmixer_patchversion_tmp REGEX "SDL_MIXER_PATCHLEVEL[\t' ']+[0-9]+")
    string(REGEX MATCH ".([0-9]+)" sdlmixer_majorversion "${sdlmixer_majorversion_tmp}")
    string(REGEX MATCH ".([0-9]+)" sdlmixer_minorversion "${sdlmixer_minorversion_tmp}")
    string(REGEX MATCH ".([0-9]+)" sdlmixer_patchversion "${sdlmixer_patchversion_tmp}")
    math(EXPR sdlmixer_version "${sdlmixer_majorversion}*10000 + ${sdlmixer_minorversion}*100 + ${sdlmixer_patchversion}")

    if(sdlmixer_version GREATER "10209")
        message(STATUS "Enabling enhanced SDL_Mixer calls")
        set(pascal_compiler_flags_cmn "-dSDL_MIXER_NEWER" ${pascal_compiler_flags_cmn})
    endif()
endif()

#find which version of SDL_image we have (for IMG_Init)
find_file(sdlimage_h SDL_image.h ${SDLIMAGE_INCLUDE_DIR})
if(sdlimage_h)
    file(STRINGS ${sdlimage_h} sdlimage_majorversion_tmp REGEX "SDL_IMAGE_MAJOR_VERSION[\t' ']+[0-9]+")
    file(STRINGS ${sdlimage_h} sdlimage_minorversion_tmp REGEX "SDL_IMAGE_MINOR_VERSION[\t' ']+[0-9]+")
    file(STRINGS ${sdlimage_h} sdlimage_patchversion_tmp REGEX "SDL_IMAGE_PATCHLEVEL[\t' ']+[0-9]+")
    string(REGEX MATCH ".([0-9]+)" sdlimage_majorversion "${sdlimage_majorversion_tmp}")
    string(REGEX MATCH ".([0-9]+)" sdlimage_minorversion "${sdlimage_minorversion_tmp}")
    string(REGEX MATCH ".([0-9]+)" sdlimage_patchversion "${sdlimage_patchversion_tmp}")
    math(EXPR sdlimage_version "${sdlimage_majorversion}*10000 + ${sdlimage_minorversion}*100 + ${sdlimage_patchversion}")

    if(sdlimage_version GREATER "010207")
        message(STATUS "Enabling enhanced SDL_Image calls")
        set(pascal_compiler_flags_cmn "-dSDL_IMAGE_NEWER" ${pascal_compiler_flags_cmn})
    endif()
endif()

