
//
// $Id: session.h,v 1.2 2001/07/10 01:42:06 dredd Exp $
//
// $Source: /cvsroot/hammerhead/hammerhead/src/session.h,v $
// $Revision: 1.2 $
// $Date: 2001/07/10 01:42:06 $
// $State: Exp $
//
// Session Class
// Purpose: store an "individual"s (simulated) session information
//  One of these per process(thread).
//
// Author: Geoff Wong 1996-2001
// 20010710 Robert Nielson - POST verbose and better cookie handling
//

#ifndef _SESSION_H
#define _SESSION_H

#include <time.h>
#include "hrtime.h"
#include "String.h"
#include "result.h"
#include "if.h"

class Scenario;

class Session
{
    If * altIf;

public:
    long ip_addr;
    int port;
	int ssl_port;
	int hammer_port;
	String machine;
    int pin;

    hrtime_t lastElapsed;
    // nanoseconds to complete last request

    // summary data
    // need to know both change since last summary, and total figures
    
    long requestCnt;
    // number of requests since last summary

    long noResultCnt;
    // number of requests returning no result since last summary

    long noVerifyCnt;
    // number of requests not verified since last summary
 
    hrtime_t elapsedSubTot;
    // nanoseconds to complete last requestCnt requests

    long requestTot;
    // total number of requests

    long noResultTot;
    // total number of no result requests

    long noVerifyTot;
    // total number of not verified requests

    hrtime_t elapsedTot;
    // nanoseconds to complete all requests

    list<String> cookie_list;
    // cookie lines (zero or more)

    Scenario *scenario;
    // current scenario for session

    void printSummary(void);
    void printSummary(Scenario * scn);
    void printSummary(Scenario * scn, Result *res);

    void AltInterface(long altif);
    // Setup the session to run with an alternate (IP aliased) interface
    
    If * Interface();
    // Get the interface data.

    Session();
    Session(int);

};


#endif
