Module: gtk-internal

c-include("stddef.h");
c-include("gtk/gtk.h");
define functional class <GtkBox*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkBox*>));

define constant <GtkReliefStyle> = <integer>;
define constant $GTK-RELIEF-NORMAL = 0;
define constant $GTK-RELIEF-HALF = 1;
define constant $GTK-RELIEF-NONE = 2;

define functional class <GtkHRuler*> (<GtkRuler*>) end;
define sealed domain make(singleton(<GtkHRuler*>));

define functional class <GtkList*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkList*>));

define constant <GtkCellType> = <integer>;
define constant $GTK-CELL-EMPTY = 0;
define constant $GTK-CELL-TEXT = 1;
define constant $GTK-CELL-PIXMAP = 2;
define constant $GTK-CELL-PIXTEXT = 3;
define constant $GTK-CELL-WIDGET = 4;

define functional class <GtkFileSelection*> (<GtkWindow*>) end;
define sealed domain make(singleton(<GtkFileSelection*>));

define open generic dir-list-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic dir-list-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method dir-list-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "dir_list"));
end;

define method dir-list-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "dir_list")
 := value.raw-value;
  value;
end;

define open generic file-list-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic file-list-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method file-list-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "file_list"));
end;

define method file-list-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "file_list")
 := value.raw-value;
  value;
end;

define open generic selection-entry-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic selection-entry-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method selection-entry-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "selection_entry"));
end;

define method selection-entry-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "selection_entry")
 := value.raw-value;
  value;
end;

define open generic selection-text-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic selection-text-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method selection-text-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "selection_text"));
end;

define method selection-text-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "selection_text")
 := value.raw-value;
  value;
end;

define open generic main-vbox-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic main-vbox-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method main-vbox-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "main_vbox"));
end;

define method main-vbox-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "main_vbox")
 := value.raw-value;
  value;
end;

define open generic ok-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic ok-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method ok-button-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "ok_button"));
end;

define method ok-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "ok_button")
 := value.raw-value;
  value;
end;

define open generic cancel-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic cancel-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method cancel-button-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "cancel_button"));
end;

define method cancel-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "cancel_button")
 := value.raw-value;
  value;
end;

define open generic help-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic help-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method help-button-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "help_button"));
end;

define method help-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "help_button")
 := value.raw-value;
  value;
end;

define open generic action-area-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic action-area-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method action-area-value
    (obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFileSelection", "action_area"));
end;

define method action-area-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFileSelection*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFileSelection", "action_area")
 := value.raw-value;
  value;
end;

define functional class <GtkTearoffMenuItem*> (<GtkMenuItem*>) end;
define sealed domain make(singleton(<GtkTearoffMenuItem*>));

define functional class <GtkWindow*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkWindow*>));

define functional class <GtkStyle*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkStyle*>));

define open generic fg-gc-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method fg-gc-value
    (obj :: <GtkStyle*>)
 => (value :: <GdkGC**>);
  make(<GdkGC**>,
       pointer: obj.raw-value
                  + c-expr(int:, "offsetof(GtkStyle, fg_gc)"));
end;

define open generic bg-gc-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method bg-gc-value
    (obj :: <GtkStyle*>)
 => (value :: <GdkGC**>);
  make(<GdkGC**>,
       pointer: obj.raw-value
                  + c-expr(int:, "offsetof(GtkStyle, bg_gc)"));
end;

define open generic white-gc-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic white-gc-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method white-gc-value
    (obj :: <GtkStyle*>)
 => (value :: <GdkGC*>);
  make(<GdkGC*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkStyle", "white_gc"));
end;

define method white-gc-value-setter
    (value :: <GdkGC*>, obj :: <GtkStyle*>)
 => (value :: <GdkGC*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkStyle", "white_gc")
 := value.raw-value;
  value;
end;

define open generic black-gc-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic black-gc-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method black-gc-value
    (obj :: <GtkStyle*>)
 => (value :: <GdkGC*>);
  make(<GdkGC*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkStyle", "black_gc"));
end;

define method black-gc-value-setter
    (value :: <GdkGC*>, obj :: <GtkStyle*>)
 => (value :: <GdkGC*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkStyle", "black_gc")
 := value.raw-value;
  value;
end;

define functional class <GtkHScale*> (<GtkScale*>) end;
define sealed domain make(singleton(<GtkHScale*>));

define functional class <GtkHBox*> (<GtkBox*>) end;
define sealed domain make(singleton(<GtkHBox*>));

define constant <GtkMenuFactoryType> = <integer>;
define constant $GTK-MENU-FACTORY-MENU = 0;
define constant $GTK-MENU-FACTORY-MENU-BAR = 1;
define constant $GTK-MENU-FACTORY-OPTION-MENU = 2;

define functional class <GtkScrolledWindow*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkScrolledWindow*>));

define functional class <GtkAdjustment*> (<GtkData*>) end;
define sealed domain make(singleton(<GtkAdjustment*>));

define open generic value-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic value-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method value-value
    (obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "value");
end;

define method value-value-setter
    (value :: <gfloat>, obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "value") := value;
end;

define open generic lower-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic lower-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method lower-value
    (obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "lower");
end;

define method lower-value-setter
    (value :: <gfloat>, obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "lower") := value;
end;

define open generic upper-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic upper-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method upper-value
    (obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "upper");
end;

define method upper-value-setter
    (value :: <gfloat>, obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "upper") := value;
end;

define open generic step-increment-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic step-increment-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method step-increment-value
    (obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "step_increment");
end;

define method step-increment-value-setter
    (value :: <gfloat>, obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "step_increment") := value;
end;

define open generic page-increment-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic page-increment-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method page-increment-value
    (obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "page_increment");
end;

define method page-increment-value-setter
    (value :: <gfloat>, obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "page_increment") := value;
end;

define open generic page-size-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic page-size-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method page-size-value
    (obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "page_size");
end;

define method page-size-value-setter
    (value :: <gfloat>, obj :: <GtkAdjustment*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkAdjustment", "page_size") := value;
end;

define functional class <GtkFontSelectionDialog*> (<GtkWindow*>) end;
define sealed domain make(singleton(<GtkFontSelectionDialog*>));

define method main-vbox-value
    (obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFontSelectionDialog", "main_vbox"));
end;

define method main-vbox-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFontSelectionDialog", "main_vbox")
 := value.raw-value;
  value;
end;

define method action-area-value
    (obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFontSelectionDialog", "action_area"));
end;

define method action-area-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFontSelectionDialog", "action_area")
 := value.raw-value;
  value;
end;

define method ok-button-value
    (obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFontSelectionDialog", "ok_button"));
end;

define method ok-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFontSelectionDialog", "ok_button")
 := value.raw-value;
  value;
end;

define open generic apply-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic apply-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method apply-button-value
    (obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFontSelectionDialog", "apply_button"));
end;

define method apply-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFontSelectionDialog", "apply_button")
 := value.raw-value;
  value;
end;

define method cancel-button-value
    (obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkFontSelectionDialog", "cancel_button"));
end;

define method cancel-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkFontSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkFontSelectionDialog", "cancel_button")
 := value.raw-value;
  value;
end;

define constant <GtkUpdateType> = <integer>;
define constant $GTK-UPDATE-CONTINUOUS = 0;
define constant $GTK-UPDATE-DISCONTINUOUS = 1;
define constant $GTK-UPDATE-DELAYED = 2;

define constant <GtkSubmenuDirection> = <integer>;
define constant $GTK-DIRECTION-LEFT = 0;
define constant $GTK-DIRECTION-RIGHT = 1;

define functional class <GtkTipsQuery*> (<GtkLabel*>) end;
define sealed domain make(singleton(<GtkTipsQuery*>));

define functional class <GtkVScrollbar*> (<GtkScrollbar*>) end;
define sealed domain make(singleton(<GtkVScrollbar*>));

define constant <GtkTreeViewMode> = <integer>;
define constant $GTK-TREE-VIEW-LINE = 0;
define constant $GTK-TREE-VIEW-ITEM = 1;

define constant <GtkCurveType> = <integer>;
define constant $GTK-CURVE-TYPE-LINEAR = 0;
define constant $GTK-CURVE-TYPE-SPLINE = 1;
define constant $GTK-CURVE-TYPE-FREE = 2;

define constant <GtkPreviewType> = <integer>;
define constant $GTK-PREVIEW-COLOR = 0;
define constant $GTK-PREVIEW-GRAYSCALE = 1;

define functional class <GtkRequisition*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkRequisition*>));

define sealed method content-size
    (class == <GtkRequisition*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GtkRequisition)");
end method;

define method width-value
    (obj :: <GtkRequisition*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkRequisition", "width");
end;

define method width-value-setter
    (value :: <gint>, obj :: <GtkRequisition*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkRequisition", "width") := value;
end;

define method height-value
    (obj :: <GtkRequisition*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkRequisition", "height");
end;

define method height-value-setter
    (value :: <gint>, obj :: <GtkRequisition*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkRequisition", "height") := value;
end;

define constant <GtkButtonBoxStyle> = <integer>;
define constant $GTK-BUTTONBOX-DEFAULT-STYLE = 0;
define constant $GTK-BUTTONBOX-SPREAD = 1;
define constant $GTK-BUTTONBOX-EDGE = 2;
define constant $GTK-BUTTONBOX-START = 3;
define constant $GTK-BUTTONBOX-END = 4;

define constant <GtkAccelFlags> = <integer>;
define constant $GTK-ACCEL-VISIBLE = 1;
define constant $GTK-ACCEL-SIGNAL-VISIBLE = 2;
define constant $GTK-ACCEL-LOCKED = 4;

define constant <GtkAnchorType> = <integer>;
define constant $GTK-ANCHOR-CENTER = 0;
define constant $GTK-ANCHOR-NORTH = 1;
define constant $GTK-ANCHOR-NORTH-WEST = 2;
define constant $GTK-ANCHOR-NORTH-EAST = 3;
define constant $GTK-ANCHOR-SOUTH = 4;
define constant $GTK-ANCHOR-SOUTH-WEST = 5;
define constant $GTK-ANCHOR-SOUTH-EAST = 6;
define constant $GTK-ANCHOR-WEST = 7;
define constant $GTK-ANCHOR-EAST = 8;

define functional class <GtkVButtonBox*> (<GtkButtonBox*>) end;
define sealed domain make(singleton(<GtkVButtonBox*>));

define functional class <GtkToggleButton*> (<GtkButton*>) end;
define sealed domain make(singleton(<GtkToggleButton*>));

define open generic active-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic active-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method active-value
    (obj :: <GtkToggleButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkToggleButton", "active");
end;

define method active-value-setter
    (value :: <gboolean>, obj :: <GtkToggleButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkToggleButton", "active") := value;
end;

define open generic draw-indicator-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic draw-indicator-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method draw-indicator-value
    (obj :: <GtkToggleButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkToggleButton", "draw_indicator");
end;

define method draw-indicator-value-setter
    (value :: <gboolean>, obj :: <GtkToggleButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkToggleButton", "draw_indicator") := value;
end;

define functional class <GtkScale*> (<GtkRange*>) end;
define sealed domain make(singleton(<GtkScale*>));

define constant <GtkVisibility> = <integer>;
define constant $GTK-VISIBILITY-NONE = 0;
define constant $GTK-VISIBILITY-PARTIAL = 1;
define constant $GTK-VISIBILITY-FULL = 2;

define functional class <GtkMenuShell*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkMenuShell*>));

define functional class <GtkItem*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkItem*>));

define constant <GtkDirectionType> = <integer>;
define constant $GTK-DIR-TAB-FORWARD = 0;
define constant $GTK-DIR-TAB-BACKWARD = 1;
define constant $GTK-DIR-UP = 2;
define constant $GTK-DIR-DOWN = 3;
define constant $GTK-DIR-LEFT = 4;
define constant $GTK-DIR-RIGHT = 5;

define functional class <GtkHSeparator*> (<GtkSeparator*>) end;
define sealed domain make(singleton(<GtkHSeparator*>));

define functional class <GtkItemFactory*> (<GtkObject*>) end;
define sealed domain make(singleton(<GtkItemFactory*>));

define functional class <GtkDialog*> (<GtkWindow*>) end;
define sealed domain make(singleton(<GtkDialog*>));

define open generic vbox-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic vbox-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method vbox-value
    (obj :: <GtkDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkDialog", "vbox"));
end;

define method vbox-value-setter
    (value :: <GtkWidget*>, obj :: <GtkDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkDialog", "vbox")
 := value.raw-value;
  value;
end;

define method action-area-value
    (obj :: <GtkDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkDialog", "action_area"));
end;

define method action-area-value-setter
    (value :: <GtkWidget*>, obj :: <GtkDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkDialog", "action_area")
 := value.raw-value;
  value;
end;

define functional class <GtkMenu*> (<GtkMenuShell*>) end;
define sealed domain make(singleton(<GtkMenu*>));

define constant <GtkTroughType> = <integer>;
define constant $GTK-TROUGH-NONE = 0;
define constant $GTK-TROUGH-START = 1;
define constant $GTK-TROUGH-END = 2;

define functional class <GtkTreeItem*> (<GtkItem*>) end;
define sealed domain make(singleton(<GtkTreeItem*>));

define functional class <GtkViewport*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkViewport*>));

define constant <GtkJustification> = <integer>;
define constant $GTK-JUSTIFY-LEFT = 0;
define constant $GTK-JUSTIFY-RIGHT = 1;
define constant $GTK-JUSTIFY-CENTER = 2;
define constant $GTK-JUSTIFY-FILL = 3;

define functional class <GtkText*> (<GtkEditable*>) end;
define sealed domain make(singleton(<GtkText*>));

define open generic hadj-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic hadj-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method hadj-value
    (obj :: <GtkText*>)
 => (value :: <GtkAdjustment*>);
  make(<GtkAdjustment*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkText", "hadj"));
end;

define method hadj-value-setter
    (value :: <GtkAdjustment*>, obj :: <GtkText*>)
 => (value :: <GtkAdjustment*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkText", "hadj")
 := value.raw-value;
  value;
end;

define open generic vadj-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic vadj-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method vadj-value
    (obj :: <GtkText*>)
 => (value :: <GtkAdjustment*>);
  make(<GtkAdjustment*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkText", "vadj"));
end;

define method vadj-value-setter
    (value :: <GtkAdjustment*>, obj :: <GtkText*>)
 => (value :: <GtkAdjustment*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkText", "vadj")
 := value.raw-value;
  value;
end;

define functional class <GtkNotebook*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkNotebook*>));

define functional class <GtkCList*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkCList*>));

define open generic selection-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic selection-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method selection-value
    (obj :: <GtkCList*>)
 => (value :: <GList*>);
  make(<GList*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkCList", "selection"));
end;

define method selection-value-setter
    (value :: <GList*>, obj :: <GtkCList*>)
 => (value :: <GList*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkCList", "selection")
 := value.raw-value;
  value;
end;

define functional class <GtkTable*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkTable*>));

define constant <GtkSortType> = <integer>;
define constant $GTK-SORT-ASCENDING = 0;
define constant $GTK-SORT-DESCENDING = 1;

define functional class <GtkHScrollbar*> (<GtkScrollbar*>) end;
define sealed domain make(singleton(<GtkHScrollbar*>));

define functional class <GtkPreview*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkPreview*>));

define constant <GtkOrientation> = <integer>;
define constant $GTK-ORIENTATION-HORIZONTAL = 0;
define constant $GTK-ORIENTATION-VERTICAL = 1;

define functional class <GtkAccelGroup*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkAccelGroup*>));

define functional class <GtkEventBox*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkEventBox*>));

define functional class <GtkVScale*> (<GtkScale*>) end;
define sealed domain make(singleton(<GtkVScale*>));

define functional class <GtkArg*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkArg*>));

define constant <GtkCTreePos> = <integer>;
define constant $GTK-CTREE-POS-BEFORE = 0;
define constant $GTK-CTREE-POS-AS-CHILD = 1;
define constant $GTK-CTREE-POS-AFTER = 2;

define functional class <GtkColorSelectionDialog*> (<GtkWindow*>) end;
define sealed domain make(singleton(<GtkColorSelectionDialog*>));

define open generic colorsel-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic colorsel-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method colorsel-value
    (obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkColorSelectionDialog", "colorsel"));
end;

define method colorsel-value-setter
    (value :: <GtkWidget*>, obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkColorSelectionDialog", "colorsel")
 := value.raw-value;
  value;
end;

define method main-vbox-value
    (obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkColorSelectionDialog", "main_vbox"));
end;

define method main-vbox-value-setter
    (value :: <GtkWidget*>, obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkColorSelectionDialog", "main_vbox")
 := value.raw-value;
  value;
end;

define method ok-button-value
    (obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkColorSelectionDialog", "ok_button"));
end;

define method ok-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkColorSelectionDialog", "ok_button")
 := value.raw-value;
  value;
end;

define open generic reset-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic reset-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method reset-button-value
    (obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkColorSelectionDialog", "reset_button"));
end;

define method reset-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkColorSelectionDialog", "reset_button")
 := value.raw-value;
  value;
end;

define method cancel-button-value
    (obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkColorSelectionDialog", "cancel_button"));
end;

define method cancel-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkColorSelectionDialog", "cancel_button")
 := value.raw-value;
  value;
end;

define method help-button-value
    (obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkColorSelectionDialog", "help_button"));
end;

define method help-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkColorSelectionDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkColorSelectionDialog", "help_button")
 := value.raw-value;
  value;
end;

define functional class <GtkRange*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkRange*>));

define functional class <GtkSpinButton*> (<GtkEntry*>) end;
define sealed domain make(singleton(<GtkSpinButton*>));

define constant <GtkArrowType> = <integer>;
define constant $GTK-ARROW-UP = 0;
define constant $GTK-ARROW-DOWN = 1;
define constant $GTK-ARROW-LEFT = 2;
define constant $GTK-ARROW-RIGHT = 3;

define functional class <GtkNotebookPage*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkNotebookPage*>));

define functional class <GtkPaned*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkPaned*>));

define functional class <GtkLabel*> (<GtkMisc*>) end;
define sealed domain make(singleton(<GtkLabel*>));

define functional class <GtkBin*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkBin*>));

define open generic child-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic child-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method child-value
    (obj :: <GtkBin*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkBin", "child"));
end;

define method child-value-setter
    (value :: <GtkWidget*>, obj :: <GtkBin*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkBin", "child")
 := value.raw-value;
  value;
end;

define constant <GtkPolicyType> = <integer>;
define constant $GTK-POLICY-ALWAYS = 0;
define constant $GTK-POLICY-AUTOMATIC = 1;

define functional class <GtkScrollbar*> (<GtkRange*>) end;
define sealed domain make(singleton(<GtkScrollbar*>));

define functional class <GtkCheckMenuItem*> (<GtkMenuItem*>) end;
define sealed domain make(singleton(<GtkCheckMenuItem*>));

define method active-value
    (obj :: <GtkCheckMenuItem*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkCheckMenuItem", "active");
end;

define method active-value-setter
    (value :: <gboolean>, obj :: <GtkCheckMenuItem*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkCheckMenuItem", "active") := value;
end;

define functional class <GtkOptionMenu*> (<GtkButton*>) end;
define sealed domain make(singleton(<GtkOptionMenu*>));

define functional class <GtkProgressBar*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkProgressBar*>));

define functional class <GtkAlignment*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkAlignment*>));

define functional class <GtkContainer*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkContainer*>));

define functional class <GtkTree*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkTree*>));

define functional class <GtkHButtonBox*> (<GtkButtonBox*>) end;
define sealed domain make(singleton(<GtkHButtonBox*>));

define constant <GtkSubmenuPlacement> = <integer>;
define constant $GTK-TOP-BOTTOM = 0;
define constant $GTK-LEFT-RIGHT = 1;

define functional class <GtkVRuler*> (<GtkRuler*>) end;
define sealed domain make(singleton(<GtkVRuler*>));

define functional class <GtkButtonBox*> (<GtkBox*>) end;
define sealed domain make(singleton(<GtkButtonBox*>));

define constant <GtkSignalRunType> = <integer>;
define constant $GTK-RUN-FIRST = 1;
define constant $GTK-RUN-LAST = 2;
define constant $GTK-RUN-BOTH = 3;
define constant $GTK-RUN-NO-RECURSE = 4;
define constant $GTK-RUN-ACTION = 8;
define constant $GTK-RUN-NO-HOOKS = 16;

define functional class <GtkSeparator*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkSeparator*>));

define constant <GtkCTreeLineStyle> = <integer>;
define constant $GTK-CTREE-LINES-NONE = 0;
define constant $GTK-CTREE-LINES-SOLID = 1;
define constant $GTK-CTREE-LINES-DOTTED = 2;
define constant $GTK-CTREE-LINES-TABBED = 3;

define constant <GtkSpinButtonUpdatePolicy> = <integer>;
define constant $GTK-UPDATE-ALWAYS = 0;
define constant $GTK-UPDATE-IF-VALID = 1;

define functional class <GtkMenuBar*> (<GtkMenuShell*>) end;
define sealed domain make(singleton(<GtkMenuBar*>));

define functional class <GtkLayout*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkLayout*>));

define functional class <GtkFixed*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkFixed*>));

define functional class <GtkVSeparator*> (<GtkSeparator*>) end;
define sealed domain make(singleton(<GtkVSeparator*>));

define functional class <GtkAllocation*> (<indexable-statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkAllocation*>));

define sealed method content-size
    (class == <GtkAllocation*>) => (size :: <integer>);
  c-expr(int:, "sizeof(GtkAllocation)");
end method;

define method x-value
    (obj :: <GtkAllocation*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "x");
end;

define method x-value-setter
    (value :: <gint>, obj :: <GtkAllocation*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "x") := value;
end;

define method y-value
    (obj :: <GtkAllocation*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "y");
end;

define method y-value-setter
    (value :: <gint>, obj :: <GtkAllocation*>)
 => (value :: <gint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "y") := value;
end;

define method width-value
    (obj :: <GtkAllocation*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "width");
end;

define method width-value-setter
    (value :: <guint>, obj :: <GtkAllocation*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "width") := value;
end;

define method height-value
    (obj :: <GtkAllocation*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "height");
end;

define method height-value-setter
    (value :: <guint>, obj :: <GtkAllocation*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkAllocation", "height") := value;
end;

define constant <GtkWidgetFlags> = <integer>;
define constant $GTK-TOPLEVEL = 16;
define constant $GTK-NO-WINDOW = 32;
define constant $GTK-REALIZED = 64;
define constant $GTK-MAPPED = 128;
define constant $GTK-VISIBLE = 256;
define constant $GTK-SENSITIVE = 512;
define constant $GTK-PARENT-SENSITIVE = 1024;
define constant $GTK-CAN-FOCUS = 2048;
define constant $GTK-HAS-FOCUS = 4096;
define constant $GTK-CAN-DEFAULT = 8192;
define constant $GTK-HAS-DEFAULT = 16384;
define constant $GTK-HAS-GRAB = 32768;
define constant $GTK-RC-STYLE = 65536;
define constant $GTK-COMPOSITE-CHILD = 131072;

define constant <GtkWindowType> = <integer>;
define constant $GTK-WINDOW-TOPLEVEL = 0;
define constant $GTK-WINDOW-DIALOG = 1;
define constant $GTK-WINDOW-POPUP = 2;

define constant <GtkWindowPosition> = <integer>;
define constant $GTK-WIN-POS-NONE = 0;
define constant $GTK-WIN-POS-CENTER = 1;
define constant $GTK-WIN-POS-MOUSE = 2;

define functional class <GtkVPaned*> (<GtkPaned*>) end;
define sealed domain make(singleton(<GtkVPaned*>));

define functional class <GtkInputDialog*> (<GtkDialog*>) end;
define sealed domain make(singleton(<GtkInputDialog*>));

define open generic close-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic close-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method close-button-value
    (obj :: <GtkInputDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkInputDialog", "close_button"));
end;

define method close-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkInputDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkInputDialog", "close_button")
 := value.raw-value;
  value;
end;

define open generic save-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic save-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method save-button-value
    (obj :: <GtkInputDialog*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkInputDialog", "save_button"));
end;

define method save-button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkInputDialog*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkInputDialog", "save_button")
 := value.raw-value;
  value;
end;

define functional class <GtkColorSelection*> (<GtkVBox*>) end;
define sealed domain make(singleton(<GtkColorSelection*>));

define functional class <GtkDrawingArea*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkDrawingArea*>));

define constant <GtkAttachOptions> = <integer>;
define constant $GTK-EXPAND = 1;
define constant $GTK-SHRINK = 2;
define constant $GTK-FILL = 4;

define functional class <GtkCurve*> (<GtkDrawingArea*>) end;
define sealed domain make(singleton(<GtkCurve*>));

define functional class <GtkToolbar*> (<GtkContainer*>) end;
define sealed domain make(singleton(<GtkToolbar*>));

define functional class <GtkButton*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkButton*>));

define open generic in-button-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic in-button-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method in-button-value
    (obj :: <GtkButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkButton", "in_button");
end;

define method in-button-value-setter
    (value :: <gboolean>, obj :: <GtkButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkButton", "in_button") := value;
end;

define open generic button-down-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic button-down-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method button-down-value
    (obj :: <GtkButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkButton", "button_down");
end;

define method button-down-value-setter
    (value :: <gboolean>, obj :: <GtkButton*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkButton", "button_down") := value;
end;

define constant <GtkStateType> = <integer>;
define constant $GTK-STATE-NORMAL = 0;
define constant $GTK-STATE-ACTIVE = 1;
define constant $GTK-STATE-PRELIGHT = 2;
define constant $GTK-STATE-SELECTED = 3;
define constant $GTK-STATE-INSENSITIVE = 4;

define functional class <GtkRadioButton*> (<GtkCheckButton*>) end;
define sealed domain make(singleton(<GtkRadioButton*>));

define functional class <GtkVBox*> (<GtkBox*>) end;
define sealed domain make(singleton(<GtkVBox*>));

define functional class <GtkStatusbar*> (<GtkHBox*>) end;
define sealed domain make(singleton(<GtkStatusbar*>));

define functional class <GtkHandleBox*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkHandleBox*>));

define functional class <GtkListItem*> (<GtkItem*>) end;
define sealed domain make(singleton(<GtkListItem*>));

define functional class <GtkCalendar*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkCalendar*>));

define functional class <GtkArrow*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkArrow*>));

define functional class <GtkEditable*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkEditable*>));

define open generic current-pos-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic current-pos-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method current-pos-value
    (obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "current_pos");
end;

define method current-pos-value-setter
    (value :: <guint>, obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "current_pos") := value;
end;

define open generic selection-start-pos-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic selection-start-pos-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method selection-start-pos-value
    (obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "selection_start_pos");
end;

define method selection-start-pos-value-setter
    (value :: <guint>, obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "selection_start_pos") := value;
end;

define open generic selection-end-pos-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic selection-end-pos-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method selection-end-pos-value
    (obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "selection_end_pos");
end;

define method selection-end-pos-value-setter
    (value :: <guint>, obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "selection_end_pos") := value;
end;

define open generic has-selection-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic has-selection-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method has-selection-value
    (obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "has_selection");
end;

define method has-selection-value-setter
    (value :: <guint>, obj :: <GtkEditable*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkEditable", "has_selection") := value;
end;

define constant <GtkArgFlags> = <integer>;
define constant $GTK-ARG-READABLE = 1;
define constant $GTK-ARG-WRITABLE = 2;
define constant $GTK-ARG-CONSTRUCT = 4;
define constant $GTK-ARG-CONSTRUCT-ONLY = 8;
define constant $GTK-ARG-CHILD-ARG = 16;
define constant $GTK-ARG-READWRITE = 3;

define constant <GtkPositionType> = <integer>;
define constant $GTK-POS-LEFT = 0;
define constant $GTK-POS-RIGHT = 1;
define constant $GTK-POS-TOP = 2;
define constant $GTK-POS-BOTTOM = 3;

define functional class <GtkAspectFrame*> (<GtkFrame*>) end;
define sealed domain make(singleton(<GtkAspectFrame*>));

define functional class <GtkRuler*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkRuler*>));

define functional class <GtkFrame*> (<GtkBin*>) end;
define sealed domain make(singleton(<GtkFrame*>));

define constant <GtkShadowType> = <integer>;
define constant $GTK-SHADOW-NONE = 0;
define constant $GTK-SHADOW-IN = 1;
define constant $GTK-SHADOW-OUT = 2;
define constant $GTK-SHADOW-ETCHED-IN = 3;
define constant $GTK-SHADOW-ETCHED-OUT = 4;

define constant <GtkToolbarSpaceStyle> = <integer>;
define constant $GTK-TOOLBAR-SPACE-EMPTY = 0;
define constant $GTK-TOOLBAR-SPACE-LINE = 1;

define functional class <GtkAccelLabel*> (<GtkLabel*>) end;
define sealed domain make(singleton(<GtkAccelLabel*>));

define functional class <GtkRadioMenuItem*> (<GtkCheckMenuItem*>) end;
define sealed domain make(singleton(<GtkRadioMenuItem*>));

define functional class <GtkProgress*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkProgress*>));

define constant <GtkSpinType> = <integer>;
define constant $GTK-SPIN-STEP-FORWARD = 0;
define constant $GTK-SPIN-STEP-BACKWARD = 1;
define constant $GTK-SPIN-PAGE-FORWARD = 2;
define constant $GTK-SPIN-PAGE-BACKWARD = 3;
define constant $GTK-SPIN-HOME = 4;
define constant $GTK-SPIN-END = 5;
define constant $GTK-SPIN-USER-DEFINED = 6;

define functional class <GtkGammaCurve*> (<GtkVBox*>) end;
define sealed domain make(singleton(<GtkGammaCurve*>));

define open generic table-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic table-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method table-value
    (obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkGammaCurve", "table"));
end;

define method table-value-setter
    (value :: <GtkWidget*>, obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkGammaCurve", "table")
 := value.raw-value;
  value;
end;

define open generic curve-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic curve-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method curve-value
    (obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkGammaCurve", "curve"));
end;

define method curve-value-setter
    (value :: <GtkWidget*>, obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkGammaCurve", "curve")
 := value.raw-value;
  value;
end;

define open generic gamma-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic gamma-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method gamma-value
    (obj :: <GtkGammaCurve*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkGammaCurve", "gamma");
end;

define method gamma-value-setter
    (value :: <gfloat>, obj :: <GtkGammaCurve*>)
 => (value :: <gfloat>);
  c-struct-field(float:, obj.raw-value,
                 "GtkGammaCurve", "gamma") := value;
end;

define open generic gamma-dialog-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic gamma-dialog-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method gamma-dialog-value
    (obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkGammaCurve", "gamma_dialog"));
end;

define method gamma-dialog-value-setter
    (value :: <GtkWidget*>, obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkGammaCurve", "gamma_dialog")
 := value.raw-value;
  value;
end;

define open generic gamma-text-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic gamma-text-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method gamma-text-value
    (obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkGammaCurve", "gamma_text"));
end;

define method gamma-text-value-setter
    (value :: <GtkWidget*>, obj :: <GtkGammaCurve*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkGammaCurve", "gamma_text")
 := value.raw-value;
  value;
end;

define functional class <GtkMenuItem*> (<GtkItem*>) end;
define sealed domain make(singleton(<GtkMenuItem*>));

define open generic submenu-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic submenu-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method submenu-value
    (obj :: <GtkMenuItem*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkMenuItem", "submenu"));
end;

define method submenu-value-setter
    (value :: <GtkWidget*>, obj :: <GtkMenuItem*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkMenuItem", "submenu")
 := value.raw-value;
  value;
end;

define constant <GtkSelectionMode> = <integer>;
define constant $GTK-SELECTION-SINGLE = 0;
define constant $GTK-SELECTION-BROWSE = 1;
define constant $GTK-SELECTION-MULTIPLE = 2;
define constant $GTK-SELECTION-EXTENDED = 3;

define constant <GtkToolbarStyle> = <integer>;
define constant $GTK-TOOLBAR-ICONS = 0;
define constant $GTK-TOOLBAR-TEXT = 1;
define constant $GTK-TOOLBAR-BOTH = 2;

define functional class <GtkPlug*> (<GtkWindow*>) end;
define sealed domain make(singleton(<GtkPlug*>));

define open generic socket-window-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic socket-window-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method socket-window-value
    (obj :: <GtkPlug*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkPlug", "socket_window"));
end;

define method socket-window-value-setter
    (value :: <GdkWindow*>, obj :: <GtkPlug*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkPlug", "socket_window")
 := value.raw-value;
  value;
end;

define open generic same-app-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic same-app-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method same-app-value
    (obj :: <GtkPlug*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkPlug", "same_app");
end;

define method same-app-value-setter
    (value :: <gboolean>, obj :: <GtkPlug*>)
 => (value :: <gboolean>);
  c-struct-field(int:, obj.raw-value,
                 "GtkPlug", "same_app") := value;
end;

define constant <GtkResizeMode> = <integer>;
define constant $GTK-RESIZE-PARENT = 0;
define constant $GTK-RESIZE-QUEUE = 1;
define constant $GTK-RESIZE-IMMEDIATE = 2;

define functional class <GtkEntry*> (<GtkEditable*>) end;
define sealed domain make(singleton(<GtkEntry*>));

define functional class <GtkData*> (<GtkObject*>) end;
define sealed domain make(singleton(<GtkData*>));

define functional class <GtkTooltips*> (<GtkData*>) end;
define sealed domain make(singleton(<GtkTooltips*>));

define constant <GtkMetricType> = <integer>;
define constant $GTK-PIXELS = 0;
define constant $GTK-INCHES = 1;
define constant $GTK-CENTIMETERS = 2;

define constant <GtkToolbarChildType> = <integer>;
define constant $GTK-TOOLBAR-CHILD-SPACE = 0;
define constant $GTK-TOOLBAR-CHILD-BUTTON = 1;
define constant $GTK-TOOLBAR-CHILD-TOGGLEBUTTON = 2;
define constant $GTK-TOOLBAR-CHILD-RADIOBUTTON = 3;
define constant $GTK-TOOLBAR-CHILD-WIDGET = 4;

define constant <GtkPackType> = <integer>;
define constant $GTK-PACK-START = 0;
define constant $GTK-PACK-END = 1;

define constant <GtkScrollType> = <integer>;
define constant $GTK-SCROLL-NONE = 0;
define constant $GTK-SCROLL-STEP-BACKWARD = 1;
define constant $GTK-SCROLL-STEP-FORWARD = 2;
define constant $GTK-SCROLL-PAGE-BACKWARD = 3;
define constant $GTK-SCROLL-PAGE-FORWARD = 4;

define constant <GtkFundamentalType> = <integer>;
define constant $GTK-TYPE-INVALID = 0;
define constant $GTK-TYPE-NONE = 1;
define constant $GTK-TYPE-CHAR = 2;
define constant $GTK-TYPE-BOOL = 4;
define constant $GTK-TYPE-INT = 5;
define constant $GTK-TYPE-UINT = 6;
define constant $GTK-TYPE-LONG = 7;
define constant $GTK-TYPE-ULONG = 8;
define constant $GTK-TYPE-FLOAT = 9;
define constant $GTK-TYPE-STRING = 11;
define constant $GTK-TYPE-ENUM = 12;
define constant $GTK-TYPE-FLAGS = 13;
define constant $GTK-TYPE-BOXED = 14;
define constant $GTK-TYPE-FOREIGN = 20;
define constant $GTK-TYPE-CALLBACK = 18;
define constant $GTK-TYPE-ARGS = 17;
define constant $GTK-TYPE-POINTER = 15;
define constant $GTK-TYPE-SIGNAL = 16;
define constant $GTK-TYPE-C-CALLBACK = 19;
define constant $GTK-TYPE-OBJECT = 21;

define functional class <GtkHPaned*> (<GtkPaned*>) end;
define sealed domain make(singleton(<GtkHPaned*>));

define functional class <GtkCombo*> (<GtkHBox*>) end;
define sealed domain make(singleton(<GtkCombo*>));

define open generic entry-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic entry-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method entry-value
    (obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkCombo", "entry"));
end;

define method entry-value-setter
    (value :: <GtkWidget*>, obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkCombo", "entry")
 := value.raw-value;
  value;
end;

define method button-value
    (obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkCombo", "button"));
end;

define method button-value-setter
    (value :: <GtkWidget*>, obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkCombo", "button")
 := value.raw-value;
  value;
end;

define open generic popup-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic popup-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method popup-value
    (obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkCombo", "popup"));
end;

define method popup-value-setter
    (value :: <GtkWidget*>, obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkCombo", "popup")
 := value.raw-value;
  value;
end;

define open generic popwin-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic popwin-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method popwin-value
    (obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkCombo", "popwin"));
end;

define method popwin-value-setter
    (value :: <GtkWidget*>, obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkCombo", "popwin")
 := value.raw-value;
  value;
end;

define open generic list-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic list-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method list-value
    (obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkCombo", "list"));
end;

define method list-value-setter
    (value :: <GtkWidget*>, obj :: <GtkCombo*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkCombo", "list")
 := value.raw-value;
  value;
end;

define functional class <GtkMisc*> (<GtkWidget*>) end;
define sealed domain make(singleton(<GtkMisc*>));

define functional class <GtkObject*> (<statically-typed-pointer>) end;
define sealed domain make(singleton(<GtkObject*>));

define functional class <GtkPixmap*> (<GtkMisc*>) end;
define sealed domain make(singleton(<GtkPixmap*>));

define functional class <GtkCheckButton*> (<GtkToggleButton*>) end;
define sealed domain make(singleton(<GtkCheckButton*>));

define functional class <GtkWidget*> (<GtkObject*>) end;
define sealed domain make(singleton(<GtkWidget*>));

define method state-value
    (obj :: <GtkWidget*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkWidget", "state");
end;

define method state-value-setter
    (value :: <guint>, obj :: <GtkWidget*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkWidget", "state") := value;
end;

define open generic saved-state-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic saved-state-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method saved-state-value
    (obj :: <GtkWidget*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkWidget", "saved_state");
end;

define method saved-state-value-setter
    (value :: <guint>, obj :: <GtkWidget*>)
 => (value :: <guint>);
  c-struct-field(int:, obj.raw-value,
                 "GtkWidget", "saved_state") := value;
end;

define open generic style-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic style-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method style-value
    (obj :: <GtkWidget*>)
 => (value :: <GtkStyle*>);
  make(<GtkStyle*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkWidget", "style"));
end;

define method style-value-setter
    (value :: <GtkStyle*>, obj :: <GtkWidget*>)
 => (value :: <GtkStyle*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkWidget", "style")
 := value.raw-value;
  value;
end;

define open generic requisition-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method requisition-value
    (obj :: <GtkWidget*>)
 => (value :: <GtkRequisition*>);
  make(<GtkRequisition*>,
       pointer: obj.raw-value
                  + c-expr(int:, "offsetof(GtkWidget, requisition)"));
end;

define open generic allocation-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method allocation-value
    (obj :: <GtkWidget*>)
 => (value :: <GtkAllocation*>);
  make(<GtkAllocation*>,
       pointer: obj.raw-value
                  + c-expr(int:, "offsetof(GtkWidget, allocation)"));
end;

define method window-value
    (obj :: <GtkWidget*>)
 => (value :: <GdkWindow*>);
  make(<GdkWindow*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkWidget", "window"));
end;

define method window-value-setter
    (value :: <GdkWindow*>, obj :: <GtkWidget*>)
 => (value :: <GdkWindow*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkWidget", "window")
 := value.raw-value;
  value;
end;

define open generic parent-value
    (obj :: <statically-typed-pointer>)
 => (value :: <object>);

define open generic parent-value-setter
    (value :: <object>, obj :: <statically-typed-pointer>)
 => (value :: <object>);

define method parent-value
    (obj :: <GtkWidget*>)
 => (value :: <GtkWidget*>);
  make(<GtkWidget*>,
       pointer: c-struct-field(ptr:, obj.raw-value,
                               "GtkWidget", "parent"));
end;

define method parent-value-setter
    (value :: <GtkWidget*>, obj :: <GtkWidget*>)
 => (value :: <GtkWidget*>);
  c-struct-field(ptr:, obj.raw-value,
                 "GtkWidget", "parent")
 := value.raw-value;
  value;
end;

define inline-only function gtk-exit
    (code :: <gint>)
 => ();
  call-out("gtk_exit", void:,
           int: code);
  values();
end function;

define inline-only function gtk-main
    ()
 => ();
  call-out("gtk_main", void:);
  values();
end function;

define inline-only function gtk-main-level
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_main_level", int:);
  return-value;
end function;

define inline-only function gtk-main-quit
    ()
 => ();
  call-out("gtk_main_quit", void:);
  values();
end function;

define inline-only function gtk-main-iteration
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_main_iteration", int:);
  return-value;
end function;

define inline-only function gtk-main-iteration-do
    (val :: <gboolean>)
 => (return :: <gint>);
  let return-value = call-out("gtk_main_iteration_do", int:,
           int: val);
  return-value;
end function;

define inline-only function gtk-true
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_true", int:);
  return-value;
end function;

define inline-only function gtk-false
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_false", int:);
  return-value;
end function;

define inline-only function gtk-events-pending
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_events_pending", int:);
  return-value;
end function;

define inline-only function gtk-timeout-add
    (interval :: <gint>,
     func :: <GtkSignalFunc>,
     data :: <gpointer>)
 => (return :: <gint>);
  let return-value = call-out("gtk_timeout_add", int:,
           int: interval,
           ptr: func.raw-value,
           ptr: data.raw-value);
  return-value;
end function;

define inline-only function gtk-timeout-add-full
    (interval :: <gint>,
     function :: <GtkFunction>,
     marshall :: <GtkCallbackMarshal>,
     data :: <gpointer>,
     destroy :: <GtkDestroyNotify>)
 => (return :: <gint>);
  let return-value = call-out("gtk_timeout_add_full", int:,
           int: interval,
           ptr: function,
           ptr: marshall,
           ptr: data.raw-value,
           ptr: destroy);
  return-value;
end function;

define inline-only function gtk-timeout-remove
    (tag :: <gint>)
 => ();
  call-out("gtk_timeout_remove", void:,
           int: tag);
  values();
end function;

define inline-only function gtk-idle-add-full
    (priority :: <gint>,
     function :: <GtkFunction>,
     marshall :: <GtkCallbackMarshal>,
     data :: <gpointer>,
     destroy :: <GtkDestroyNotify>)
 => (return :: <gint>);
  let return-value = call-out("gtk_idle_add_full", int:,
           int: priority,
           ptr: function,
           ptr: marshall,
           ptr: data.raw-value,
           ptr: destroy);
  return-value;
end function;

define inline-only function gtk-idle-remove
    (tag :: <gint>)
 => ();
  call-out("gtk_idle_remove", void:,
           int: tag);
  values();
end function;

define inline-only function gtk-input-add-full
    (source :: <gint>,
     condition :: <GdkInputCondition>,
     callback :: <GtkFunction>,
     marshall :: <GtkCallbackMarshal>,
     data :: <gpointer>,
     destroy :: <GtkDestroyNotify>)
 => (return :: <gint>);
  let return-value = call-out("gtk_input_add_full", int:,
           int: source,
           int: condition,
           ptr: callback,
           ptr: marshall,
           ptr: data.raw-value,
           ptr: destroy);
  return-value;
end function;

define inline-only function gtk-input-remove
    (tag :: <gint>)
 => ();
  call-out("gtk_input_remove", void:,
           int: tag);
  values();
end function;

define inline-only function gtk-rc-parse
    (file :: <gchar*>)
 => ();
  call-out("gtk_rc_parse", void:,
           ptr: file.raw-value);
  values();
end function;

define inline-only function g-mem-chunk-info
    ()
 => ();
  call-out("g_mem_chunk_info", void:);
  values();
end function;

define inline-only function gtk-object-destroy
    (object :: <GtkObject*>)
 => ();
  call-out("gtk_object_destroy", void:,
           ptr: object.raw-value);
  values();
end function;

define inline-only function GTK-OBJECT-DESTROYED
    (object :: <GtkObject*>)
 => (return :: <gboolean>);
  let return-value = call-out("GTK_OBJECT_DESTROYED", int:,
           ptr: object.raw-value);
  return-value;
end function;

define inline-only function GTK-OBJECT-TYPE
    (object :: <GtkObject*>)
 => (return :: <GtkType>);
  let return-value = call-out("GTK_OBJECT_TYPE", int:,
           ptr: object.raw-value);
  return-value;
end function;

define inline-only function gtk-signal-connect
    (object :: <GtkObject*>,
     name :: <gchar*>,
     func :: <GtkSignalFunc>,
     data :: <gpointer>)
 => (return :: <guint>);
  let return-value = call-out("gtk_signal_connect", int:,
           ptr: object.raw-value,
           ptr: name.raw-value,
           ptr: func.raw-value,
           ptr: data.raw-value);
  return-value;
end function;

define inline-only function gtk-signal-connect-object
    (object :: <GtkObject*>,
     name :: <gchar*>,
     func :: <GtkSignalFunc>,
     slot_object :: <GtkObject*>)
 => (return :: <guint>);
  let return-value = call-out("gtk_signal_connect_object", int:,
           ptr: object.raw-value,
           ptr: name.raw-value,
           ptr: func.raw-value,
           ptr: slot_object.raw-value);
  return-value;
end function;

define inline-only function gtk-signal-connect-full
    (object :: <GtkObject*>,
     name :: <gchar*>,
     func :: <GtkFunction>,
     marshall :: <GtkCallbackMarshal>,
     data :: <gpointer>,
     destroy :: <GtkDestroyNotify>,
     object_signal :: <gboolean>,
     after :: <gboolean>)
 => (return :: <guint>);
  let return-value = call-out("gtk_signal_connect_full", int:,
           ptr: object.raw-value,
           ptr: name.raw-value,
           ptr: func,
           ptr: marshall,
           ptr: data.raw-value,
           ptr: destroy,
           int: object_signal,
           int: after);
  return-value;
end function;

define inline-only function gtk-signal-disconnect
    (object :: <GtkObject*>,
     id :: <guint>)
 => ();
  call-out("gtk_signal_disconnect", void:,
           ptr: object.raw-value,
           int: id);
  values();
end function;

define inline-only function gtk-signal-handler-block-by-func
    (object :: <GtkObject*>,
     func :: <GtkSignalFunc>,
     data :: <gpointer>)
 => ();
  call-out("gtk_signal_handler_block_by_func", void:,
           ptr: object.raw-value,
           ptr: func.raw-value,
           ptr: data.raw-value);
  values();
end function;

define inline-only function gtk-signal-handler-unblock-by-func
    (object :: <GtkObject*>,
     func :: <GtkSignalFunc>,
     data :: <gpointer>)
 => ();
  call-out("gtk_signal_handler_unblock_by_func", void:,
           ptr: object.raw-value,
           ptr: func.raw-value,
           ptr: data.raw-value);
  values();
end function;

define inline-only function gtk-signal-emitv-by-name
    (object :: <GtkObject*>,
     name :: <gchar*>,
     params :: <GtkArg*>)
 => ();
  call-out("gtk_signal_emitv_by_name", void:,
           ptr: object.raw-value,
           ptr: name.raw-value,
           ptr: params.raw-value);
  values();
end function;

define inline-only function gtk-grab-add
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_grab_add", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-grab-get-current
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_grab_get_current", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-grab-remove
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_grab_remove", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function GTK-WIDGET-STATE
    (widget :: <GtkWidget*>)
 => (return :: <GtkStateType>);
  let return-value = call-out("GTK_WIDGET_STATE", int:,
           ptr: widget.raw-value);
  return-value;
end function;

define inline-only function GTK-WIDGET-FLAGS
    (widget :: <GtkWidget*>)
 => (return :: <GtkWidgetFlags>);
  let return-value = call-out("GTK_WIDGET_FLAGS", int:,
           ptr: widget.raw-value);
  return-value;
end function;

define inline-only function GTK-WIDGET-SET-FLAGS
    (widget :: <GtkWidget*>,
     flags :: <GtkWidgetFlags>)
 => ();
  call-out("GTK_WIDGET_SET_FLAGS", void:,
           ptr: widget.raw-value,
           int: flags);
  values();
end function;

define inline-only function GTK-WIDGET-UNSET-FLAGS
    (widget :: <GtkWidget*>,
     flags :: <GtkWidgetFlags>)
 => ();
  call-out("GTK_WIDGET_UNSET_FLAGS", void:,
           ptr: widget.raw-value,
           int: flags);
  values();
end function;

define inline-only function gtk-widget-destroy
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_destroy", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-unparent
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_unparent", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-show
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_show", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-hide
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_hide", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-show-all
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_show_all", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-hide-all
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_hide_all", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-map
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_map", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-unmap
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_unmap", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-realize
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_realize", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-unrealize
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_unrealize", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-queue-draw
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_queue_draw", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-draw
    (widget :: <GtkWidget*>,
     area :: <GdkRectangle*>)
 => ();
  call-out("gtk_widget_draw", void:,
           ptr: widget.raw-value,
           ptr: area.raw-value);
  values();
end function;

define inline-only function gtk-widget-size-request
    (widget :: <GtkWidget*>,
     requisition :: <GtkRequisition*>)
 => ();
  call-out("gtk_widget_size_request", void:,
           ptr: widget.raw-value,
           ptr: requisition.raw-value);
  values();
end function;

define inline-only function gtk-widget-size-allocate
    (widget :: <GtkWidget*>,
     allocation :: <GtkAllocation*>)
 => ();
  call-out("gtk_widget_size_allocate", void:,
           ptr: widget.raw-value,
           ptr: allocation.raw-value);
  values();
end function;

define inline-only function gtk-widget-add-accelerator
    (widget :: <GtkWidget*>,
     accel_signal :: <gchar*>,
     accel_group :: <GtkAccelGroup*>,
     accel_key :: <guint>,
     accel_mods :: <GdkModifierType>,
     accel_flags :: <GtkAccelFlags>)
 => ();
  call-out("gtk_widget_add_accelerator", void:,
           ptr: widget.raw-value,
           ptr: accel_signal.raw-value,
           ptr: accel_group.raw-value,
           int: accel_key,
           int: accel_mods,
           int: accel_flags);
  values();
end function;

define inline-only function gtk-widget-event
    (widget :: <GtkWidget*>,
     event :: <GdkEvent*>)
 => (return :: <gboolean>);
  let return-value = call-out("gtk_widget_event", int:,
           ptr: widget.raw-value,
           ptr: event.raw-value);
  return-value;
end function;

define inline-only function gtk-widget-activate
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_activate", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-reparent
    (widget :: <GtkWidget*>,
     new_parent :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_reparent", void:,
           ptr: widget.raw-value,
           ptr: new_parent.raw-value);
  values();
end function;

define inline-only function gtk-widget-popup
    (widget :: <GtkWidget*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gtk_widget_popup", void:,
           ptr: widget.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gtk-widget-grab-focus
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_grab_focus", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-grab-default
    (widget :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_grab_default", void:,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-widget-set-name
    (widget :: <GtkWidget*>,
     name :: <gchar*>)
 => ();
  call-out("gtk_widget_set_name", void:,
           ptr: widget.raw-value,
           ptr: name.raw-value);
  values();
end function;

define inline-only function gtk-widget-get-name
    (widget :: <GtkWidget*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_widget_get_name", ptr:,
           ptr: widget.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-widget-set-state
    (widget :: <GtkWidget*>,
     state :: <GtkStateType>)
 => ();
  call-out("gtk_widget_set_state", void:,
           ptr: widget.raw-value,
           int: state);
  values();
end function;

define inline-only function gtk-widget-set-sensitive
    (widget :: <GtkWidget*>,
     sensitive :: <gboolean>)
 => ();
  call-out("gtk_widget_set_sensitive", void:,
           ptr: widget.raw-value,
           int: sensitive);
  values();
end function;

define inline-only function gtk-widget-set-parent
    (widget :: <GtkWidget*>,
     parent :: <GtkWidget*>)
 => ();
  call-out("gtk_widget_set_parent", void:,
           ptr: widget.raw-value,
           ptr: parent.raw-value);
  values();
end function;

define inline-only function gtk-widget-set-style
    (widget :: <GtkWidget*>,
     style :: <GtkStyle*>)
 => ();
  call-out("gtk_widget_set_style", void:,
           ptr: widget.raw-value,
           ptr: style.raw-value);
  values();
end function;

define inline-only function gtk-widget-set-uposition
    (widget :: <GtkWidget*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gtk_widget_set_uposition", void:,
           ptr: widget.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gtk-widget-set-usize
    (widget :: <GtkWidget*>,
     height :: <gint>,
     width :: <gint>)
 => ();
  call-out("gtk_widget_set_usize", void:,
           ptr: widget.raw-value,
           int: height,
           int: width);
  values();
end function;

define inline-only function gtk-widget-set-events
    (widget :: <GtkWidget*>,
     events :: <GdkEventMask>)
 => ();
  call-out("gtk_widget_set_events", void:,
           ptr: widget.raw-value,
           int: events);
  values();
end function;

define inline-only function gtk-widget-add-events
    (widget :: <GtkWidget*>,
     events :: <GdkEventMask>)
 => ();
  call-out("gtk_widget_add_events", void:,
           ptr: widget.raw-value,
           int: events);
  values();
end function;

define inline-only function gtk-widget-set-extension-events
    (widget :: <GtkWidget*>,
     events :: <GdkEventMask>)
 => ();
  call-out("gtk_widget_set_extension_events", void:,
           ptr: widget.raw-value,
           int: events);
  values();
end function;

define inline-only function gtk-widget-get-toplevel
    (widget :: <GtkWidget*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_widget_get_toplevel", ptr:,
           ptr: widget.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-widget-get-colormap
    (widget :: <GtkWidget*>)
 => (return :: <GdkColormap*>);
  let return-value = call-out("gtk_widget_get_colormap", ptr:,
           ptr: widget.raw-value);
  make(<GdkColormap*>, pointer: return-value);
end function;

define inline-only function gtk-widget-get-visual
    (widget :: <GtkWidget*>)
 => (return :: <GdkVisual*>);
  let return-value = call-out("gtk_widget_get_visual", ptr:,
           ptr: widget.raw-value);
  make(<GdkVisual*>, pointer: return-value);
end function;

define inline-only function gtk-widget-get-style
    (widget :: <GtkWidget*>)
 => (return :: <GtkStyle*>);
  let return-value = call-out("gtk_widget_get_style", ptr:,
           ptr: widget.raw-value);
  make(<GtkStyle*>, pointer: return-value);
end function;

define inline-only function gtk-widget-get-events
    (widget :: <GtkWidget*>)
 => (return :: <GdkEventMask>);
  let return-value = call-out("gtk_widget_get_events", int:,
           ptr: widget.raw-value);
  return-value;
end function;

define inline-only function gtk-widget-get-extension-events
    (widget :: <GtkWidget*>)
 => (return :: <GdkEventMask>);
  let return-value = call-out("gtk_widget_get_extension_events", int:,
           ptr: widget.raw-value);
  return-value;
end function;

define inline-only function gtk-widget-get-pointer
    (widget :: <GtkWidget*>,
     x :: <gint*>,
     y :: <gint*>)
 => ();
  call-out("gtk_widget_get_pointer", void:,
           ptr: widget.raw-value,
           ptr: x.raw-value,
           ptr: y.raw-value);
  values();
end function;

define inline-only function gtk-widget-is-ancestor
    (widget :: <GtkWidget*>,
     ancestor :: <GtkWidget*>)
 => (return :: <gboolean>);
  let return-value = call-out("gtk_widget_is_ancestor", int:,
           ptr: widget.raw-value,
           ptr: ancestor.raw-value);
  return-value;
end function;

define inline-only function gtk-widget-push-colormap
    (cmap :: <GdkColormap*>)
 => ();
  call-out("gtk_widget_push_colormap", void:,
           ptr: cmap.raw-value);
  values();
end function;

define inline-only function gtk-widget-push-visual
    (visual :: <GdkVisual*>)
 => ();
  call-out("gtk_widget_push_visual", void:,
           ptr: visual.raw-value);
  values();
end function;

define inline-only function gtk-widget-push-style
    (style :: <GtkStyle*>)
 => ();
  call-out("gtk_widget_push_style", void:,
           ptr: style.raw-value);
  values();
end function;

define inline-only function gtk-widget-pop-colormap
    ()
 => ();
  call-out("gtk_widget_pop_colormap", void:);
  values();
end function;

define inline-only function gtk-widget-pop-visual
    ()
 => ();
  call-out("gtk_widget_pop_visual", void:);
  values();
end function;

define inline-only function gtk-widget-pop-style
    ()
 => ();
  call-out("gtk_widget_pop_style", void:);
  values();
end function;

define inline-only function gtk-widget-set-default-colormap
    (cmap :: <GdkColormap*>)
 => ();
  call-out("gtk_widget_set_default_colormap", void:,
           ptr: cmap.raw-value);
  values();
end function;

define inline-only function gtk-widget-set-default-visual
    (visual :: <GdkVisual*>)
 => ();
  call-out("gtk_widget_set_default_visual", void:,
           ptr: visual.raw-value);
  values();
end function;

define inline-only function gtk-widget-set-default-style
    (style :: <GtkStyle*>)
 => ();
  call-out("gtk_widget_set_default_style", void:,
           ptr: style.raw-value);
  values();
end function;

define inline-only function gtk-widget-get-default-colormap
    ()
 => (return :: <GdkColormap*>);
  let return-value = call-out("gtk_widget_get_default_colormap", ptr:);
  make(<GdkColormap*>, pointer: return-value);
end function;

define inline-only function gtk-widget-get-default-visual
    ()
 => (return :: <GdkVisual*>);
  let return-value = call-out("gtk_widget_get_default_visual", ptr:);
  make(<GdkVisual*>, pointer: return-value);
end function;

define inline-only function gtk-widget-get-default-style
    ()
 => (return :: <GtkStyle*>);
  let return-value = call-out("gtk_widget_get_default_style", ptr:);
  make(<GtkStyle*>, pointer: return-value);
end function;

define inline-only function gtk-container-set-border-width
    (container :: <GtkContainer*>,
     border_width :: <guint>)
 => ();
  call-out("gtk_container_set_border_width", void:,
           ptr: container.raw-value,
           int: border_width);
  values();
end function;

define inline-only function gtk-container-add
    (container :: <GtkContainer*>,
     widget :: <GtkWidget*>)
 => ();
  call-out("gtk_container_add", void:,
           ptr: container.raw-value,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-container-remove
    (container :: <GtkContainer*>,
     widget :: <GtkWidget*>)
 => ();
  call-out("gtk_container_remove", void:,
           ptr: container.raw-value,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-container-set-resize-mode
    (container :: <GtkContainer*>,
     resize_mode :: <GtkResizeMode>)
 => ();
  call-out("gtk_container_set_resize_mode", void:,
           ptr: container.raw-value,
           int: resize_mode);
  values();
end function;

define inline-only function gtk-container-foreach-full
    (container :: <GtkContainer*>,
     function :: <GtkFunction>,
     marshall :: <GtkCallbackMarshal>,
     data :: <gpointer>,
     destroy :: <GtkDestroyNotify>)
 => ();
  call-out("gtk_container_foreach_full", void:,
           ptr: container.raw-value,
           ptr: function,
           ptr: marshall,
           ptr: data.raw-value,
           ptr: destroy);
  values();
end function;

define inline-only function gtk-container-children
    (container :: <GtkContainer*>)
 => (return :: <GList*>);
  let return-value = call-out("gtk_container_children", ptr:,
           ptr: container.raw-value);
  make(<GList*>, pointer: return-value);
end function;

define inline-only function gtk-container-focus
    (container :: <GtkContainer*>,
     direction :: <GtkDirectionType>)
 => (return :: <GtkDirectionType>);
  let return-value = call-out("gtk_container_focus", int:,
           ptr: container.raw-value,
           int: direction);
  return-value;
end function;

define inline-only function gtk-container-register-toplevel
    (container :: <GtkContainer*>)
 => ();
  call-out("gtk_container_register_toplevel", void:,
           ptr: container.raw-value);
  values();
end function;

define inline-only function gtk-container-unregister-toplevel
    (container :: <GtkContainer*>)
 => ();
  call-out("gtk_container_unregister_toplevel", void:,
           ptr: container.raw-value);
  values();
end function;

define inline-only function gtk-fixed-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_fixed_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-fixed-put
    (fixed :: <GtkFixed*>,
     widget :: <GtkWidget*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gtk_fixed_put", void:,
           ptr: fixed.raw-value,
           ptr: widget.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gtk-fixed-move
    (fixed :: <GtkFixed*>,
     widget :: <GtkWidget*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gtk_fixed_move", void:,
           ptr: fixed.raw-value,
           ptr: widget.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gtk-tree-item-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_tree_item_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-tree-item-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_tree_item_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-tree-item-set-subtree
    (tree_item :: <GtkTreeItem*>,
     subtree :: <GtkWidget*>)
 => ();
  call-out("gtk_tree_item_set_subtree", void:,
           ptr: tree_item.raw-value,
           ptr: subtree.raw-value);
  values();
end function;

define inline-only function gtk-tree-item-remove-subtree
    (tree_item :: <GtkTreeItem*>)
 => ();
  call-out("gtk_tree_item_remove_subtree", void:,
           ptr: tree_item.raw-value);
  values();
end function;

define inline-only function gtk-tree-item-select
    (tree_item :: <GtkTreeItem*>)
 => ();
  call-out("gtk_tree_item_select", void:,
           ptr: tree_item.raw-value);
  values();
end function;

define inline-only function gtk-tree-item-deselect
    (tree_item :: <GtkTreeItem*>)
 => ();
  call-out("gtk_tree_item_deselect", void:,
           ptr: tree_item.raw-value);
  values();
end function;

define inline-only function gtk-tree-item-expand
    (tree_item :: <GtkTreeItem*>)
 => ();
  call-out("gtk_tree_item_expand", void:,
           ptr: tree_item.raw-value);
  values();
end function;

define inline-only function gtk-tree-item-collapse
    (tree_item :: <GtkTreeItem*>)
 => ();
  call-out("gtk_tree_item_collapse", void:,
           ptr: tree_item.raw-value);
  values();
end function;

define inline-only function gtk-tree-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_tree_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-tree-append
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_tree_append", void:,
           ptr: tree.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-tree-prepend
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_tree_prepend", void:,
           ptr: tree.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-tree-insert
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_tree_insert", void:,
           ptr: tree.raw-value,
           ptr: child.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-tree-remove-item
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_tree_remove_item", void:,
           ptr: tree.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-tree-clear-items
    (tree :: <GtkTree*>,
     istart :: <gint>,
     iend :: <gint>)
 => ();
  call-out("gtk_tree_clear_items", void:,
           ptr: tree.raw-value,
           int: istart,
           int: iend);
  values();
end function;

define inline-only function gtk-tree-select-item
    (tree :: <GtkTree*>,
     item :: <gint>)
 => ();
  call-out("gtk_tree_select_item", void:,
           ptr: tree.raw-value,
           int: item);
  values();
end function;

define inline-only function gtk-tree-unselect-item
    (tree :: <GtkTree*>,
     item :: <gint>)
 => ();
  call-out("gtk_tree_unselect_item", void:,
           ptr: tree.raw-value,
           int: item);
  values();
end function;

define inline-only function gtk-tree-select-child
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_tree_select_child", void:,
           ptr: tree.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-tree-unselect-child
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_tree_unselect_child", void:,
           ptr: tree.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-tree-child-position
    (tree :: <GtkTree*>,
     child :: <GtkWidget*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_tree_child_position", int:,
           ptr: tree.raw-value,
           ptr: child.raw-value);
  return-value;
end function;

define inline-only function gtk-tree-set-selection-mode
    (tree :: <GtkTree*>,
     mode :: <GtkSelectionMode>)
 => ();
  call-out("gtk_tree_set_selection_mode", void:,
           ptr: tree.raw-value,
           int: mode);
  values();
end function;

define inline-only function gtk-tree-set-view-mode
    (tree :: <GtkTree*>,
     mode :: <GtkTreeViewMode>)
 => ();
  call-out("gtk_tree_set_view_mode", void:,
           ptr: tree.raw-value,
           int: mode);
  values();
end function;

define inline-only function gtk-tree-set-view-lines
    (tree :: <GtkTree*>,
     flag :: <gboolean>)
 => ();
  call-out("gtk_tree_set_view_lines", void:,
           ptr: tree.raw-value,
           int: flag);
  values();
end function;

define inline-only function gtk-adjustment-new
    (value :: <gfloat>,
     lower :: <gfloat>,
     upper :: <gfloat>,
     step_increment :: <gfloat>,
     page_increment :: <gfloat>,
     page_size :: <gfloat>)
 => (return :: <GtkObject*>);
  let return-value = call-out("gtk_adjustment_new", ptr:,
           float: value,
           float: lower,
           float: upper,
           float: step_increment,
           float: page_increment,
           float: page_size);
  make(<GtkObject*>, pointer: return-value);
end function;

define inline-only function gtk-adjustment-changed
    (adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_adjustment_changed", void:,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-adjustment-value-changed
    (adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_adjustment_value_changed", void:,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-adjustment-clamp-page
    (adjustment :: <GtkAdjustment*>,
     lower :: <gfloat>,
     upper :: <gfloat>)
 => ();
  call-out("gtk_adjustment_clamp_page", void:,
           ptr: adjustment.raw-value,
           float: lower,
           float: upper);
  values();
end function;

define inline-only function gtk-adjustment-set-value
    (adjustment :: <GtkAdjustment*>,
     value :: <gfloat>)
 => ();
  call-out("gtk_adjustment_set_value", void:,
           ptr: adjustment.raw-value,
           float: value);
  values();
end function;

define inline-only function gtk-clist-new
    (columns :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_clist_new", ptr:,
           int: columns);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-clist-new-with-titles
    (ntitles :: <integer>,
     titles :: <gchar**>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_clist_new_with_titles", ptr:,
           int: ntitles,
           ptr: titles.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-clist-set-hadjustment
    (clist :: <GtkCList*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_clist_set_hadjustment", void:,
           ptr: clist.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-clist-set-vadjustment
    (clist :: <GtkCList*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_clist_set_vadjustment", void:,
           ptr: clist.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-clist-get-hadjustment
    (clist :: <GtkCList*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_clist_get_hadjustment", ptr:,
           ptr: clist.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-clist-get-vadjustment
    (clist :: <GtkCList*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_clist_get_vadjustment", ptr:,
           ptr: clist.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-clist-set-shadow-type
    (clist :: <GtkCList*>,
     type :: <GtkShadowType>)
 => ();
  call-out("gtk_clist_set_shadow_type", void:,
           ptr: clist.raw-value,
           int: type);
  values();
end function;

define inline-only function gtk-clist-set-selection-mode
    (clist :: <GtkCList*>,
     mode :: <GtkSelectionMode>)
 => ();
  call-out("gtk_clist_set_selection_mode", void:,
           ptr: clist.raw-value,
           int: mode);
  values();
end function;

define inline-only function gtk-clist-set-reorderable
    (clist :: <GtkCList*>,
     reorderable :: <gboolean>)
 => ();
  call-out("gtk_clist_set_reorderable", void:,
           ptr: clist.raw-value,
           int: reorderable);
  values();
end function;

define inline-only function gtk-clist-set-use-drag-icons
    (list :: <GtkCList*>,
     use_icons :: <gboolean>)
 => ();
  call-out("gtk_clist_set_use_drag_icons", void:,
           ptr: list.raw-value,
           int: use_icons);
  values();
end function;

define inline-only function gtk-clist-set-button-actions
    (list :: <GtkCList*>,
     button :: <guint>,
     button_actions :: <guint>)
 => ();
  call-out("gtk_clist_set_button_actions", void:,
           ptr: list.raw-value,
           int: button,
           int: button_actions);
  values();
end function;

define inline-only function gtk-clist-freeze
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_freeze", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-thaw
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_thaw", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-column-titles-show
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_column_titles_show", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-column-titles-hide
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_column_titles_hide", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-column-title-active
    (clist :: <GtkCList*>,
     column :: <gint>)
 => ();
  call-out("gtk_clist_column_title_active", void:,
           ptr: clist.raw-value,
           int: column);
  values();
end function;

define inline-only function gtk-clist-column-title-passive
    (clist :: <GtkCList*>,
     column :: <gint>)
 => ();
  call-out("gtk_clist_column_title_passive", void:,
           ptr: clist.raw-value,
           int: column);
  values();
end function;

define inline-only function gtk-clist-column-titles-active
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_column_titles_active", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-column-titles-passive
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_column_titles_passive", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-set-column-title
    (clist :: <GtkCList*>,
     column :: <gint>,
     title :: <gchar*>)
 => ();
  call-out("gtk_clist_set_column_title", void:,
           ptr: clist.raw-value,
           int: column,
           ptr: title.raw-value);
  values();
end function;

define inline-only function gtk-clist-set-column-widget
    (clist :: <GtkCList*>,
     column :: <gint>,
     widget :: <GtkWidget*>)
 => ();
  call-out("gtk_clist_set_column_widget", void:,
           ptr: clist.raw-value,
           int: column,
           ptr: widget.raw-value);
  values();
end function;

define inline-only function gtk-clist-get-column-widget
    (clist :: <GtkCList*>,
     column :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_clist_get_column_widget", ptr:,
           ptr: clist.raw-value,
           int: column);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-clist-set-column-justification
    (clist :: <GtkCList*>,
     column :: <gint>,
     justification :: <GtkJustification>)
 => ();
  call-out("gtk_clist_set_column_justification", void:,
           ptr: clist.raw-value,
           int: column,
           int: justification);
  values();
end function;

define inline-only function gtk-clist-set-column-visibility
    (clist :: <GtkCList*>,
     column :: <gint>,
     visible :: <gboolean>)
 => ();
  call-out("gtk_clist_set_column_visibility", void:,
           ptr: clist.raw-value,
           int: column,
           int: visible);
  values();
end function;

define inline-only function gtk-clist-set-column-resizeable
    (clist :: <GtkCList*>,
     column :: <gint>,
     resizeable :: <gboolean>)
 => ();
  call-out("gtk_clist_set_column_resizeable", void:,
           ptr: clist.raw-value,
           int: column,
           int: resizeable);
  values();
end function;

define inline-only function gtk-clist-set-column-auto-resize
    (clist :: <GtkCList*>,
     column :: <gint>,
     auto_resize :: <gboolean>)
 => ();
  call-out("gtk_clist_set_column_auto_resize", void:,
           ptr: clist.raw-value,
           int: column,
           int: auto_resize);
  values();
end function;

define inline-only function gtk-clist-columns-autosize
    (clist :: <GtkCList*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_columns_autosize", int:,
           ptr: clist.raw-value);
  return-value;
end function;

define inline-only function gtk-clist-optimal-column-width
    (clist :: <GtkCList*>,
     column :: <gint>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_optimal_column_width", int:,
           ptr: clist.raw-value,
           int: column);
  return-value;
end function;

define inline-only function gtk-clist-set-column-width
    (clist :: <GtkCList*>,
     column :: <gint>,
     width :: <gint>)
 => ();
  call-out("gtk_clist_set_column_width", void:,
           ptr: clist.raw-value,
           int: column,
           int: width);
  values();
end function;

define inline-only function gtk-clist-set-column-min-width
    (clist :: <GtkCList*>,
     column :: <gint>,
     min_width :: <gint>)
 => ();
  call-out("gtk_clist_set_column_min_width", void:,
           ptr: clist.raw-value,
           int: column,
           int: min_width);
  values();
end function;

define inline-only function gtk-clist-set-column-max-width
    (clist :: <GtkCList*>,
     column :: <gint>,
     max_width :: <gint>)
 => ();
  call-out("gtk_clist_set_column_max_width", void:,
           ptr: clist.raw-value,
           int: column,
           int: max_width);
  values();
end function;

define inline-only function gtk-clist-set-row-height
    (clist :: <GtkCList*>,
     height :: <gint>)
 => ();
  call-out("gtk_clist_set_row_height", void:,
           ptr: clist.raw-value,
           int: height);
  values();
end function;

define inline-only function gtk-clist-moveto
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>,
     row_align :: <gfloat>,
     column_align :: <gfloat>)
 => ();
  call-out("gtk_clist_moveto", void:,
           ptr: clist.raw-value,
           int: row,
           int: column,
           float: row_align,
           float: column_align);
  values();
end function;

define inline-only function gtk-clist-row-is-visible
    (clist :: <GtkCList*>,
     row :: <gint>)
 => (return :: <GtkVisibility>);
  let return-value = call-out("gtk_clist_row_is_visible", int:,
           ptr: clist.raw-value,
           int: row);
  return-value;
end function;

define inline-only function gtk-clist-get-cell-type
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>)
 => (return :: <GtkCellType>);
  let return-value = call-out("gtk_clist_get_cell_type", int:,
           ptr: clist.raw-value,
           int: row,
           int: column);
  return-value;
end function;

define inline-only function gtk-clist-set-text
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>,
     text :: <gchar*>)
 => ();
  call-out("gtk_clist_set_text", void:,
           ptr: clist.raw-value,
           int: row,
           int: column,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-clist-get-text
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>,
     text :: <gchar**>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_get_text", int:,
           ptr: clist.raw-value,
           int: row,
           int: column,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-clist-set-foreground
    (clist :: <GtkCList*>,
     row :: <gint>,
     color :: <GdkColor*>)
 => ();
  call-out("gtk_clist_set_foreground", void:,
           ptr: clist.raw-value,
           int: row,
           ptr: color.raw-value);
  values();
end function;

define inline-only function gtk-clist-set-background
    (clist :: <GtkCList*>,
     row :: <gint>,
     color :: <GdkColor*>)
 => ();
  call-out("gtk_clist_set_background", void:,
           ptr: clist.raw-value,
           int: row,
           ptr: color.raw-value);
  values();
end function;

define inline-only function gtk-clist-set-cell-style
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>,
     style :: <GtkStyle*>)
 => ();
  call-out("gtk_clist_set_cell_style", void:,
           ptr: clist.raw-value,
           int: row,
           int: column,
           ptr: style.raw-value);
  values();
end function;

define inline-only function gtk-clist-get-cell-style
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>)
 => (return :: <GtkStyle*>);
  let return-value = call-out("gtk_clist_get_cell_style", ptr:,
           ptr: clist.raw-value,
           int: row,
           int: column);
  make(<GtkStyle*>, pointer: return-value);
end function;

define inline-only function gtk-clist-set-row-style
    (clist :: <GtkCList*>,
     row :: <gint>,
     style :: <GtkStyle*>)
 => ();
  call-out("gtk_clist_set_row_style", void:,
           ptr: clist.raw-value,
           int: row,
           ptr: style.raw-value);
  values();
end function;

define inline-only function gtk-clist-get-row-style
    (clist :: <GtkCList*>,
     row :: <gint>)
 => (return :: <GtkStyle*>);
  let return-value = call-out("gtk_clist_get_row_style", ptr:,
           ptr: clist.raw-value,
           int: row);
  make(<GtkStyle*>, pointer: return-value);
end function;

define inline-only function gtk-clist-set-shift
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>,
     vertical :: <gint>,
     horizontal :: <gint>)
 => ();
  call-out("gtk_clist_set_shift", void:,
           ptr: clist.raw-value,
           int: row,
           int: column,
           int: vertical,
           int: horizontal);
  values();
end function;

define inline-only function gtk-clist-set-selectable
    (clist :: <GtkCList*>,
     row :: <gint>,
     selectable :: <gboolean>)
 => ();
  call-out("gtk_clist_set_selectable", void:,
           ptr: clist.raw-value,
           int: row,
           int: selectable);
  values();
end function;

define inline-only function gtk-clist-get-selectable
    (clist :: <GtkCList*>,
     row :: <gint>)
 => (return :: <gboolean>);
  let return-value = call-out("gtk_clist_get_selectable", int:,
           ptr: clist.raw-value,
           int: row);
  return-value;
end function;

define inline-only function gtk-clist-prepend
    (clist :: <GtkCList*>,
     text :: <gchar**>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_prepend", int:,
           ptr: clist.raw-value,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-clist-append
    (clist :: <GtkCList*>,
     text :: <gchar**>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_append", int:,
           ptr: clist.raw-value,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-clist-insert
    (clist :: <GtkCList*>,
     row :: <gint>,
     text :: <gchar**>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_insert", int:,
           ptr: clist.raw-value,
           int: row,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-clist-remove
    (clist :: <GtkCList*>,
     row :: <gint>)
 => ();
  call-out("gtk_clist_remove", void:,
           ptr: clist.raw-value,
           int: row);
  values();
end function;

define inline-only function gtk-clist-select-row
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>)
 => ();
  call-out("gtk_clist_select_row", void:,
           ptr: clist.raw-value,
           int: row,
           int: column);
  values();
end function;

define inline-only function gtk-clist-unselect-row
    (clist :: <GtkCList*>,
     row :: <gint>,
     column :: <gint>)
 => ();
  call-out("gtk_clist_unselect_row", void:,
           ptr: clist.raw-value,
           int: row,
           int: column);
  values();
end function;

define inline-only function gtk-clist-undo-selection
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_undo_selection", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-clear
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_clear", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-get-selection-info
    (clist :: <GtkCList*>,
     x :: <gint>,
     y :: <gint>,
     row :: <gint*>,
     column :: <gint*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_clist_get_selection_info", int:,
           ptr: clist.raw-value,
           int: x,
           int: y,
           ptr: row.raw-value,
           ptr: column.raw-value);
  return-value;
end function;

define inline-only function gtk-clist-unselect-all
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_unselect_all", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-swap-rows
    (clist :: <GtkCList*>,
     row1 :: <gint>,
     row2 :: <gint>)
 => ();
  call-out("gtk_clist_swap_rows", void:,
           ptr: clist.raw-value,
           int: row1,
           int: row2);
  values();
end function;

define inline-only function gtk-clist-set-sort-column
    (clist :: <GtkCList*>,
     column :: <gint>)
 => ();
  call-out("gtk_clist_set_sort_column", void:,
           ptr: clist.raw-value,
           int: column);
  values();
end function;

define inline-only function gtk-clist-set-sort-type
    (clist :: <GtkCList*>,
     sort_type :: <GtkSortType>)
 => ();
  call-out("gtk_clist_set_sort_type", void:,
           ptr: clist.raw-value,
           int: sort_type);
  values();
end function;

define inline-only function gtk-clist-sort
    (clist :: <GtkCList*>)
 => ();
  call-out("gtk_clist_sort", void:,
           ptr: clist.raw-value);
  values();
end function;

define inline-only function gtk-clist-set-auto-sort
    (clist :: <GtkCList*>,
     auto_sort :: <gboolean>)
 => ();
  call-out("gtk_clist_set_auto_sort", void:,
           ptr: clist.raw-value,
           int: auto_sort);
  values();
end function;

define inline-only function gtk-event-box-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_event_box_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-window-new
    (type :: <GtkWindowType>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_window_new", ptr:,
           int: type);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-window-set-title
    (window :: <GtkWindow*>,
     title :: <gchar*>)
 => ();
  call-out("gtk_window_set_title", void:,
           ptr: window.raw-value,
           ptr: title.raw-value);
  values();
end function;

define inline-only function gtk-window-set-wmclass
    (window :: <GtkWindow*>,
     wmclass_class :: <gchar*>,
     wmclass_name :: <gchar*>)
 => ();
  call-out("gtk_window_set_wmclass", void:,
           ptr: window.raw-value,
           ptr: wmclass_class.raw-value,
           ptr: wmclass_name.raw-value);
  values();
end function;

define inline-only function gtk-window-set-focus
    (window :: <GtkWindow*>,
     focus :: <GtkWidget*>)
 => ();
  call-out("gtk_window_set_focus", void:,
           ptr: window.raw-value,
           ptr: focus.raw-value);
  values();
end function;

define inline-only function gtk-window-set-default
    (window :: <GtkWindow*>,
     default :: <GtkWidget*>)
 => ();
  call-out("gtk_window_set_default", void:,
           ptr: window.raw-value,
           ptr: default.raw-value);
  values();
end function;

define inline-only function gtk-window-set-policy
    (window :: <GtkWindow*>,
     allow_shrink :: <gboolean>,
     allow_grow :: <gboolean>,
     auto_shrink :: <gboolean>)
 => ();
  call-out("gtk_window_set_policy", void:,
           ptr: window.raw-value,
           int: allow_shrink,
           int: allow_grow,
           int: auto_shrink);
  values();
end function;

define inline-only function gtk-window-position
    (window :: <GtkWindow*>,
     position :: <GtkWindowPosition>)
 => ();
  call-out("gtk_window_position", void:,
           ptr: window.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-window-activate-focus
    (window :: <GtkWindow*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_window_activate_focus", int:,
           ptr: window.raw-value);
  return-value;
end function;

define inline-only function gtk-window-activate-default
    (window :: <GtkWindow*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_window_activate_default", int:,
           ptr: window.raw-value);
  return-value;
end function;

define inline-only function gtk-window-set-modal
    (window :: <GtkWindow*>,
     modal :: <gboolean>)
 => ();
  call-out("gtk_window_set_modal", void:,
           ptr: window.raw-value,
           int: modal);
  values();
end function;

define inline-only function gtk-window-add-embedded-xid
    (window :: <GtkWindow*>,
     xid :: <guint>)
 => ();
  call-out("gtk_window_add_embedded_xid", void:,
           ptr: window.raw-value,
           int: xid);
  values();
end function;

define inline-only function gtk-window-remove-embedded-xid
    (window :: <GtkWindow*>,
     xid :: <guint>)
 => ();
  call-out("gtk_window_remove_embedded_xid", void:,
           ptr: window.raw-value,
           int: xid);
  values();
end function;

define inline-only function gtk-window-set-default-size
    (window :: <GtkWindow*>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gtk_window_set_default_size", void:,
           ptr: window.raw-value,
           int: width,
           int: height);
  values();
end function;

define inline-only function gtk-window-set-position
    (window :: <GtkWindow*>,
     position :: <GtkWindowPosition>)
 => ();
  call-out("gtk_window_set_position", void:,
           ptr: window.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-window-set-transient-for
    (window :: <GtkWindow*>,
     parent :: <GtkWindow*>)
 => ();
  call-out("gtk_window_set_transient_for", void:,
           ptr: window.raw-value,
           ptr: parent.raw-value);
  values();
end function;

define inline-only function gtk-handle-box-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_handle_box_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-handle-box-set-shadow-type
    (handlebox :: <GtkHandleBox*>,
     type :: <GtkShadowType>)
 => ();
  call-out("gtk_handle_box_set_shadow_type", void:,
           ptr: handlebox.raw-value,
           int: type);
  values();
end function;

define inline-only function gtk-handle-box-set-handle-position
    (handlebox :: <GtkHandleBox*>,
     position :: <GtkPositionType>)
 => ();
  call-out("gtk_handle_box_set_handle_position", void:,
           ptr: handlebox.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-handle-box-set-snap-edge
    (handlebox :: <GtkHandleBox*>,
     edge :: <GtkPositionType>)
 => ();
  call-out("gtk_handle_box_set_snap_edge", void:,
           ptr: handlebox.raw-value,
           int: edge);
  values();
end function;

define inline-only function gtk-box-pack-start
    (box :: <GtkBox*>,
     child :: <GtkWidget*>,
     expand :: <gboolean>,
     fill :: <gboolean>,
     padding :: <gint>)
 => ();
  call-out("gtk_box_pack_start", void:,
           ptr: box.raw-value,
           ptr: child.raw-value,
           int: expand,
           int: fill,
           int: padding);
  values();
end function;

define inline-only function gtk-box-pack-end
    (box :: <GtkBox*>,
     child :: <GtkWidget*>,
     expand :: <gboolean>,
     fill :: <gboolean>,
     padding :: <gint>)
 => ();
  call-out("gtk_box_pack_end", void:,
           ptr: box.raw-value,
           ptr: child.raw-value,
           int: expand,
           int: fill,
           int: padding);
  values();
end function;

define inline-only function gtk-box-pack-start-defaults
    (box :: <GtkBox*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_box_pack_start_defaults", void:,
           ptr: box.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-box-pack-end-defaults
    (box :: <GtkBox*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_box_pack_end_defaults", void:,
           ptr: box.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-box-set-homogeneous
    (box :: <GtkBox*>,
     homogenous :: <gboolean>)
 => ();
  call-out("gtk_box_set_homogeneous", void:,
           ptr: box.raw-value,
           int: homogenous);
  values();
end function;

define inline-only function gtk-box-set-spacing
    (box :: <GtkBox*>,
     spacing :: <gint>)
 => ();
  call-out("gtk_box_set_spacing", void:,
           ptr: box.raw-value,
           int: spacing);
  values();
end function;

define inline-only function gtk-box-reorder-child
    (box :: <GtkBox*>,
     child :: <GtkWidget*>,
     pos :: <guint>)
 => ();
  call-out("gtk_box_reorder_child", void:,
           ptr: box.raw-value,
           ptr: child.raw-value,
           int: pos);
  values();
end function;

define inline-only function gtk-box-set-child-packing
    (box :: <GtkBox*>,
     child :: <GtkWidget*>,
     expand :: <gboolean>,
     fill :: <gboolean>,
     padding :: <gint>,
     pack_type :: <GtkPackType>)
 => ();
  call-out("gtk_box_set_child_packing", void:,
           ptr: box.raw-value,
           ptr: child.raw-value,
           int: expand,
           int: fill,
           int: padding,
           int: pack_type);
  values();
end function;

define inline-only function gtk-button-box-set-child-size-default
    (min_width :: <gint>,
     min_height :: <gint>)
 => ();
  call-out("gtk_button_box_set_child_size_default", void:,
           int: min_width,
           int: min_height);
  values();
end function;

define inline-only function gtk-button-box-set-child-ipadding-default
    (ipad_x :: <gint>,
     ipad_y :: <gint>)
 => ();
  call-out("gtk_button_box_set_child_ipadding_default", void:,
           int: ipad_x,
           int: ipad_y);
  values();
end function;

define inline-only function gtk-button-box-get-spacing
    (widget :: <GtkButtonBox*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_button_box_get_spacing", int:,
           ptr: widget.raw-value);
  return-value;
end function;

define inline-only function gtk-button-box-get-layout
    (widget :: <GtkButtonBox*>)
 => (return :: <GtkButtonBoxStyle>);
  let return-value = call-out("gtk_button_box_get_layout", int:,
           ptr: widget.raw-value);
  return-value;
end function;

define inline-only function gtk-button-box-set-spacing
    (widget :: <GtkButtonBox*>,
     spacing :: <gint>)
 => ();
  call-out("gtk_button_box_set_spacing", void:,
           ptr: widget.raw-value,
           int: spacing);
  values();
end function;

define inline-only function gtk-button-box-set-layout
    (widget :: <GtkButtonBox*>,
     layout_style :: <GtkButtonBoxStyle>)
 => ();
  call-out("gtk_button_box_set_layout", void:,
           ptr: widget.raw-value,
           int: layout_style);
  values();
end function;

define inline-only function gtk-button-box-set-child-size
    (widget :: <GtkButtonBox*>,
     min_width :: <gint>,
     min_height :: <gint>)
 => ();
  call-out("gtk_button_box_set_child_size", void:,
           ptr: widget.raw-value,
           int: min_width,
           int: min_height);
  values();
end function;

define inline-only function gtk-button-box-set-child-ipadding
    (widget :: <GtkButtonBox*>,
     ipad_x :: <gint>,
     ipad_y :: <gint>)
 => ();
  call-out("gtk_button_box_set_child_ipadding", void:,
           ptr: widget.raw-value,
           int: ipad_x,
           int: ipad_y);
  values();
end function;

define inline-only function gtk-hbutton-box-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hbutton_box_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-hbutton-box-get-spacing-default
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_hbutton_box_get_spacing_default", int:);
  return-value;
end function;

define inline-only function gtk-hbutton-box-get-layout-default
    ()
 => (return :: <GtkButtonBoxStyle>);
  let return-value = call-out("gtk_hbutton_box_get_layout_default", int:);
  return-value;
end function;

define inline-only function gtk-hbutton-box-set-spacing-default
    (spacing :: <gint>)
 => ();
  call-out("gtk_hbutton_box_set_spacing_default", void:,
           int: spacing);
  values();
end function;

define inline-only function gtk-hbutton-box-set-layout-default
    (layout :: <GtkButtonBoxStyle>)
 => ();
  call-out("gtk_hbutton_box_set_layout_default", void:,
           int: layout);
  values();
end function;

define inline-only function gtk-vbutton-box-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vbutton_box_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-vbutton-box-get-spacing-default
    ()
 => (return :: <gint>);
  let return-value = call-out("gtk_vbutton_box_get_spacing_default", int:);
  return-value;
end function;

define inline-only function gtk-vbutton-box-get-layout-default
    ()
 => (return :: <GtkButtonBoxStyle>);
  let return-value = call-out("gtk_vbutton_box_get_layout_default", int:);
  return-value;
end function;

define inline-only function gtk-vbutton-box-set-spacing-default
    (spacing :: <gint>)
 => ();
  call-out("gtk_vbutton_box_set_spacing_default", void:,
           int: spacing);
  values();
end function;

define inline-only function gtk-vbutton-box-set-layout-default
    (layout :: <GtkButtonBoxStyle>)
 => ();
  call-out("gtk_vbutton_box_set_layout_default", void:,
           int: layout);
  values();
end function;

define inline-only function gtk-toolbar-new
    (orientation :: <GtkOrientation>,
     style :: <GtkToolbarStyle>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_toolbar_new", ptr:,
           int: orientation,
           int: style);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-toolbar-append-space
    (toolbar :: <GtkToolbar*>)
 => ();
  call-out("gtk_toolbar_append_space", void:,
           ptr: toolbar.raw-value);
  values();
end function;

define inline-only function gtk-toolbar-prepend-space
    (toolbar :: <GtkToolbar*>)
 => ();
  call-out("gtk_toolbar_prepend_space", void:,
           ptr: toolbar.raw-value);
  values();
end function;

define inline-only function gtk-toolbar-insert-space
    (toolbar :: <GtkToolbar*>,
     position :: <gint>)
 => ();
  call-out("gtk_toolbar_insert_space", void:,
           ptr: toolbar.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-toolbar-append-widget
    (toolbar :: <GtkToolbar*>,
     widget :: <GtkWidget*>,
     tooltip_text :: <gchar*>,
     tooltip_private_text :: <gchar*>)
 => ();
  call-out("gtk_toolbar_append_widget", void:,
           ptr: toolbar.raw-value,
           ptr: widget.raw-value,
           ptr: tooltip_text.raw-value,
           ptr: tooltip_private_text.raw-value);
  values();
end function;

define inline-only function gtk-toolbar-prepend-widget
    (toolbar :: <GtkToolbar*>,
     widget :: <GtkWidget*>,
     tooltip_text :: <gchar*>,
     tooltip_private_text :: <gchar*>)
 => ();
  call-out("gtk_toolbar_prepend_widget", void:,
           ptr: toolbar.raw-value,
           ptr: widget.raw-value,
           ptr: tooltip_text.raw-value,
           ptr: tooltip_private_text.raw-value);
  values();
end function;

define inline-only function gtk-toolbar-insert-widget
    (toolbar :: <GtkToolbar*>,
     widget :: <GtkWidget*>,
     tooltip_text :: <gchar*>,
     tooltip_private_text :: <gchar*>,
     position :: <gint>)
 => ();
  call-out("gtk_toolbar_insert_widget", void:,
           ptr: toolbar.raw-value,
           ptr: widget.raw-value,
           ptr: tooltip_text.raw-value,
           ptr: tooltip_private_text.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-toolbar-set-orientation
    (toolbar :: <GtkToolbar*>,
     orientation :: <GtkOrientation>)
 => ();
  call-out("gtk_toolbar_set_orientation", void:,
           ptr: toolbar.raw-value,
           int: orientation);
  values();
end function;

define inline-only function gtk-toolbar-set-style
    (toolbar :: <GtkToolbar*>,
     style :: <GtkToolbarStyle>)
 => ();
  call-out("gtk_toolbar_set_style", void:,
           ptr: toolbar.raw-value,
           int: style);
  values();
end function;

define inline-only function gtk-toolbar-set-space-size
    (toolbar :: <GtkToolbar*>,
     space_size :: <gint>)
 => ();
  call-out("gtk_toolbar_set_space_size", void:,
           ptr: toolbar.raw-value,
           int: space_size);
  values();
end function;

define inline-only function gtk-toolbar-set-space-style
    (toolbar :: <GtkToolbar*>,
     style :: <GtkToolbarSpaceStyle>)
 => ();
  call-out("gtk_toolbar_set_space_style", void:,
           ptr: toolbar.raw-value,
           int: style);
  values();
end function;

define inline-only function gtk-toolbar-set-button-relief
    (toolbar :: <GtkToolbar*>,
     relief :: <GtkReliefStyle>)
 => ();
  call-out("gtk_toolbar_set_button_relief", void:,
           ptr: toolbar.raw-value,
           int: relief);
  values();
end function;

define inline-only function gtk-toolbar-get-button-relief
    (toolbar :: <GtkToolbar*>)
 => (return :: <GtkReliefStyle>);
  let return-value = call-out("gtk_toolbar_get_button_relief", int:,
           ptr: toolbar.raw-value);
  return-value;
end function;

define inline-only function gtk-toolbar-set-tooltips
    (toolbar :: <GtkToolbar*>,
     enable :: <gboolean>)
 => ();
  call-out("gtk_toolbar_set_tooltips", void:,
           ptr: toolbar.raw-value,
           int: enable);
  values();
end function;

define inline-only function gtk-table-new
    (rows :: <gint>,
     columns :: <gint>,
     homogenous :: <gboolean>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_table_new", ptr:,
           int: rows,
           int: columns,
           int: homogenous);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-table-attach
    (table :: <GtkTable*>,
     child :: <GtkWidget*>,
     left_attach :: <gint>,
     right_attach :: <gint>,
     top_attach :: <gint>,
     bottom_attach :: <gint>,
     xoptions :: <GtkAttachOptions>,
     yoptions :: <GtkAttachOptions>,
     xpadding :: <gint>,
     ypadding :: <gint>)
 => ();
  call-out("gtk_table_attach", void:,
           ptr: table.raw-value,
           ptr: child.raw-value,
           int: left_attach,
           int: right_attach,
           int: top_attach,
           int: bottom_attach,
           int: xoptions,
           int: yoptions,
           int: xpadding,
           int: ypadding);
  values();
end function;

define inline-only function gtk-table-attach-defaults
    (table :: <GtkTable*>,
     child :: <GtkWidget*>,
     left_attach :: <gint>,
     right_attach :: <gint>,
     top_attach :: <gint>,
     bottom_attach :: <gint>)
 => ();
  call-out("gtk_table_attach_defaults", void:,
           ptr: table.raw-value,
           ptr: child.raw-value,
           int: left_attach,
           int: right_attach,
           int: top_attach,
           int: bottom_attach);
  values();
end function;

define inline-only function gtk-table-set-row-spacing
    (table :: <GtkTable*>,
     row :: <gint>,
     spacing :: <gint>)
 => ();
  call-out("gtk_table_set_row_spacing", void:,
           ptr: table.raw-value,
           int: row,
           int: spacing);
  values();
end function;

define inline-only function gtk-table-set-col-spacing
    (table :: <GtkTable*>,
     column :: <gint>,
     spacing :: <gint>)
 => ();
  call-out("gtk_table_set_col_spacing", void:,
           ptr: table.raw-value,
           int: column,
           int: spacing);
  values();
end function;

define inline-only function gtk-table-set-row-spacings
    (table :: <GtkTable*>,
     spacing :: <gint>)
 => ();
  call-out("gtk_table_set_row_spacings", void:,
           ptr: table.raw-value,
           int: spacing);
  values();
end function;

define inline-only function gtk-table-set-col-spacings
    (table :: <GtkTable*>,
     spacing :: <gint>)
 => ();
  call-out("gtk_table_set_col_spacings", void:,
           ptr: table.raw-value,
           int: spacing);
  values();
end function;

define inline-only function gtk-button-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_button_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-button-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_button_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-button-pressed
    (button :: <GtkButton*>)
 => ();
  call-out("gtk_button_pressed", void:,
           ptr: button.raw-value);
  values();
end function;

define inline-only function gtk-button-released
    (button :: <GtkButton*>)
 => ();
  call-out("gtk_button_released", void:,
           ptr: button.raw-value);
  values();
end function;

define inline-only function gtk-button-clicked
    (button :: <GtkButton*>)
 => ();
  call-out("gtk_button_clicked", void:,
           ptr: button.raw-value);
  values();
end function;

define inline-only function gtk-button-enter
    (button :: <GtkButton*>)
 => ();
  call-out("gtk_button_enter", void:,
           ptr: button.raw-value);
  values();
end function;

define inline-only function gtk-button-leave
    (button :: <GtkButton*>)
 => ();
  call-out("gtk_button_leave", void:,
           ptr: button.raw-value);
  values();
end function;

define inline-only function gtk-toggle-button-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_toggle_button_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-toggle-button-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_toggle_button_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-toggle-button-set-mode
    (toggle_button :: <GtkToggleButton*>,
     draw_indicator :: <gboolean>)
 => ();
  call-out("gtk_toggle_button_set_mode", void:,
           ptr: toggle_button.raw-value,
           int: draw_indicator);
  values();
end function;

define inline-only function gtk-toggle-button-set-state
    (toggle_button :: <GtkToggleButton*>,
     state :: <gboolean>)
 => ();
  call-out("gtk_toggle_button_set_state", void:,
           ptr: toggle_button.raw-value,
           int: state);
  values();
end function;

define inline-only function gtk-toggle-button-set-active
    (toggle_button :: <GtkToggleButton*>,
     is_active :: <gboolean>)
 => ();
  call-out("gtk_toggle_button_set_active", void:,
           ptr: toggle_button.raw-value,
           int: is_active);
  values();
end function;

define inline-only function gtk-toggle-button-get-active
    (toggle_button :: <GtkToggleButton*>)
 => (return :: <gboolean>);
  let return-value = call-out("gtk_toggle_button_get_active", int:,
           ptr: toggle_button.raw-value);
  return-value;
end function;

define inline-only function gtk-toggle-button-toggled
    (toggle_button :: <GtkToggleButton*>)
 => ();
  call-out("gtk_toggle_button_toggled", void:,
           ptr: toggle_button.raw-value);
  values();
end function;

define inline-only function gtk-check-button-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_check_button_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-check-button-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_check_button_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-radio-button-new
    (group :: <GSList*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_radio_button_new", ptr:,
           ptr: group.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-radio-button-new-from-widget
    (group :: <GtkRadioButton*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_radio_button_new_from_widget", ptr:,
           ptr: group.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-radio-button-new-with-label
    (group :: <GSList*>,
     label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_radio_button_new_with_label", ptr:,
           ptr: group.raw-value,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-radio-button-new-with-label-from-widget
    (group :: <GtkRadioButton*>,
     label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_radio_button_new_with_label_from_widget", ptr:,
           ptr: group.raw-value,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-radio-button-group
    (button :: <GtkRadioButton*>)
 => (return :: <GSList*>);
  let return-value = call-out("gtk_radio_button_group", ptr:,
           ptr: button.raw-value);
  make(<GSList*>, pointer: return-value);
end function;

define inline-only function gtk-radio-button-set-group
    (button :: <GtkRadioButton*>,
     group :: <GSList*>)
 => ();
  call-out("gtk_radio_button_set_group", void:,
           ptr: button.raw-value,
           ptr: group.raw-value);
  values();
end function;

define inline-only function gtk-misc-set-alignment
    (misc :: <GtkMisc*>,
     xalign :: <gfloat>,
     yalign :: <gfloat>)
 => ();
  call-out("gtk_misc_set_alignment", void:,
           ptr: misc.raw-value,
           float: xalign,
           float: yalign);
  values();
end function;

define inline-only function gtk-misc-set-padding
    (misc :: <GtkMisc*>,
     xpad :: <gint>,
     ypad :: <gint>)
 => ();
  call-out("gtk_misc_set_padding", void:,
           ptr: misc.raw-value,
           int: xpad,
           int: ypad);
  values();
end function;

define inline-only function gtk-arrow-new
    (arrow_type :: <GtkArrowType>,
     shadow_type :: <GtkShadowType>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_arrow_new", ptr:,
           int: arrow_type,
           int: shadow_type);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-arrow-set
    (arrow :: <GtkArrow*>,
     arrow_type :: <GtkArrowType>,
     shadow_type :: <GtkShadowType>)
 => ();
  call-out("gtk_arrow_set", void:,
           ptr: arrow.raw-value,
           int: arrow_type,
           int: shadow_type);
  values();
end function;

define inline-only function gtk-label-new
    (str :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_label_new", ptr:,
           ptr: str.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-label-set-text
    (label :: <GtkLabel*>,
     str :: <gchar*>)
 => ();
  call-out("gtk_label_set_text", void:,
           ptr: label.raw-value,
           ptr: str.raw-value);
  values();
end function;

define inline-only function gtk-label-set-justify
    (label :: <GtkLabel*>,
     jtype :: <GtkJustification>)
 => ();
  call-out("gtk_label_set_justify", void:,
           ptr: label.raw-value,
           int: jtype);
  values();
end function;

define inline-only function gtk-label-set-line-wrap
    (label :: <GtkLabel*>,
     wrap :: <gboolean>)
 => ();
  call-out("gtk_label_set_line_wrap", void:,
           ptr: label.raw-value,
           int: wrap);
  values();
end function;

define inline-only function gtk-label-set-pattern
    (label :: <GtkLabel*>,
     str :: <gchar*>)
 => ();
  call-out("gtk_label_set_pattern", void:,
           ptr: label.raw-value,
           ptr: str.raw-value);
  values();
end function;

define inline-only function gtk-layout-new
    (hadjustment :: <GtkAdjustment*>,
     vadjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_layout_new", ptr:,
           ptr: hadjustment.raw-value,
           ptr: vadjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-layout-put
    (layout :: <GtkLayout*>,
     widget :: <GtkWidget*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gtk_layout_put", void:,
           ptr: layout.raw-value,
           ptr: widget.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gtk-layout-move
    (layout :: <GtkLayout*>,
     widget :: <GtkWidget*>,
     x :: <gint>,
     y :: <gint>)
 => ();
  call-out("gtk_layout_move", void:,
           ptr: layout.raw-value,
           ptr: widget.raw-value,
           int: x,
           int: y);
  values();
end function;

define inline-only function gtk-layout-set-size
    (layout :: <GtkLayout*>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gtk_layout_set_size", void:,
           ptr: layout.raw-value,
           int: width,
           int: height);
  values();
end function;

define inline-only function gtk-layout-get-hadjustment
    (layout :: <GtkLayout*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_layout_get_hadjustment", ptr:,
           ptr: layout.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-layout-get-vadjustment
    (layout :: <GtkLayout*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_layout_get_vadjustment", ptr:,
           ptr: layout.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-layout-set-hadjustment
    (layout :: <GtkLayout*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_layout_set_hadjustment", void:,
           ptr: layout.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-layout-set-vadjustment
    (layout :: <GtkLayout*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_layout_set_vadjustment", void:,
           ptr: layout.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-layout-freeze
    (layout :: <GtkLayout*>)
 => ();
  call-out("gtk_layout_freeze", void:,
           ptr: layout.raw-value);
  values();
end function;

define inline-only function gtk-layout-thaw
    (layout :: <GtkLayout*>)
 => ();
  call-out("gtk_layout_thaw", void:,
           ptr: layout.raw-value);
  values();
end function;

define inline-only function gtk-tips-query-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_tips_query_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-tips-query-start-query
    (tips_query :: <GtkTipsQuery*>)
 => ();
  call-out("gtk_tips_query_start_query", void:,
           ptr: tips_query.raw-value);
  values();
end function;

define inline-only function gtk-tips-query-stop-query
    (tips_query :: <GtkTipsQuery*>)
 => ();
  call-out("gtk_tips_query_stop_query", void:,
           ptr: tips_query.raw-value);
  values();
end function;

define inline-only function gtk-tips-query-set-caller
    (tips_query :: <GtkTipsQuery*>,
     caller :: <GtkWidget*>)
 => ();
  call-out("gtk_tips_query_set_caller", void:,
           ptr: tips_query.raw-value,
           ptr: caller.raw-value);
  values();
end function;

define inline-only function gtk-tips-query-set-labels
    (tips_query :: <GtkTipsQuery*>,
     label_inactive :: <gchar*>,
     label_no_tip :: <gchar*>)
 => ();
  call-out("gtk_tips_query_set_labels", void:,
           ptr: tips_query.raw-value,
           ptr: label_inactive.raw-value,
           ptr: label_no_tip.raw-value);
  values();
end function;

define inline-only function gtk-vbox-new
    (homogenous :: <gboolean>,
     spacing :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vbox_new", ptr:,
           int: homogenous,
           int: spacing);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-hbox-new
    (homogenous :: <gboolean>,
     spacing :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hbox_new", ptr:,
           int: homogenous,
           int: spacing);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-item-select
    (item :: <GtkItem*>)
 => ();
  call-out("gtk_item_select", void:,
           ptr: item.raw-value);
  values();
end function;

define inline-only function gtk-item-deselect
    (item :: <GtkItem*>)
 => ();
  call-out("gtk_item_deselect", void:,
           ptr: item.raw-value);
  values();
end function;

define inline-only function gtk-item-toggle
    (item :: <GtkItem*>)
 => ();
  call-out("gtk_item_toggle", void:,
           ptr: item.raw-value);
  values();
end function;

define inline-only function gtk-item-factory-from-widget
    (widget :: <GtkWidget*>)
 => (return :: <GtkItemFactory*>);
  let return-value = call-out("gtk_item_factory_from_widget", ptr:,
           ptr: widget.raw-value);
  make(<GtkItemFactory*>, pointer: return-value);
end function;

define inline-only function gtk-item-factory-path-from-widget
    (widget :: <GtkWidget*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_item_factory_path_from_widget", ptr:,
           ptr: widget.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-combo-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_combo_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-combo-set-value-in-list
    (combo :: <GtkCombo*>,
     val :: <gboolean>,
     ok_if_empty :: <gboolean>)
 => ();
  call-out("gtk_combo_set_value_in_list", void:,
           ptr: combo.raw-value,
           int: val,
           int: ok_if_empty);
  values();
end function;

define inline-only function gtk-combo-set-use-arrows
    (combo :: <GtkCombo*>,
     val :: <gboolean>)
 => ();
  call-out("gtk_combo_set_use_arrows", void:,
           ptr: combo.raw-value,
           int: val);
  values();
end function;

define inline-only function gtk-combo-set-use-arrows-always
    (combo :: <GtkCombo*>,
     val :: <gboolean>)
 => ();
  call-out("gtk_combo_set_use_arrows_always", void:,
           ptr: combo.raw-value,
           int: val);
  values();
end function;

define inline-only function gtk-combo-set-case-sensitive
    (combo :: <GtkCombo*>,
     val :: <gboolean>)
 => ();
  call-out("gtk_combo_set_case_sensitive", void:,
           ptr: combo.raw-value,
           int: val);
  values();
end function;

define inline-only function gtk-combo-set-item-string
    (combo :: <GtkCombo*>,
     item :: <GtkItem*>,
     item_value :: <gchar*>)
 => ();
  call-out("gtk_combo_set_item_string", void:,
           ptr: combo.raw-value,
           ptr: item.raw-value,
           ptr: item_value.raw-value);
  values();
end function;

define inline-only function gtk-combo-disable-activate
    (combo :: <GtkCombo*>)
 => ();
  call-out("gtk_combo_disable_activate", void:,
           ptr: combo.raw-value);
  values();
end function;

define inline-only function gtk-combo-set-popdown-strings
    (combo :: <GtkCombo*>,
     strings :: <GList*>)
 => ();
  call-out("gtk_combo_set_popdown_strings", void:,
           ptr: combo.raw-value,
           ptr: strings.raw-value);
  values();
end function;

define inline-only function gtk-statusbar-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_statusbar_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-statusbar-push
    (statusbar :: <GtkStatusbar*>,
     context_id :: <guint>,
     text :: <gchar*>)
 => (return :: <guint>);
  let return-value = call-out("gtk_statusbar_push", int:,
           ptr: statusbar.raw-value,
           int: context_id,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-statusbar-pop
    (statusbar :: <GtkStatusbar*>,
     context_id :: <guint>)
 => ();
  call-out("gtk_statusbar_pop", void:,
           ptr: statusbar.raw-value,
           int: context_id);
  values();
end function;

define inline-only function gtk-statusbar-get-context-id
    (statusbar :: <GtkStatusbar*>,
     context_description :: <gchar*>)
 => (return :: <guint>);
  let return-value = call-out("gtk_statusbar_get_context_id", int:,
           ptr: statusbar.raw-value,
           ptr: context_description.raw-value);
  return-value;
end function;

define inline-only function gtk-statusbar-remove
    (statusbar :: <GtkStatusbar*>,
     context_id :: <guint>,
     message_id :: <guint>)
 => ();
  call-out("gtk_statusbar_remove", void:,
           ptr: statusbar.raw-value,
           int: context_id,
           int: message_id);
  values();
end function;

define inline-only function gtk-gamma-curve-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_gamma_curve_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-hseparator-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hseparator_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-vseparator-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vseparator_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-frame-new
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_frame_new", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-frame-set-label
    (frame :: <GtkFrame*>,
     label :: <gchar*>)
 => ();
  call-out("gtk_frame_set_label", void:,
           ptr: frame.raw-value,
           ptr: label.raw-value);
  values();
end function;

define inline-only function gtk-frame-set-label-align
    (frame :: <GtkFrame*>,
     xalign :: <gfloat>,
     yalign :: <gfloat>)
 => ();
  call-out("gtk_frame_set_label_align", void:,
           ptr: frame.raw-value,
           float: xalign,
           float: yalign);
  values();
end function;

define inline-only function gtk-frame-set-shadow-type
    (frame :: <GtkFrame*>,
     type :: <GtkShadowType>)
 => ();
  call-out("gtk_frame_set_shadow_type", void:,
           ptr: frame.raw-value,
           int: type);
  values();
end function;

define inline-only function gtk-aspect-frame-new
    (label :: <gchar*>,
     xalign :: <gfloat>,
     yalign :: <gfloat>,
     ratio :: <gfloat>,
     obey_child :: <gboolean>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_aspect_frame_new", ptr:,
           ptr: label.raw-value,
           float: xalign,
           float: yalign,
           float: ratio,
           int: obey_child);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-aspect-frame-set
    (aspect_frame :: <GtkAspectFrame*>,
     xalign :: <gfloat>,
     yalign :: <gfloat>,
     ratio :: <gfloat>,
     obey_child :: <gboolean>)
 => ();
  call-out("gtk_aspect_frame_set", void:,
           ptr: aspect_frame.raw-value,
           float: xalign,
           float: yalign,
           float: ratio,
           int: obey_child);
  values();
end function;

define inline-only function gtk-progress-bar-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_progress_bar_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-progress-bar-set-discrete-blocks
    (progressbar :: <GtkProgressBar*>,
     blocks :: <gint>)
 => ();
  call-out("gtk_progress_bar_set_discrete_blocks", void:,
           ptr: progressbar.raw-value,
           int: blocks);
  values();
end function;

define inline-only function gtk-progress-bar-set-activity-step
    (progressbar :: <GtkProgressBar*>,
     step :: <gint>)
 => ();
  call-out("gtk_progress_bar_set_activity_step", void:,
           ptr: progressbar.raw-value,
           int: step);
  values();
end function;

define inline-only function gtk-progress-bar-set-activity-blocks
    (progressbar :: <GtkProgressBar*>,
     blocks :: <gint>)
 => ();
  call-out("gtk_progress_bar_set_activity_blocks", void:,
           ptr: progressbar.raw-value,
           int: blocks);
  values();
end function;

define inline-only function gtk-progress-bar-update
    (progress_bar :: <GtkProgressBar*>,
     percentage :: <gfloat>)
 => ();
  call-out("gtk_progress_bar_update", void:,
           ptr: progress_bar.raw-value,
           float: percentage);
  values();
end function;

define inline-only function gtk-progress-set-show-text
    (progress :: <GtkProgress*>,
     show_text :: <gboolean>)
 => ();
  call-out("gtk_progress_set_show_text", void:,
           ptr: progress.raw-value,
           int: show_text);
  values();
end function;

define inline-only function gtk-progress-set-text-alignment
    (progress :: <GtkProgress*>,
     x_align :: <gfloat>,
     y_align :: <gfloat>)
 => ();
  call-out("gtk_progress_set_text_alignment", void:,
           ptr: progress.raw-value,
           float: x_align,
           float: y_align);
  values();
end function;

define inline-only function gtk-progress-set-format-string
    (progress :: <GtkProgress*>,
     format :: <gchar*>)
 => ();
  call-out("gtk_progress_set_format_string", void:,
           ptr: progress.raw-value,
           ptr: format.raw-value);
  values();
end function;

define inline-only function gtk-progress-set-adjustment
    (progress :: <GtkProgress*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_progress_set_adjustment", void:,
           ptr: progress.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-progress-configure
    (progress :: <GtkProgress*>,
     value :: <gfloat>,
     min :: <gfloat>,
     max :: <gfloat>)
 => ();
  call-out("gtk_progress_configure", void:,
           ptr: progress.raw-value,
           float: value,
           float: min,
           float: max);
  values();
end function;

define inline-only function gtk-progress-set-percentage
    (progress :: <GtkProgress*>,
     percentage :: <gfloat>)
 => ();
  call-out("gtk_progress_set_percentage", void:,
           ptr: progress.raw-value,
           float: percentage);
  values();
end function;

define inline-only function gtk-progress-set-value
    (progress :: <GtkProgress*>,
     value :: <gfloat>)
 => ();
  call-out("gtk_progress_set_value", void:,
           ptr: progress.raw-value,
           float: value);
  values();
end function;

define inline-only function gtk-progress-get-value
    (progress :: <GtkProgress*>)
 => (return :: <gfloat>);
  let return-value = call-out("gtk_progress_get_value", float:,
           ptr: progress.raw-value);
  return-value;
end function;

define inline-only function gtk-progress-set-activity-mode
    (progress :: <GtkProgress*>,
     activity_mode :: <gboolean>)
 => ();
  call-out("gtk_progress_set_activity_mode", void:,
           ptr: progress.raw-value,
           int: activity_mode);
  values();
end function;

define inline-only function gtk-progress-get-current-text
    (progress :: <GtkProgress*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_progress_get_current_text", ptr:,
           ptr: progress.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-progress-get-text-from-value
    (progress :: <GtkProgress*>,
     value :: <gfloat>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_progress_get_text_from_value", ptr:,
           ptr: progress.raw-value,
           float: value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-tooltips-new
    ()
 => (return :: <GtkTooltips*>);
  let return-value = call-out("gtk_tooltips_new", ptr:);
  make(<GtkTooltips*>, pointer: return-value);
end function;

define inline-only function gtk-tooltips-enable
    (tooltips :: <GtkTooltips*>)
 => ();
  call-out("gtk_tooltips_enable", void:,
           ptr: tooltips.raw-value);
  values();
end function;

define inline-only function gtk-tooltips-disable
    (tooltips :: <GtkTooltips*>)
 => ();
  call-out("gtk_tooltips_disable", void:,
           ptr: tooltips.raw-value);
  values();
end function;

define inline-only function gtk-tooltips-set-delay
    (tooltips :: <GtkTooltips*>,
     delay :: <gint>)
 => ();
  call-out("gtk_tooltips_set_delay", void:,
           ptr: tooltips.raw-value,
           int: delay);
  values();
end function;

define inline-only function gtk-tooltips-set-tip
    (tooltips :: <GtkTooltips*>,
     widget :: <GtkWidget*>,
     tip_text :: <gchar*>,
     tip_private :: <gchar*>)
 => ();
  call-out("gtk_tooltips_set_tip", void:,
           ptr: tooltips.raw-value,
           ptr: widget.raw-value,
           ptr: tip_text.raw-value,
           ptr: tip_private.raw-value);
  values();
end function;

define inline-only function gtk-tooltips-set-colors
    (tooltips :: <GtkTooltips*>,
     background :: <GdkColor*>,
     foreground :: <GdkColor*>)
 => ();
  call-out("gtk_tooltips_set_colors", void:,
           ptr: tooltips.raw-value,
           ptr: background.raw-value,
           ptr: foreground.raw-value);
  values();
end function;

define inline-only function gtk-tooltips-force-window
    (tooltips :: <GtkTooltips*>)
 => ();
  call-out("gtk_tooltips_force_window", void:,
           ptr: tooltips.raw-value);
  values();
end function;

define inline-only function gtk-menu-shell-append
    (menu_shell :: <GtkMenuShell*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_shell_append", void:,
           ptr: menu_shell.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-menu-shell-prepend
    (menu_shell :: <GtkMenuShell*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_shell_prepend", void:,
           ptr: menu_shell.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-menu-shell-insert
    (menu_shell :: <GtkMenuShell*>,
     child :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_menu_shell_insert", void:,
           ptr: menu_shell.raw-value,
           ptr: child.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-menu-shell-deactivate
    (menu_shell :: <GtkMenuShell*>)
 => ();
  call-out("gtk_menu_shell_deactivate", void:,
           ptr: menu_shell.raw-value);
  values();
end function;

define inline-only function gtk-menu-bar-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_menu_bar_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-menu-bar-append
    (menu_bar :: <GtkMenuBar*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_bar_append", void:,
           ptr: menu_bar.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-menu-bar-prepend
    (menu_bar :: <GtkMenuBar*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_bar_prepend", void:,
           ptr: menu_bar.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-menu-bar-insert
    (menu_bar :: <GtkMenuBar*>,
     child :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_menu_bar_insert", void:,
           ptr: menu_bar.raw-value,
           ptr: child.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-menu-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_menu_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-menu-append
    (menu :: <GtkMenu*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_append", void:,
           ptr: menu.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-menu-prepend
    (menu :: <GtkMenu*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_prepend", void:,
           ptr: menu.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-menu-insert
    (menu :: <GtkMenu*>,
     child :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_menu_insert", void:,
           ptr: menu.raw-value,
           ptr: child.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-menu-popdown
    (menu :: <GtkMenu*>)
 => ();
  call-out("gtk_menu_popdown", void:,
           ptr: menu.raw-value);
  values();
end function;

define inline-only function gtk-menu-get-active
    (menu :: <GtkMenu*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_menu_get_active", ptr:,
           ptr: menu.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-menu-set-active
    (menu :: <GtkMenu*>,
     index :: <gint>)
 => ();
  call-out("gtk_menu_set_active", void:,
           ptr: menu.raw-value,
           int: index);
  values();
end function;

define inline-only function gtk-menu-get-attach-widget
    (menu :: <GtkMenu*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_menu_get_attach_widget", ptr:,
           ptr: menu.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-menu-detach
    (menu :: <GtkMenu*>)
 => ();
  call-out("gtk_menu_detach", void:,
           ptr: menu.raw-value);
  values();
end function;

define inline-only function gtk-menu-item-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_menu_item_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-menu-item-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_menu_item_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-menu-item-set-submenu
    (menu_item :: <GtkMenuItem*>,
     submenu :: <GtkWidget*>)
 => ();
  call-out("gtk_menu_item_set_submenu", void:,
           ptr: menu_item.raw-value,
           ptr: submenu.raw-value);
  values();
end function;

define inline-only function gtk-menu-item-remove-submenu
    (menu_item :: <GtkMenuItem*>)
 => ();
  call-out("gtk_menu_item_remove_submenu", void:,
           ptr: menu_item.raw-value);
  values();
end function;

define inline-only function gtk-menu-item-set-placement
    (menu_item :: <GtkMenuItem*>,
     placement :: <GtkSubmenuPlacement>)
 => ();
  call-out("gtk_menu_item_set_placement", void:,
           ptr: menu_item.raw-value,
           int: placement);
  values();
end function;

define inline-only function gtk-menu-item-configure
    (menu_item :: <GtkMenuItem*>,
     show_toggle_indicator :: <gboolean>,
     show_submenu_indicator :: <gboolean>)
 => ();
  call-out("gtk_menu_item_configure", void:,
           ptr: menu_item.raw-value,
           int: show_toggle_indicator,
           int: show_submenu_indicator);
  values();
end function;

define inline-only function gtk-menu-item-select
    (menu_item :: <GtkMenuItem*>)
 => ();
  call-out("gtk_menu_item_select", void:,
           ptr: menu_item.raw-value);
  values();
end function;

define inline-only function gtk-menu-item-deselect
    (menu_item :: <GtkMenuItem*>)
 => ();
  call-out("gtk_menu_item_deselect", void:,
           ptr: menu_item.raw-value);
  values();
end function;

define inline-only function gtk-menu-item-activate
    (menu_item :: <GtkMenuItem*>)
 => ();
  call-out("gtk_menu_item_activate", void:,
           ptr: menu_item.raw-value);
  values();
end function;

define inline-only function gtk-menu-item-right-justify
    (menu_item :: <GtkMenuItem*>)
 => ();
  call-out("gtk_menu_item_right_justify", void:,
           ptr: menu_item.raw-value);
  values();
end function;

define inline-only function gtk-menu-get-uline-accel-group
    (menu :: <GtkMenu*>)
 => (return :: <GtkAccelGroup*>);
  let return-value = call-out("gtk_menu_get_uline_accel_group", ptr:,
           ptr: menu.raw-value);
  make(<GtkAccelGroup*>, pointer: return-value);
end function;

define inline-only function gtk-menu-ensure-uline-accel-group
    (menu :: <GtkMenu*>)
 => (return :: <GtkAccelGroup*>);
  let return-value = call-out("gtk_menu_ensure_uline_accel_group", ptr:,
           ptr: menu.raw-value);
  make(<GtkAccelGroup*>, pointer: return-value);
end function;

define inline-only function gtk-tearoff-menu-item-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_tearoff_menu_item_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-accel-label-new
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_accel_label_new", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-accel-label-set-accel-widget
    (accel_label :: <GtkAccelLabel*>,
     accel_widget :: <GtkWidget*>)
 => ();
  call-out("gtk_accel_label_set_accel_widget", void:,
           ptr: accel_label.raw-value,
           ptr: accel_widget.raw-value);
  values();
end function;

define inline-only function gtk-label-parse-uline
    (label :: <GtkLabel*>,
     name :: <gchar*>)
 => (return :: <guint>);
  let return-value = call-out("gtk_label_parse_uline", int:,
           ptr: label.raw-value,
           ptr: name.raw-value);
  return-value;
end function;

define inline-only function gtk-check-menu-item-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_check_menu_item_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-check-menu-item-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_check_menu_item_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-check-menu-item-set-state
    (check_menu_item :: <GtkCheckMenuItem*>,
     state :: <gboolean>)
 => ();
  call-out("gtk_check_menu_item_set_state", void:,
           ptr: check_menu_item.raw-value,
           int: state);
  values();
end function;

define inline-only function gtk-check-menu-item-set-show-toggle
    (menu_item :: <GtkCheckMenuItem*>,
     always :: <gboolean>)
 => ();
  call-out("gtk_check_menu_item_set_show_toggle", void:,
           ptr: menu_item.raw-value,
           int: always);
  values();
end function;

define inline-only function gtk-check-menu-item-toggled
    (check_menu_item :: <GtkCheckMenuItem*>)
 => ();
  call-out("gtk_check_menu_item_toggled", void:,
           ptr: check_menu_item.raw-value);
  values();
end function;

define inline-only function gtk-option-menu-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_option_menu_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-option-menu-get-menu
    (option_menu :: <GtkOptionMenu*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_option_menu_get_menu", ptr:,
           ptr: option_menu.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-option-menu-set-menu
    (option_menu :: <GtkOptionMenu*>,
     menu :: <GtkWidget*>)
 => ();
  call-out("gtk_option_menu_set_menu", void:,
           ptr: option_menu.raw-value,
           ptr: menu.raw-value);
  values();
end function;

define inline-only function gtk-option-menu-remove-menu
    (option_menu :: <GtkOptionMenu*>)
 => ();
  call-out("gtk_option_menu_remove_menu", void:,
           ptr: option_menu.raw-value);
  values();
end function;

define inline-only function gtk-option-menu-set-history
    (option_menu :: <GtkOptionMenu*>,
     index :: <gint>)
 => ();
  call-out("gtk_option_menu_set_history", void:,
           ptr: option_menu.raw-value,
           int: index);
  values();
end function;

define inline-only function gtk-pixmap-get
    (pixmap :: <GtkPixmap*>,
     GdkPixmap :: <GdkWindow**>,
     gdkmask :: <GdkWindow**>)
 => ();
  call-out("gtk_pixmap_get", void:,
           ptr: pixmap.raw-value,
           ptr: GdkPixmap.raw-value,
           ptr: gdkmask.raw-value);
  values();
end function;

define inline-only function gtk-viewport-new
    (hadjustment :: <GtkAdjustment*>,
     vadjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_viewport_new", ptr:,
           ptr: hadjustment.raw-value,
           ptr: vadjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-viewport-get-hadjustment
    (viewport :: <GtkViewport*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_viewport_get_hadjustment", ptr:,
           ptr: viewport.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-viewport-get-vadjustment
    (viewport :: <GtkViewport*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_viewport_get_vadjustment", ptr:,
           ptr: viewport.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-viewport-set-hadjustment
    (viewport :: <GtkViewport*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_viewport_set_hadjustment", void:,
           ptr: viewport.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-viewport-set-vadjustment
    (viewport :: <GtkViewport*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_viewport_set_vadjustment", void:,
           ptr: viewport.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-viewport-set-shadow-type
    (viewport :: <GtkViewport*>,
     type :: <GtkShadowType>)
 => ();
  call-out("gtk_viewport_set_shadow_type", void:,
           ptr: viewport.raw-value,
           int: type);
  values();
end function;

define inline-only function gtk-scrolled-window-new
    (hadjustment :: <GtkAdjustment*>,
     vadjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_scrolled_window_new", ptr:,
           ptr: hadjustment.raw-value,
           ptr: vadjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-scrolled-window-add-with-viewport
    (scrolled_window :: <GtkScrolledWindow*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_scrolled_window_add_with_viewport", void:,
           ptr: scrolled_window.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-scrolled-window-get-hadjustment
    (scrolled_window :: <GtkScrolledWindow*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_scrolled_window_get_hadjustment", ptr:,
           ptr: scrolled_window.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-scrolled-window-get-vadjustment
    (scrolled_window :: <GtkScrolledWindow*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_scrolled_window_get_vadjustment", ptr:,
           ptr: scrolled_window.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-scrolled-window-set-policy
    (scrolled_window :: <GtkScrolledWindow*>,
     hscrollbar_policy :: <GtkPolicyType>,
     vscrollbar_policy :: <GtkPolicyType>)
 => ();
  call-out("gtk_scrolled_window_set_policy", void:,
           ptr: scrolled_window.raw-value,
           int: hscrollbar_policy,
           int: vscrollbar_policy);
  values();
end function;

define inline-only function gtk-list-item-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_list_item_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-list-item-new-with-label
    (label :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_list_item_new_with_label", ptr:,
           ptr: label.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-list-item-select
    (list_item :: <GtkListItem*>)
 => ();
  call-out("gtk_list_item_select", void:,
           ptr: list_item.raw-value);
  values();
end function;

define inline-only function gtk-list-item-deselect
    (list_item :: <GtkListItem*>)
 => ();
  call-out("gtk_list_item_deselect", void:,
           ptr: list_item.raw-value);
  values();
end function;

define inline-only function gtk-list-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_list_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-list-clear-items
    (list :: <GtkList*>,
     istart :: <gint>,
     iend :: <gint>)
 => ();
  call-out("gtk_list_clear_items", void:,
           ptr: list.raw-value,
           int: istart,
           int: iend);
  values();
end function;

define inline-only function gtk-list-select-item
    (list :: <GtkList*>,
     item :: <gint>)
 => ();
  call-out("gtk_list_select_item", void:,
           ptr: list.raw-value,
           int: item);
  values();
end function;

define inline-only function gtk-list-unselect-item
    (list :: <GtkList*>,
     item :: <gint>)
 => ();
  call-out("gtk_list_unselect_item", void:,
           ptr: list.raw-value,
           int: item);
  values();
end function;

define inline-only function gtk-list-select-child
    (list :: <GtkList*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_list_select_child", void:,
           ptr: list.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-list-unselect-child
    (list :: <GtkList*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_list_unselect_child", void:,
           ptr: list.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-list-child-position
    (list :: <GtkList*>,
     child :: <GtkWidget*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_list_child_position", int:,
           ptr: list.raw-value,
           ptr: child.raw-value);
  return-value;
end function;

define inline-only function gtk-list-set-selection-mode
    (list :: <GtkList*>,
     mode :: <GtkSelectionMode>)
 => ();
  call-out("gtk_list_set_selection_mode", void:,
           ptr: list.raw-value,
           int: mode);
  values();
end function;

define inline-only function gtk-notebook-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_notebook_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-notebook-append-page
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>)
 => ();
  call-out("gtk_notebook_append_page", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value);
  values();
end function;

define inline-only function gtk-notebook-append-page-menu
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>,
     menu_label :: <GtkWidget*>)
 => ();
  call-out("gtk_notebook_append_page_menu", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value,
           ptr: menu_label.raw-value);
  values();
end function;

define inline-only function gtk-notebook-prepend-page
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>)
 => ();
  call-out("gtk_notebook_prepend_page", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value);
  values();
end function;

define inline-only function gtk-notebook-prepend-page-menu
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>,
     menu_label :: <GtkWidget*>)
 => ();
  call-out("gtk_notebook_prepend_page_menu", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value,
           ptr: menu_label.raw-value);
  values();
end function;

define inline-only function gtk-notebook-insert-page
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_notebook_insert_page", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-notebook-insert-page-menu
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>,
     menu_label :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_notebook_insert_page_menu", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value,
           ptr: menu_label.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-notebook-remove-page
    (notebook :: <GtkNotebook*>,
     page_num :: <gint>)
 => ();
  call-out("gtk_notebook_remove_page", void:,
           ptr: notebook.raw-value,
           int: page_num);
  values();
end function;

define inline-only function gtk-notebook-get-current-page
    (notebook :: <GtkNotebook*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_notebook_get_current_page", int:,
           ptr: notebook.raw-value);
  return-value;
end function;

define inline-only function gtk-notebook-get-nth-page
    (notebook :: <GtkNotebook*>,
     page_num :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_notebook_get_nth_page", ptr:,
           ptr: notebook.raw-value,
           int: page_num);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-notebook-page-num
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_notebook_page_num", int:,
           ptr: notebook.raw-value,
           ptr: child.raw-value);
  return-value;
end function;

define inline-only function gtk-notebook-set-page
    (notebook :: <GtkNotebook*>,
     page_num :: <gint>)
 => ();
  call-out("gtk_notebook_set_page", void:,
           ptr: notebook.raw-value,
           int: page_num);
  values();
end function;

define inline-only function gtk-notebook-next-page
    (notebook :: <GtkNotebook*>)
 => ();
  call-out("gtk_notebook_next_page", void:,
           ptr: notebook.raw-value);
  values();
end function;

define inline-only function gtk-notebook-prev-page
    (notebook :: <GtkNotebook*>)
 => ();
  call-out("gtk_notebook_prev_page", void:,
           ptr: notebook.raw-value);
  values();
end function;

define inline-only function gtk-notebook-set-tab-pos
    (notebook :: <GtkNotebook*>,
     pos :: <GtkPositionType>)
 => ();
  call-out("gtk_notebook_set_tab_pos", void:,
           ptr: notebook.raw-value,
           int: pos);
  values();
end function;

define inline-only function gtk-notebook-set-show-tabs
    (notebook :: <GtkNotebook*>,
     show_tabs :: <gboolean>)
 => ();
  call-out("gtk_notebook_set_show_tabs", void:,
           ptr: notebook.raw-value,
           int: show_tabs);
  values();
end function;

define inline-only function gtk-notebook-set-show-border
    (notebook :: <GtkNotebook*>,
     show_border :: <gboolean>)
 => ();
  call-out("gtk_notebook_set_show_border", void:,
           ptr: notebook.raw-value,
           int: show_border);
  values();
end function;

define inline-only function gtk-notebook-set-scrollable
    (notebook :: <GtkNotebook*>,
     scrollable :: <gboolean>)
 => ();
  call-out("gtk_notebook_set_scrollable", void:,
           ptr: notebook.raw-value,
           int: scrollable);
  values();
end function;

define inline-only function gtk-notebook-set-tab-border
    (notebook :: <GtkNotebook*>,
     border_width :: <gint>)
 => ();
  call-out("gtk_notebook_set_tab_border", void:,
           ptr: notebook.raw-value,
           int: border_width);
  values();
end function;

define inline-only function gtk-notebook-set-homogeneous-tabs
    (notebook :: <GtkNotebook*>,
     homogenous :: <gboolean>)
 => ();
  call-out("gtk_notebook_set_homogeneous_tabs", void:,
           ptr: notebook.raw-value,
           int: homogenous);
  values();
end function;

define inline-only function gtk-notebook-set-tab-hborder
    (notebook :: <GtkNotebook*>,
     tab_hborder :: <gint>)
 => ();
  call-out("gtk_notebook_set_tab_hborder", void:,
           ptr: notebook.raw-value,
           int: tab_hborder);
  values();
end function;

define inline-only function gtk-notebook-set-tab-vborder
    (notebook :: <GtkNotebook*>,
     tab_vborder :: <gint>)
 => ();
  call-out("gtk_notebook_set_tab_vborder", void:,
           ptr: notebook.raw-value,
           int: tab_vborder);
  values();
end function;

define inline-only function gtk-notebook-popup-enable
    (notebook :: <GtkNotebook*>)
 => ();
  call-out("gtk_notebook_popup_enable", void:,
           ptr: notebook.raw-value);
  values();
end function;

define inline-only function gtk-notebook-popup-disable
    (notebook :: <GtkNotebook*>)
 => ();
  call-out("gtk_notebook_popup_disable", void:,
           ptr: notebook.raw-value);
  values();
end function;

define inline-only function gtk-notebook-get-tab-label
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_notebook_get_tab_label", ptr:,
           ptr: notebook.raw-value,
           ptr: child.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-notebook-set-tab-label
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     tab_label :: <GtkWidget*>)
 => ();
  call-out("gtk_notebook_set_tab_label", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: tab_label.raw-value);
  values();
end function;

define inline-only function gtk-notebook-get-menu-label
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_notebook_get_menu_label", ptr:,
           ptr: notebook.raw-value,
           ptr: child.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-notebook-set-menu-label
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     menu_label :: <GtkWidget*>)
 => ();
  call-out("gtk_notebook_set_menu_label", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           ptr: menu_label.raw-value);
  values();
end function;

define inline-only function gtk-notebook-reorder-child
    (notebook :: <GtkNotebook*>,
     child :: <GtkWidget*>,
     position :: <gint>)
 => ();
  call-out("gtk_notebook_reorder_child", void:,
           ptr: notebook.raw-value,
           ptr: child.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-editable-select-region
    (editable :: <GtkEditable*>,
     istart :: <gint>,
     iend :: <gint>)
 => ();
  call-out("gtk_editable_select_region", void:,
           ptr: editable.raw-value,
           int: istart,
           int: iend);
  values();
end function;

define inline-only function gtk-editable-insert-text
    (editable :: <GtkEditable*>,
     new_text :: <gchar*>,
     new_text_length :: <gint>,
     position :: <gint*>)
 => ();
  call-out("gtk_editable_insert_text", void:,
           ptr: editable.raw-value,
           ptr: new_text.raw-value,
           int: new_text_length,
           ptr: position.raw-value);
  values();
end function;

define inline-only function gtk-editable-delete-text
    (editable :: <GtkEditable*>,
     istart :: <gint>,
     iend :: <gint>)
 => ();
  call-out("gtk_editable_delete_text", void:,
           ptr: editable.raw-value,
           int: istart,
           int: iend);
  values();
end function;

define inline-only function gtk-editable-get-chars
    (editable :: <GtkEditable*>,
     istart :: <gint>,
     iend :: <gint>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_editable_get_chars", ptr:,
           ptr: editable.raw-value,
           int: istart,
           int: iend);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-editable-cut-clipboard
    (editable :: <GtkEditable*>)
 => ();
  call-out("gtk_editable_cut_clipboard", void:,
           ptr: editable.raw-value);
  values();
end function;

define inline-only function gtk-editable-copy-clipboard
    (editable :: <GtkEditable*>)
 => ();
  call-out("gtk_editable_copy_clipboard", void:,
           ptr: editable.raw-value);
  values();
end function;

define inline-only function gtk-editable-paste-clipboard
    (editable :: <GtkEditable*>)
 => ();
  call-out("gtk_editable_paste_clipboard", void:,
           ptr: editable.raw-value);
  values();
end function;

define inline-only function gtk-editable-delete-selection
    (editable :: <GtkEditable*>)
 => ();
  call-out("gtk_editable_delete_selection", void:,
           ptr: editable.raw-value);
  values();
end function;

define inline-only function gtk-editable-set-position
    (editable :: <GtkEditable*>,
     index :: <gint>)
 => ();
  call-out("gtk_editable_set_position", void:,
           ptr: editable.raw-value,
           int: index);
  values();
end function;

define inline-only function gtk-editable-get-position
    (editable :: <GtkEditable*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_editable_get_position", int:,
           ptr: editable.raw-value);
  return-value;
end function;

define inline-only function gtk-editable-set-editable
    (editable :: <GtkEditable*>,
     is_editable :: <gboolean>)
 => ();
  call-out("gtk_editable_set_editable", void:,
           ptr: editable.raw-value,
           int: is_editable);
  values();
end function;

define inline-only function gtk-entry-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_entry_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-entry-new-with-max-length
    (max :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_entry_new_with_max_length", ptr:,
           int: max);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-entry-set-text
    (entry :: <GtkEntry*>,
     text :: <gchar*>)
 => ();
  call-out("gtk_entry_set_text", void:,
           ptr: entry.raw-value,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-entry-append-text
    (entry :: <GtkEntry*>,
     text :: <gchar*>)
 => ();
  call-out("gtk_entry_append_text", void:,
           ptr: entry.raw-value,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-entry-prepend-text
    (entry :: <GtkEntry*>,
     text :: <gchar*>)
 => ();
  call-out("gtk_entry_prepend_text", void:,
           ptr: entry.raw-value,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-entry-set-position
    (entry :: <GtkEntry*>,
     position :: <gint>)
 => ();
  call-out("gtk_entry_set_position", void:,
           ptr: entry.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-entry-get-text
    (entry :: <GtkEntry*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_entry_get_text", ptr:,
           ptr: entry.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-entry-select-region
    (entry :: <GtkEntry*>,
     istart :: <gint>,
     iend :: <gint>)
 => ();
  call-out("gtk_entry_select_region", void:,
           ptr: entry.raw-value,
           int: istart,
           int: iend);
  values();
end function;

define inline-only function gtk-entry-set-visibility
    (entry :: <GtkEntry*>,
     visible :: <gboolean>)
 => ();
  call-out("gtk_entry_set_visibility", void:,
           ptr: entry.raw-value,
           int: visible);
  values();
end function;

define inline-only function gtk-entry-set-editable
    (entry :: <GtkEntry*>,
     editable :: <gboolean>)
 => ();
  call-out("gtk_entry_set_editable", void:,
           ptr: entry.raw-value,
           int: editable);
  values();
end function;

define inline-only function gtk-spin-button-configure
    (spin_button :: <GtkSpinButton*>,
     adjustment :: <GtkAdjustment*>,
     climb_rate :: <gfloat>,
     digits :: <gint>)
 => ();
  call-out("gtk_spin_button_configure", void:,
           ptr: spin_button.raw-value,
           ptr: adjustment.raw-value,
           float: climb_rate,
           int: digits);
  values();
end function;

define inline-only function gtk-spin-button-new
    (adjustment :: <GtkAdjustment*>,
     climb_rate :: <gfloat>,
     digits :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_spin_button_new", ptr:,
           ptr: adjustment.raw-value,
           float: climb_rate,
           int: digits);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-spin-button-set-adjustment
    (spin_button :: <GtkSpinButton*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_spin_button_set_adjustment", void:,
           ptr: spin_button.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-spin-button-get-adjustment
    (spin_button :: <GtkSpinButton*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_spin_button_get_adjustment", ptr:,
           ptr: spin_button.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-spin-button-set-digits
    (spin_button :: <GtkSpinButton*>,
     digits :: <gint>)
 => ();
  call-out("gtk_spin_button_set_digits", void:,
           ptr: spin_button.raw-value,
           int: digits);
  values();
end function;

define inline-only function gtk-spin-button-get-value-as-float
    (spin_button :: <GtkSpinButton*>)
 => (return :: <gfloat>);
  let return-value = call-out("gtk_spin_button_get_value_as_float", float:,
           ptr: spin_button.raw-value);
  return-value;
end function;

define inline-only function gtk-spin-button-get-value-as-int
    (spin_button :: <GtkSpinButton*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_spin_button_get_value_as_int", int:,
           ptr: spin_button.raw-value);
  return-value;
end function;

define inline-only function gtk-spin-button-set-value
    (spin_button :: <GtkSpinButton*>,
     value :: <gfloat>)
 => ();
  call-out("gtk_spin_button_set_value", void:,
           ptr: spin_button.raw-value,
           float: value);
  values();
end function;

define inline-only function gtk-spin-button-set-update-policy
    (spin_button :: <GtkSpinButton*>,
     policy :: <GtkSpinButtonUpdatePolicy>)
 => ();
  call-out("gtk_spin_button_set_update_policy", void:,
           ptr: spin_button.raw-value,
           int: policy);
  values();
end function;

define inline-only function gtk-spin-button-set-numeric
    (spin_button :: <GtkSpinButton*>,
     numeric :: <gboolean>)
 => ();
  call-out("gtk_spin_button_set_numeric", void:,
           ptr: spin_button.raw-value,
           int: numeric);
  values();
end function;

define inline-only function gtk-spin-button-spin
    (spin_button :: <GtkSpinButton*>,
     direction :: <GtkSpinType>,
     increment :: <gfloat>)
 => ();
  call-out("gtk_spin_button_spin", void:,
           ptr: spin_button.raw-value,
           int: direction,
           float: increment);
  values();
end function;

define inline-only function gtk-spin-button-set-wrap
    (spin_button :: <GtkSpinButton*>,
     wrap :: <gboolean>)
 => ();
  call-out("gtk_spin_button_set_wrap", void:,
           ptr: spin_button.raw-value,
           int: wrap);
  values();
end function;

define inline-only function gtk-spin-button-set-shadow-type
    (spin_button :: <GtkSpinButton*>,
     shadow_type :: <GtkShadowType>)
 => ();
  call-out("gtk_spin_button_set_shadow_type", void:,
           ptr: spin_button.raw-value,
           int: shadow_type);
  values();
end function;

define inline-only function gtk-spin-button-set-snap-to-ticks
    (spin_button :: <GtkSpinButton*>,
     snap_to_ticks :: <gboolean>)
 => ();
  call-out("gtk_spin_button_set_snap_to_ticks", void:,
           ptr: spin_button.raw-value,
           int: snap_to_ticks);
  values();
end function;

define inline-only function gtk-spin-button-update
    (spin_button :: <GtkSpinButton*>)
 => ();
  call-out("gtk_spin_button_update", void:,
           ptr: spin_button.raw-value);
  values();
end function;

define inline-only function gtk-text-new
    (hadj :: <GtkAdjustment*>,
     vadj :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_text_new", ptr:,
           ptr: hadj.raw-value,
           ptr: vadj.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-text-set-editable
    (text :: <GtkText*>,
     editable :: <gboolean>)
 => ();
  call-out("gtk_text_set_editable", void:,
           ptr: text.raw-value,
           int: editable);
  values();
end function;

define inline-only function gtk-text-set-word-wrap
    (text :: <GtkText*>,
     word_wrap :: <gint>)
 => ();
  call-out("gtk_text_set_word_wrap", void:,
           ptr: text.raw-value,
           int: word_wrap);
  values();
end function;

define inline-only function gtk-text-set-line-wrap
    (text :: <GtkText*>,
     line_wrap :: <gint>)
 => ();
  call-out("gtk_text_set_line_wrap", void:,
           ptr: text.raw-value,
           int: line_wrap);
  values();
end function;

define inline-only function gtk-text-set-adjustments
    (text :: <GtkText*>,
     hadj :: <GtkAdjustment*>,
     vadj :: <GtkAdjustment*>)
 => ();
  call-out("gtk_text_set_adjustments", void:,
           ptr: text.raw-value,
           ptr: hadj.raw-value,
           ptr: vadj.raw-value);
  values();
end function;

define inline-only function gtk-text-set-point
    (text :: <GtkText*>,
     index :: <guint>)
 => ();
  call-out("gtk_text_set_point", void:,
           ptr: text.raw-value,
           int: index);
  values();
end function;

define inline-only function gtk-text-get-point
    (text :: <GtkText*>)
 => (return :: <guint>);
  let return-value = call-out("gtk_text_get_point", int:,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-text-get-length
    (text :: <GtkText*>)
 => (return :: <guint>);
  let return-value = call-out("gtk_text_get_length", int:,
           ptr: text.raw-value);
  return-value;
end function;

define inline-only function gtk-text-freeze
    (text :: <GtkText*>)
 => ();
  call-out("gtk_text_freeze", void:,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-text-thaw
    (text :: <GtkText*>)
 => ();
  call-out("gtk_text_thaw", void:,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-text-insert
    (text :: <GtkText*>,
     font :: <GdkFont*>,
     fore :: <GdkColor*>,
     back :: <GdkColor*>,
     chars :: <gchar*>,
     length :: <gint>)
 => ();
  call-out("gtk_text_insert", void:,
           ptr: text.raw-value,
           ptr: font.raw-value,
           ptr: fore.raw-value,
           ptr: back.raw-value,
           ptr: chars.raw-value,
           int: length);
  values();
end function;

define inline-only function gtk-text-backward-delete
    (text :: <GtkText*>,
     nchars :: <guint>)
 => ();
  call-out("gtk_text_backward_delete", void:,
           ptr: text.raw-value,
           int: nchars);
  values();
end function;

define inline-only function gtk-text-forward-delete
    (text :: <GtkText*>,
     nchars :: <guint>)
 => ();
  call-out("gtk_text_forward_delete", void:,
           ptr: text.raw-value,
           int: nchars);
  values();
end function;

define inline-only function gtk-alignment-new
    (xalign :: <gfloat>,
     yalign :: <gfloat>,
     xscale :: <gfloat>,
     yscale :: <gfloat>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_alignment_new", ptr:,
           float: xalign,
           float: yalign,
           float: xscale,
           float: yscale);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-alignment-set
    (alignment :: <GtkAlignment*>,
     xalign :: <gfloat>,
     yalign :: <gfloat>,
     xscale :: <gfloat>,
     yscale :: <gfloat>)
 => ();
  call-out("gtk_alignment_set", void:,
           ptr: alignment.raw-value,
           float: xalign,
           float: yalign,
           float: xscale,
           float: yscale);
  values();
end function;

define inline-only function gtk-drawing-area-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_drawing_area_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-drawing-area-size
    (darea :: <GtkDrawingArea*>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gtk_drawing_area_size", void:,
           ptr: darea.raw-value,
           int: width,
           int: height);
  values();
end function;

define inline-only function gtk-curve-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_curve_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-curve-reset
    (curve :: <GtkCurve*>)
 => ();
  call-out("gtk_curve_reset", void:,
           ptr: curve.raw-value);
  values();
end function;

define inline-only function gtk-curve-set-gamma
    (curve :: <GtkCurve*>,
     gamma :: <gfloat>)
 => ();
  call-out("gtk_curve_set_gamma", void:,
           ptr: curve.raw-value,
           float: gamma);
  values();
end function;

define inline-only function gtk-curve-set-range
    (curve :: <GtkCurve*>,
     min_x :: <gfloat>,
     max_x :: <gfloat>,
     min_y :: <gfloat>,
     max_y :: <gfloat>)
 => ();
  call-out("gtk_curve_set_range", void:,
           ptr: curve.raw-value,
           float: min_x,
           float: max_x,
           float: min_y,
           float: max_y);
  values();
end function;

define inline-only function gtk-curve-set-vector
    (curve :: <GtkCurve*>,
     nvector :: <integer>,
     vector :: <gfloat*>)
 => ();
  call-out("gtk_curve_set_vector", void:,
           ptr: curve.raw-value,
           int: nvector,
           ptr: vector.raw-value);
  values();
end function;

define inline-only function gtk-curve-get-vector
    (curve :: <GtkCurve*>,
     nvector :: <integer>,
     vector :: <gfloat*>)
 => ();
  call-out("gtk_curve_get_vector", void:,
           ptr: curve.raw-value,
           int: nvector,
           ptr: vector.raw-value);
  values();
end function;

define inline-only function gtk-curve-set-curve-type
    (curve :: <GtkCurve*>,
     type :: <GtkCurveType>)
 => ();
  call-out("gtk_curve_set_curve_type", void:,
           ptr: curve.raw-value,
           int: type);
  values();
end function;

define inline-only function gtk-preview-new
    (type :: <GtkPreviewType>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_preview_new", ptr:,
           int: type);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-preview-size
    (preview :: <GtkPreview*>,
     width :: <gint>,
     height :: <gint>)
 => ();
  call-out("gtk_preview_size", void:,
           ptr: preview.raw-value,
           int: width,
           int: height);
  values();
end function;

define inline-only function gtk-preview-set-expand
    (preview :: <GtkPreview*>,
     expand :: <gboolean>)
 => ();
  call-out("gtk_preview_set_expand", void:,
           ptr: preview.raw-value,
           int: expand);
  values();
end function;

define inline-only function gtk-preview-set-color-cube
    (nred_shades :: <guint>,
     ngreen_shades :: <guint>,
     nblue_shades :: <guint>,
     ngray_shades :: <guint>)
 => ();
  call-out("gtk_preview_set_color_cube", void:,
           int: nred_shades,
           int: ngreen_shades,
           int: nblue_shades,
           int: ngray_shades);
  values();
end function;

define inline-only function gtk-preview-set-install-cmap
    (install_cmap :: <gboolean>)
 => ();
  call-out("gtk_preview_set_install_cmap", void:,
           int: install_cmap);
  values();
end function;

define inline-only function gtk-preview-set-reserved
    (nreserved :: <gint>)
 => ();
  call-out("gtk_preview_set_reserved", void:,
           int: nreserved);
  values();
end function;

define inline-only function gtk-preview-get-visual
    ()
 => (return :: <GdkVisual*>);
  let return-value = call-out("gtk_preview_get_visual", ptr:);
  make(<GdkVisual*>, pointer: return-value);
end function;

define inline-only function gtk-preview-get-cmap
    ()
 => (return :: <GdkColormap*>);
  let return-value = call-out("gtk_preview_get_cmap", ptr:);
  make(<GdkColormap*>, pointer: return-value);
end function;

define inline-only function gtk-file-selection-new
    (title :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_file_selection_new", ptr:,
           ptr: title.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-file-selection-set-filename
    (filesel :: <GtkFileSelection*>,
     filename :: <gchar*>)
 => ();
  call-out("gtk_file_selection_set_filename", void:,
           ptr: filesel.raw-value,
           ptr: filename.raw-value);
  values();
end function;

define inline-only function gtk-file-selection-get-filename
    (filesel :: <GtkFileSelection*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_file_selection_get_filename", ptr:,
           ptr: filesel.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-file-selection-show-fileop-buttons
    (filesel :: <GtkFileSelection*>)
 => ();
  call-out("gtk_file_selection_show_fileop_buttons", void:,
           ptr: filesel.raw-value);
  values();
end function;

define inline-only function gtk-file-selection-hide-fileop-buttons
    (filesel :: <GtkFileSelection*>)
 => ();
  call-out("gtk_file_selection_hide_fileop_buttons", void:,
           ptr: filesel.raw-value);
  values();
end function;

define inline-only function gtk-font-selection-dialog-new
    (title :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_font_selection_dialog_new", ptr:,
           ptr: title.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-font-selection-dialog-get-font-name
    (fontsel :: <GtkFontSelectionDialog*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_font_selection_dialog_get_font_name", ptr:,
           ptr: fontsel.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-font-selection-dialog-get-font
    (fontsel :: <GtkFontSelectionDialog*>)
 => (return :: <GdkFont*>);
  let return-value = call-out("gtk_font_selection_dialog_get_font", ptr:,
           ptr: fontsel.raw-value);
  make(<GdkFont*>, pointer: return-value);
end function;

define inline-only function gtk-font-selection-dialog-set-font-name
    (fontsel :: <GtkFontSelectionDialog*>,
     fontname :: <gchar*>)
 => (return :: <gboolean>);
  let return-value = call-out("gtk_font_selection_dialog_set_font_name", int:,
           ptr: fontsel.raw-value,
           ptr: fontname.raw-value);
  return-value;
end function;

define inline-only function gtk-font-selection-dialog-get-preview-text
    (fontsel :: <GtkFontSelectionDialog*>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_font_selection_dialog_get_preview_text", ptr:,
           ptr: fontsel.raw-value);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-font-selection-dialog-set-preview-text
    (fontsel :: <GtkFontSelectionDialog*>,
     text :: <gchar*>)
 => ();
  call-out("gtk_font_selection_dialog_set_preview_text", void:,
           ptr: fontsel.raw-value,
           ptr: text.raw-value);
  values();
end function;

define inline-only function gtk-color-selection-dialog-new
    (title :: <gchar*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_color_selection_dialog_new", ptr:,
           ptr: title.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-color-selection-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_color_selection_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-color-selection-set-update-policy
    (colorsel :: <GtkColorSelection*>,
     policy :: <GtkUpdateType>)
 => ();
  call-out("gtk_color_selection_set_update_policy", void:,
           ptr: colorsel.raw-value,
           int: policy);
  values();
end function;

define inline-only function gtk-color-selection-set-opacity
    (colorsel :: <GtkColorSelection*>,
     use_opacity :: <gboolean>)
 => ();
  call-out("gtk_color_selection_set_opacity", void:,
           ptr: colorsel.raw-value,
           int: use_opacity);
  values();
end function;

define inline-only function gtk-range-get-adjustment
    (range :: <GtkRange*>)
 => (return :: <GtkAdjustment*>);
  let return-value = call-out("gtk_range_get_adjustment", ptr:,
           ptr: range.raw-value);
  make(<GtkAdjustment*>, pointer: return-value);
end function;

define inline-only function gtk-range-set-update-policy
    (range :: <GtkRange*>,
     policy :: <GtkUpdateType>)
 => ();
  call-out("gtk_range_set_update_policy", void:,
           ptr: range.raw-value,
           int: policy);
  values();
end function;

define inline-only function gtk-range-set-adjustment
    (range :: <GtkRange*>,
     adjustment :: <GtkAdjustment*>)
 => ();
  call-out("gtk_range_set_adjustment", void:,
           ptr: range.raw-value,
           ptr: adjustment.raw-value);
  values();
end function;

define inline-only function gtk-scale-set-digits
    (scale :: <GtkScale*>,
     digits :: <guint>)
 => ();
  call-out("gtk_scale_set_digits", void:,
           ptr: scale.raw-value,
           int: digits);
  values();
end function;

define inline-only function gtk-scale-set-draw-value
    (scale :: <GtkScale*>,
     draw_value :: <gboolean>)
 => ();
  call-out("gtk_scale_set_draw_value", void:,
           ptr: scale.raw-value,
           int: draw_value);
  values();
end function;

define inline-only function gtk-scale-set-value-pos
    (scale :: <GtkScale*>,
     pos :: <GtkPositionType>)
 => ();
  call-out("gtk_scale_set_value_pos", void:,
           ptr: scale.raw-value,
           int: pos);
  values();
end function;

define inline-only function gtk-scale-value-width
    (scale :: <GtkScale*>)
 => (return :: <gint>);
  let return-value = call-out("gtk_scale_value_width", int:,
           ptr: scale.raw-value);
  return-value;
end function;

define inline-only function gtk-scale-draw-value
    (scale :: <GtkScale*>)
 => ();
  call-out("gtk_scale_draw_value", void:,
           ptr: scale.raw-value);
  values();
end function;

define inline-only function gtk-hscale-new
    (adjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hscale_new", ptr:,
           ptr: adjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-vscale-new
    (adjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vscale_new", ptr:,
           ptr: adjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-hscrollbar-new
    (adjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hscrollbar_new", ptr:,
           ptr: adjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-vscrollbar-new
    (adjustment :: <GtkAdjustment*>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vscrollbar_new", ptr:,
           ptr: adjustment.raw-value);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-ruler-set-metric
    (ruler :: <GtkRuler*>,
     metric :: <GtkMetricType>)
 => ();
  call-out("gtk_ruler_set_metric", void:,
           ptr: ruler.raw-value,
           int: metric);
  values();
end function;

define inline-only function gtk-ruler-set-range
    (ruler :: <GtkRuler*>,
     lower :: <gfloat>,
     upper :: <gfloat>,
     position :: <gfloat>,
     max_size :: <gfloat>)
 => ();
  call-out("gtk_ruler_set_range", void:,
           ptr: ruler.raw-value,
           float: lower,
           float: upper,
           float: position,
           float: max_size);
  values();
end function;

define inline-only function gtk-ruler-draw-ticks
    (ruler :: <GtkRuler*>)
 => ();
  call-out("gtk_ruler_draw_ticks", void:,
           ptr: ruler.raw-value);
  values();
end function;

define inline-only function gtk-ruler-draw-pos
    (ruler :: <GtkRuler*>)
 => ();
  call-out("gtk_ruler_draw_pos", void:,
           ptr: ruler.raw-value);
  values();
end function;

define inline-only function gtk-hruler-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hruler_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-vruler-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vruler_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-dialog-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_dialog_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-input-dialog-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_input_dialog_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-calendar-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_calendar_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-calendar-select-month
    (calendar :: <GtkCalendar*>,
     month :: <gint>,
     year :: <gint>)
 => (return :: <gint>);
  let return-value = call-out("gtk_calendar_select_month", int:,
           ptr: calendar.raw-value,
           int: month,
           int: year);
  return-value;
end function;

define inline-only function gtk-calendar-select-day
    (calendar :: <GtkCalendar*>,
     day :: <gint>)
 => ();
  call-out("gtk_calendar_select_day", void:,
           ptr: calendar.raw-value,
           int: day);
  values();
end function;

define inline-only function gtk-calendar-mark-day
    (calendar :: <GtkCalendar*>,
     day :: <gint>)
 => (return :: <gint>);
  let return-value = call-out("gtk_calendar_mark_day", int:,
           ptr: calendar.raw-value,
           int: day);
  return-value;
end function;

define inline-only function gtk-calendar-unmark-day
    (calendar :: <GtkCalendar*>,
     day :: <gint>)
 => (return :: <gint>);
  let return-value = call-out("gtk_calendar_unmark_day", int:,
           ptr: calendar.raw-value,
           int: day);
  return-value;
end function;

define inline-only function gtk-calendar-clear-marks
    (calendar :: <GtkCalendar*>)
 => ();
  call-out("gtk_calendar_clear_marks", void:,
           ptr: calendar.raw-value);
  values();
end function;

define inline-only function gtk-calendar-freeze
    (calendar :: <GtkCalendar*>)
 => ();
  call-out("gtk_calendar_freeze", void:,
           ptr: calendar.raw-value);
  values();
end function;

define inline-only function gtk-calendar-thaw
    (calendar :: <GtkCalendar*>)
 => ();
  call-out("gtk_calendar_thaw", void:,
           ptr: calendar.raw-value);
  values();
end function;

define inline-only function gtk-plug-new
    (socket_id :: <gint>)
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_plug_new", ptr:,
           int: socket_id);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-paned-add1
    (paned :: <GtkPaned*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_paned_add1", void:,
           ptr: paned.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-paned-add2
    (paned :: <GtkPaned*>,
     child :: <GtkWidget*>)
 => ();
  call-out("gtk_paned_add2", void:,
           ptr: paned.raw-value,
           ptr: child.raw-value);
  values();
end function;

define inline-only function gtk-paned-pack1
    (paned :: <GtkPaned*>,
     child :: <GtkWidget*>,
     resize :: <gboolean>,
     shrink :: <gboolean>)
 => ();
  call-out("gtk_paned_pack1", void:,
           ptr: paned.raw-value,
           ptr: child.raw-value,
           int: resize,
           int: shrink);
  values();
end function;

define inline-only function gtk-paned-pack2
    (paned :: <GtkPaned*>,
     child :: <GtkWidget*>,
     resize :: <gboolean>,
     shrink :: <gboolean>)
 => ();
  call-out("gtk_paned_pack2", void:,
           ptr: paned.raw-value,
           ptr: child.raw-value,
           int: resize,
           int: shrink);
  values();
end function;

define inline-only function gtk-paned-set-position
    (paned :: <GtkPaned*>,
     position :: <gint>)
 => ();
  call-out("gtk_paned_set_position", void:,
           ptr: paned.raw-value,
           int: position);
  values();
end function;

define inline-only function gtk-paned-handle-size
    (paned :: <GtkPaned*>,
     size :: <gint>)
 => ();
  call-out("gtk_paned_handle_size", void:,
           ptr: paned.raw-value,
           int: size);
  values();
end function;

define inline-only function gtk-paned-gutter-size
    (paned :: <GtkPaned*>,
     size :: <gint>)
 => ();
  call-out("gtk_paned_gutter_size", void:,
           ptr: paned.raw-value,
           int: size);
  values();
end function;

define inline-only function gtk-paned-compute-position
    (paned :: <GtkPaned*>,
     allocation :: <gint>,
     child1_req :: <gint>,
     child2_req :: <gint>)
 => ();
  call-out("gtk_paned_compute_position", void:,
           ptr: paned.raw-value,
           int: allocation,
           int: child1_req,
           int: child2_req);
  values();
end function;

define inline-only function gtk-hpaned-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_hpaned_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-vpaned-new
    ()
 => (return :: <GtkWidget*>);
  let return-value = call-out("gtk_vpaned_new", ptr:);
  make(<GtkWidget*>, pointer: return-value);
end function;

define inline-only function gtk-type-name
    (type :: <GtkType>)
 => (return :: <gchar*>);
  let return-value = call-out("gtk_type_name", ptr:,
           int: type);
  make(<gchar*>, pointer: return-value);
end function;

define inline-only function gtk-type-from-name
    (name :: <gchar*>)
 => (return :: <GtkType>);
  let return-value = call-out("gtk_type_from_name", int:,
           ptr: name.raw-value);
  return-value;
end function;

define inline-only function gtk-signal-emit-stop
    (object :: <GtkObject*>,
     id :: <gint>)
 => ();
  call-out("gtk_signal_emit_stop", void:,
           ptr: object.raw-value,
           int: id);
  values();
end function;

define inline-only function gtk-signal-emit-stop-by-name
    (object :: <GtkObject*>,
     name :: <gchar*>)
 => ();
  call-out("gtk_signal_emit_stop_by_name", void:,
           ptr: object.raw-value,
           ptr: name.raw-value);
  values();
end function;

define inline-only function gtk-signal-set-class-function-full
    (class :: <GtkType>,
     signal :: <gchar*>,
     function :: <GtkFunction>,
     marshall :: <GtkCallbackMarshal>,
     data :: <gpointer>,
     destroy :: <GtkDestroyNotify>)
 => ();
  call-out("gtk_signal_set_class_function_full", void:,
           int: class,
           ptr: signal.raw-value,
           ptr: function,
           ptr: marshall,
           ptr: data.raw-value,
           ptr: destroy);
  values();
end function;

define inline-only function gtk-accel-group-new
    ()
 => (return :: <GtkAccelGroup*>);
  let return-value = call-out("gtk_accel_group_new", ptr:);
  make(<GtkAccelGroup*>, pointer: return-value);
end function;

define inline-only function gtk-accel-group-attach
    (accel_group :: <GtkAccelGroup*>,
     object :: <GtkObject*>)
 => ();
  call-out("gtk_accel_group_attach", void:,
           ptr: accel_group.raw-value,
           ptr: object.raw-value);
  values();
end function;

define inline-only function gtk-accel-group-detach
    (accel_group :: <GtkAccelGroup*>,
     object :: <GtkObject*>)
 => ();
  call-out("gtk_accel_group_detach", void:,
           ptr: accel_group.raw-value,
           ptr: object.raw-value);
  values();
end function;

define inline-only function gtk-accel-group-lock
    (accel_group :: <GtkAccelGroup*>)
 => ();
  call-out("gtk_accel_group_lock", void:,
           ptr: accel_group.raw-value);
  values();
end function;

define inline-only function gtk-accel-group-unlock
    (accel_group :: <GtkAccelGroup*>)
 => ();
  call-out("gtk_accel_group_unlock", void:,
           ptr: accel_group.raw-value);
  values();
end function;

define inline-only function gtk-accel-group-add
    (accel_group :: <GtkAccelGroup*>,
     accel_key :: <guint>,
     accel_mods :: <GdkModifierType>,
     accel_flags :: <GtkAccelFlags>,
     object :: <GtkObject*>,
     accel_signal :: <gchar*>)
 => ();
  call-out("gtk_accel_group_add", void:,
           ptr: accel_group.raw-value,
           int: accel_key,
           int: accel_mods,
           int: accel_flags,
           ptr: object.raw-value,
           ptr: accel_signal.raw-value);
  values();
end function;

define inline-only function gtk-accel-group-remove
    (accel_group :: <GtkAccelGroup*>,
     accel_key :: <guint>,
     accel_mods :: <GdkModifierType>,
     object :: <GtkObject*>)
 => ();
  call-out("gtk_accel_group_remove", void:,
           ptr: accel_group.raw-value,
           int: accel_key,
           int: accel_mods,
           ptr: object.raw-value);
  values();
end function;

define inline-only function gtk-accelerator-parse
    (accelerator :: <gchar*>,
     accelerator_key :: <guint*>,
     accelerator_mods :: <GdkModifierType*>)
 => ();
  call-out("gtk_accelerator_parse", void:,
           ptr: accelerator.raw-value,
           ptr: accelerator_key.raw-value,
           ptr: accelerator_mods.raw-value);
  values();
end function;

define inline-only function gtk-selection-convert
    (widget :: <GtkWidget*>,
     selection :: <GdkAtom>,
     target :: <GdkAtom>,
     time :: <guint>)
 => (return :: <gint>);
  let return-value = call-out("gtk_selection_convert", int:,
           ptr: widget.raw-value,
           int: selection,
           int: target,
           int: time);
  return-value;
end function;

