/*
Gwenview - A simple image viewer for KDE
Copyright (C) 2000-2002 Aurlien Gteau

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef FILEDNDDETAILVIEW_H
#define FILEDNDDETAILVIEW_H

// KDE include files
#include <kfiledetailview.h>

// Our include files
#include "browsablefileview.h"


class FileDnDDetailView : public KFileDetailView, public BrowsableFileView {
public:
	FileDnDDetailView(QWidget *parent=0, const char *name=0);

// Browsable methods
	void selectFirst();
	void selectLast();
	void selectPrevious();
	void selectNext();
	
	QString previousItemText() const;
	QString currentItemText() const;
	QString nextItemText() const;

	bool currentIsFirst() const;
	bool currentIsLast() const;

protected:
	void startDrag();
	QListViewItem* lastChild() const;
};

#endif
