with Glib;             use Glib;
with Gdk.Drawable;     use Gdk.Drawable;
with Gdk.GC;           use Gdk.GC;
with Gtkada.Canvas;    use Gtkada.Canvas;
with Gtk.Widget;       use Gtk.Widget;
with Gdk.Color;        use Gdk.Color;
with Gdk.Font;         use Gdk.Font;
with Gtk.Extra.PsFont; use Gtk.Extra.PsFont;

with Ada.Text_IO;      use Ada.Text_IO;

package body Test_Display_Items is

   White_GC : Gdk.GC.Gdk_GC;
   Grey_GC  : Gdk.GC.Gdk_GC;
   Black_GC : Gdk.GC.Gdk_GC;
   Font     : Gdk.Font.Gdk_Font;

   Text : constant String := "1: My_Variable";

   -------------
   -- Gtk_New --
   -------------

   procedure Gtk_New
     (Item : out Display_Item;
      Win  : in Gdk.Window.Gdk_Window)
   is
   begin
      Item := new Display_Item_Record;
      Test_Display_Items.Initialize (Item, Win);
   end Gtk_New;

   ----------------
   -- Initialize --
   ----------------

   procedure Initialize
     (Item : access Display_Item_Record'Class;
      Win  : in Gdk.Window.Gdk_Window)
   is
      use type Gdk.GC.Gdk_GC;
      Height : Gint;
      Alloc_Width  : Gint;
      Alloc_Height : Gint;
      Grey  : Gdk_Color;
   begin
      if White_GC = null then
         Gdk_New (White_GC, Win);
         Set_Foreground (White_GC, White (Get_Default_Colormap));

         Grey := Parse ("grey");
         Alloc (Gtk.Widget.Get_Default_Colormap, Grey);

         Gdk_New (Grey_GC, Win);
         Set_Foreground (Grey_GC, Grey);

         Gdk_New (Black_GC, Win);
         Set_Foreground (Black_GC, Black (Gtk.Widget.Get_Default_Colormap));

         Font := Get_Gdkfont ("Helvetica-Bold", 8);
         if Font = Null_Font then
            null;  --  ??  Should use a default font
         end if;

      end if;

      Alloc_Width := String_Width (Font, Text) + 8;
      Height := String_Height (Font, Text) + 4;
      Alloc_Height := Height + Height * 3;

      Set_Screen_Size (Item, Alloc_Width, Alloc_Height);
   end Initialize;

   ----------
   -- Draw --
   ----------

   procedure Draw (Item : access Display_Item_Record;
                   Canvas : access Interactive_Canvas_Record'Class;
                   Dest : Gdk.Pixmap.Gdk_Pixmap;
                   Xdest, Ydest : Glib.Gint)
   is
      Height : Gint;
      Alloc_Width  : Gint := Gint (Get_Coord (Item).Width);
      Alloc_Height : Gint := Gint (Get_Coord (Item).Height);
   begin
      Height := String_Height (Font, Text) + 4;
      Draw_Rectangle (Dest,
                      GC     => White_GC,
                      Filled => True,
                      X      => Xdest,
                      Y      => Ydest + Height,
                      Width  => Alloc_Width - 1,
                      Height => Alloc_Height - Height - 1);

      Draw_Rectangle (Dest,
                      GC     => Grey_GC,
                      Filled => True,
                      X      => Xdest,
                      Y      => Ydest,
                      Width  => Alloc_Width - 1,
                      Height => Height);

      Draw_Rectangle (Dest,
                      GC     => Black_GC,
                      Filled => False,
                      X      => Xdest,
                      Y      => Ydest,
                      Width  => Alloc_Width - 1,
                      Height => Alloc_Height - 1);

      Draw_Line (Dest,
                 GC     => Black_GC,
                 X1     => Xdest,
                 Y1     => Ydest + Height,
                 X2     => Xdest + Alloc_Width - 1,
                 Y2     => Ydest + Height);

      Draw_Text (Dest,
                 Font   => Font,
                 GC     => Black_GC,
                 X      => Xdest + 4,
                 Y      => Ydest + Height - 4,
                 Text   => Text);
   end Draw;

   ---------------------
   -- On_Button_Click --
   ---------------------

   procedure On_Button_Click (Item   : access Display_Item_Record;
                              Button : Glib.Guint;
                              X, Y   : Glib.Gint)
   is
   begin
      Put_Line ("Was clicked on");
   end On_Button_Click;

end Test_Display_Items;

