// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Multi-threaded compression
// ****************************************************************************


#ifndef __THREADCOMPRESS_H__
#define __THREADCOMPRESS_H__

#include <QThread>   //lint !e537 Repeated include

#ifndef __DEVICE_H__
  #include "device.h"
#endif

class t_ThreadCompressLocal;

class t_ThreadCompress: public QThread
{
   Q_OBJECT

   public:
      t_ThreadCompress ();
      t_ThreadCompress (t_pDevice pDevice, int ThreadNr);
     ~t_ThreadCompress ();

   protected:
      void run (void);

   signals:
      void SignalEnded (t_pDevice pDevice, int ThreadNr);

   private slots:
      void SlotFinished (void);

   private:
      t_ThreadCompressLocal *pOwn;
};

typedef t_ThreadCompress *t_pThreadCompress;

// ------------------------------------
//             Error codes
// ------------------------------------

enum
{
   ERROR_THREADCOMPRESS_CONSTRUCTOR_NOT_SUPPORTED = ERROR_BASE_THREADCOMPRESS + 1,
   ERROR_THREADCOMPRESS_ZLIB_FAILED,
   ERROR_THREADCOMPRESS_LIBEWF_FAILED,
   ERROR_THREADCOMPRESS_COMPRESSION_BUFFER_TOO_SMALL,
   ERROR_THREADCOMPRESS_INVALID_FORMAT
};

#endif

