
// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Everything related to file names, extension names, paths...
// ****************************************************************************


#include "common.h"

#include <QtCore>

#include "libewf.h"

#include "device.h"
#include "config.h"
//#include "dlgwait.h"


const char *t_File::pExtensionInfo     = ".info";


APIRET t_File::Init (void)
{
   static bool Initialised=false;

   if (Initialised)
   {
      CHK_EXIT (ERROR_FILE_ONLY_CAN_BE_INSTANTIATED_ONCE)
   }
   else
   {
      CHK_EXIT (TOOL_ERROR_REGISTER_CODE (ERROR_FILE_ONLY_CAN_BE_INSTANTIATED_ONCE))
      CHK_EXIT (TOOL_ERROR_REGISTER_CODE (ERROR_FILE_INVALID_FORMAT))
      CHK_EXIT (TOOL_ERROR_REGISTER_CODE (ERROR_FILE_INVALID_EWF_FORMAT))
      Initialised = true;
   }
   return NO_ERROR;
}

APIRET t_File::GetFormatDescription (t_Format F, QString &Str)
{
   QString SubFormat;
   switch (F)
   {
      case DD:
         Str = QObject::tr("Linux dd raw image");
         break;
      case EWF:
         switch (CONFIG(EwfFormat))
         {
            case LIBEWF_FORMAT_ENCASE1: SubFormat="Encase1"; break;
            case LIBEWF_FORMAT_ENCASE2: SubFormat="Encase2"; break;
            case LIBEWF_FORMAT_ENCASE3: SubFormat="Encase3"; break;
            case LIBEWF_FORMAT_ENCASE4: SubFormat="Encase4"; break;
            case LIBEWF_FORMAT_ENCASE5: SubFormat="Encase5"; break;
            case LIBEWF_FORMAT_FTK    : SubFormat="FTK"    ; break;
            case LIBEWF_FORMAT_SMART  : SubFormat="Smart"  ; break;
            case LIBEWF_FORMAT_LVF    : SubFormat="LVF"    ; break;
            case LIBEWF_FORMAT_LINEN5 : SubFormat="Linen5" ; break;
            default                   : CHK (ERROR_FILE_INVALID_EWF_FORMAT)
         }
         Str = QObject::tr("Expert Witness Format, sub-format %1") .arg(SubFormat);
         break;
      case AFF:
         Str = QObject::tr("Advanced forensic image");
         break;
      default:  CHK (ERROR_FILE_INVALID_FORMAT)
   }
   return NO_ERROR;
}

APIRET t_File::GetFormatExtension (t_Format F, QString *pExtWildCards, QString *pExtHumanReadable)
{
   QString Wild, Human;

   switch (F)
   {
      case DD:
         Wild = ".dd";
         Human = Wild;
         break;
      case EWF:
         switch (CONFIG(EwfFormat))
         {
            case LIBEWF_FORMAT_ENCASE1:
            case LIBEWF_FORMAT_ENCASE2:
            case LIBEWF_FORMAT_ENCASE3:
            case LIBEWF_FORMAT_ENCASE4:
            case LIBEWF_FORMAT_ENCASE5:
            case LIBEWF_FORMAT_LINEN5 :
            case LIBEWF_FORMAT_FTK    : Wild=".E??"; Human=".Exx"; break;
            case LIBEWF_FORMAT_SMART  : Wild=".s??"; Human=".sxx"; break;
            case LIBEWF_FORMAT_LVF    : Wild=".l??"; Human=".lxx"; break;
            default                   : CHK (ERROR_FILE_INVALID_EWF_FORMAT)
         }
         break;
      case AFF:
         Wild = ".aff";
         Human = Wild;
         break;
      default:  CHK (ERROR_FILE_INVALID_FORMAT)
   }

   if (pExtWildCards    ) *pExtWildCards     = Wild;
   if (pExtHumanReadable) *pExtHumanReadable = Human;

   return NO_ERROR;
}

