// ****************************************************************************
//  Project:        GUYMAGER
// ****************************************************************************
//  Programmer:     Guy Voncken
//                  Police Grand-Ducale
//                  Service de Police Judiciaire
//                  Section Nouvelles Technologies
// ****************************************************************************
//  Module:         Error handling utilities
// ****************************************************************************

#ifndef __ERROR_H__
#define __ERROR_H__

// -----------------------
//       Exit codes
// -----------------------

static const int EXIT_NO_ERROR        = 0;
static const int EXIT_INTERNAL_ERROR  = 1;
static const int EXIT_QT_FATAL        = 2;
static const int EXIT_SIGNAL_RECEIVED = 3;

// -----------------------
//      Prototypes
// -----------------------

void ErrorExit (int ExitCode = EXIT_INTERNAL_ERROR);
void ErrorPopupExit (const char *pFileName, const char *pFunctionName, int LineNr, APIRET ec, const char *pMsg);

APIRET ErrorInit   (void);
APIRET ErrorDeInit (void);

// -----------------------
//  Error handling macros
// -----------------------


#define CHK_QT(Func)                                              \
   {                                                              \
      if (Func == 0)                                              \
      {                                                           \
         (void)ToolErrorCheck (__FFL__, ERROR_QT_UNSUCCESSFUL);   \
         return ERROR_QT_UNSUCCESSFUL;                            \
      }                                                           \
   }


#define CHK_QT_POPUP(Func)                                        \
   {                                                              \
      if (Func == 0)                                              \
         ErrorPopupExit (__FFL__, ERROR_QT_UNSUCCESSFUL, "Qt returned FALSE");  \
   }


#define CHK_QT_EXIT(Func)                                         \
   {                                                              \
      if (Func == 0)                                              \
      {                                                           \
         (void)ToolErrorCheck (__FFL__, ERROR_QT_UNSUCCESSFUL);   \
         exit (EXIT_QT_FATAL);                                    \
      }                                                           \
   }



#define CHK_EXIT(Func)                        \
   {                                          \
      APIRET ec;                              \
      /*lint -save -e506 -e774 -e1551*/       \
      if ((ec = Func) != NO_ERROR)            \
      {                                       \
         (void)ToolErrorCheck (__FFL__, ec);  \
         ErrorExit ();                        \
      }                                       \
      /*lint -restore */                      \
   }


#define CHK_EXIT_POPUP_MSG(Func,pMsg)         \
/*lint -save -e506 -e774*/   /*Warning 506: Constant value Boolean; Info 774: Boolean within 'if' always evaluates to True */ \
   {                                          \
      APIRET ec;                              \
      if ((ec = Func) != NO_ERROR)            \
         ErrorPopupExit (__FFL__, ec, pMsg);  \
   }                                          \
/*lint -restore*/


#define CHK_EXIT_POPUP(Func)                  \
   CHK_POPUP_MSG(Func,NULL)                   \


#define CHK_EXIT_POPUP_CONST(ec)              \
      ErrorPopupExit (__FFL__, ec, NULL);



#endif
