/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  GThumb
 *
 *  Copyright (C) 2001 The Free Software Foundation, Inc.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Street #330, Boston, MA 02111-1307, USA.
 */

#ifndef MENU_H
#define MENU_H

/* Definition of the File menu */

#include <config.h>
#include "dlg-open-with.h"
#include "dlg-comment.h"
#include "dlg-search.h"
#include "menu-callbacks.h"
#include "popup-menu-callbacks.h"
#include "print-callbacks.h"
#include "icons/flip.xpm"
#include "icons/mirror.xpm"
#include "icons/rotate.xpm"


GnomeUIInfo file_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_New Window"), N_("Create a new window"), 
	  new_window_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_NEW,
	  'n', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Open with..."), N_("Open selected files with an application"), 
	  open_with_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  'o', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SEPARATOR,

#ifdef HAVE_PRINT
	{ GNOME_APP_UI_ITEM,
	  N_("_Print Image..."), N_("Print the current image"),
	  print_image_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PRINT,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,
#endif

	{ GNOME_APP_UI_ITEM, 
	  N_("_Close"), N_("Close this window"), 
	  close_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 
	  'c', GDK_CONTROL_MASK, NULL },
	
	{ GNOME_APP_UI_ITEM, 
	  N_("E_xit"), N_("Close all windows and exit"), 
	  quit_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_EXIT, 
	  'q', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo alter_image_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Rotate Clockwise"), N_("Rotate the image clockwise"), 
	  rotate_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, rotate_xpm,
	  'r', GDK_SHIFT_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Rotate 180 _Degrees"), N_("Rotate the image 180 degrees"), 
	  rotate_180_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Flip"), N_("Flip the image"), 
	  flip_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, flip_xpm,
	  'f', GDK_SHIFT_MASK, NULL },
	
	{ GNOME_APP_UI_ITEM, 
	  N_("_Mirror"), N_("Mirror the image"), 
	  mirror_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_DATA, mirror_xpm,
	  'm', GDK_SHIFT_MASK, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo edit_catalog_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Rename Catalog..."), N_("Rename selected catalog"), 
	  rename_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Catalog..."), N_("Delete selected catalog"), 
	  delete_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Move Catalog To..."), N_("Move selected catalog to another location"), 
	  move_to_catalog_dir_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Edit Search..."), " ",
	  dlg_catalog_edit_search, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Redo _Search"), " ",
	  dlg_catalog_search, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH, 
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo edit_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Rename File..."), N_("Rename selected file"), 
	  rename_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  GDK_F2, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Files..."), N_("Delete selected files from disk"), 
	  delete_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Copy Files To..."), N_("Copy selected files to another location"), 
	  copy_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Move Files To..."), N_("Move selected files to another location"), 
	  move_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SUBTREE (N_("Edit Catalog"), edit_catalog_menu),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Select All Files"), N_("Select all the files in the current list"), 
	  select_all_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'a', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_SUBTREE (N_("A_lter Image"), alter_image_menu),

	{ GNOME_APP_UI_ITEM, 
	  N_("_Edit Comment..."), N_("Add a comment to selected images"), 
	  dlg_edit_comment, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Comment"), N_("Delete comments from selected images"),
	  delete_comment_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Add to Catalog..."), N_("Add selected files to a catalog"), 
	  add_to_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_BLUE, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("R_emove from Catalog"), N_("Remove selected files from the catalog"), 
	  remove_from_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo sort_by_radio_list[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("by _Name"), N_("Sort file list by name"), 
	  sort_by_name_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	
	{ GNOME_APP_UI_ITEM, 
	  N_("by _Path"), N_("Sort file list by path"), 
	  sort_by_path_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	
	{ GNOME_APP_UI_ITEM, 
	  N_("by _Size"), N_("Sort file list by file size"), 
	  sort_by_size_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	
	{ GNOME_APP_UI_ITEM, 
	  N_("by _Time"), N_("Sort file list by creation time"), 
	  sort_by_time_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo sort_menu[] = {
	GNOMEUIINFO_RADIOLIST (sort_by_radio_list),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("_Reversed Order"), N_("Reverse the list order"), 
	  reversed_order_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },
	
	GNOMEUIINFO_END
};


GnomeUIInfo trans_type_radio_list[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_White"), " ", 
	  trans_white_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Gray"), " ", 
	  trans_gray_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Black"), " ", 
	  trans_black_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Checked"), " ", 
	  trans_checked_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo trans_type_menu[] = {
	GNOMEUIINFO_RADIOLIST (trans_type_radio_list),

	GNOMEUIINFO_END
};


GnomeUIInfo zoom_quality_radio_list[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("High Quality"), " ", 
	  high_quality_zoom_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Low Quality"), " ", 
	  low_quality_zoom_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo zoom_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("Zoom In"), " ", 
	  zoom_in_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  '+', 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Zoom Out"), " ", 
	  zoom_out_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  '-', 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Actual Size"), " ", 
	  no_zoom_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  '1', 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Zoom to Fit"), N_("Zoom to fit window"), 
	  zoom_to_fit_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'x', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_RADIOLIST (zoom_quality_radio_list),

	GNOMEUIINFO_END
};


GnomeUIInfo view_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Refresh"), N_("Reload the current location"), 
	  refresh_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH, 
	  'r', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SUBTREE (N_("S_ort File List"), sort_menu),

	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("_Thumbnails"), N_("View thumbnails"), 
	  thumbnails_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  't', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("Start/Stop _Animation"), N_("Start or stop current animation"), 
	  toggle_animation_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'g', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Step Animation"), N_("View next animation frame"), 
	  step_animation_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'j', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SUBTREE (N_("Transparency T_ype"), trans_type_menu),

	GNOMEUIINFO_SUBTREE (N_("_Zoom"), zoom_menu),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Full Screen"), N_("View image in fullscreen mode"), 
	  fullscreen_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'v', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("_Browser"), N_("View/Hide the image browser"), 
	  browser_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  'w', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Show/Hide _Directories"), N_("View the directories browser"), 
	  dir_browser_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  '1', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Show/Hide _Catalogs"), N_("View the catalogs browser"), 
	  catalog_browser_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, NULL,
	  '2', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo go_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("Go _Home"), " ", 
	  go_home_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_HOME,
	  'h', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Go _Up One Level"), " ", 
	  go_up_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'u', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Go to Container Directory"), " ",
	  go_to_container_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete History"), N_("Delete the current history list"), 
	  delete_history_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_END
};


GnomeUIInfo wallpaper_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Centered"), N_("Set the image as desktop background (centered)"),
	  set_as_wallpaper_centered_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Tiled"), N_("Set the image as desktop background (tiled)"), 
	  set_as_wallpaper_tiled_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Scaled"), N_("Set the image as desktop background (scaled)"),
	  set_as_wallpaper_scaled_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("S_tretched"), N_("Set the image as desktop background (stretched)"), 
	  set_as_wallpaper_stretched_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Restore"), N_("Restore the original desktop wallpaper"),
	  restore_wallpaper_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },
	
	GNOMEUIINFO_END
};


GnomeUIInfo tools_menu[] = {
	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("_Slideshow"), N_("View the current file list as a slideshow"), 
	  slideshow_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  's', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_SUBTREE (N_("Set Image as _Wallpaper"), wallpaper_menu),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Find images..."), " ", 
	  dlg_search, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SEARCH,
	  'f', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Sa_ve Selection as Image..."), " ",
	  export_as_image_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_SAVE_AS,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Remove Old Thumbnails"), N_("Remove old thumbnails from the cache"), 
	  remove_old_thumbnails_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Remove Old Comments"), N_("Remove old comments from the cache"), 
	  remove_old_comments_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Preferences..."), N_("Edit various preferences"), 
	  preferences_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PREF,
	  'p', GDK_CONTROL_MASK, NULL },

	GNOMEUIINFO_END
};


/* Definition of the Help menu */

GnomeUIInfo help_menu[] = {
	GNOMEUIINFO_HELP("gthumb"),

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_About..."), N_("Information about the program"), 
	  about_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_ABOUT, 
	  0, 0, NULL },
	
	GNOMEUIINFO_END
};


GnomeUIInfo bookmarks_menu[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Add Bookmark"), N_("Add current location to bookmarks"), 
	  add_bookmark_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  'b', GDK_CONTROL_MASK, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Edit Bookmarks..."), N_("Edit bookmarks list"), 
	  edit_bookmarks_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	GNOMEUIINFO_END
};


/* Definition of the main menu */

GnomeUIInfo main_menu[] = {
	GNOMEUIINFO_MENU_FILE_TREE (file_menu),
	GNOMEUIINFO_MENU_EDIT_TREE (edit_menu),
	GNOMEUIINFO_MENU_VIEW_TREE (view_menu),
	GNOMEUIINFO_SUBTREE (N_("_Go"), go_menu),
	GNOMEUIINFO_SUBTREE (N_("_Bookmarks"), bookmarks_menu),
	GNOMEUIINFO_SUBTREE (N_("_Tools"), tools_menu),
	GNOMEUIINFO_MENU_HELP_TREE (help_menu),
	GNOMEUIINFO_END
};



/* popup menus. */

GnomeUIInfo file_popup_menu_data[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Open with..."), N_("Open selected files with an application"), 
	  open_with_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Rename File..."), " ", 
	  rename_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Files..."), " ", 
	  delete_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Copy Files To..."), " ", 
	  copy_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Move Files To..."), " ", 
	  move_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Edit Comment..."), N_("Add a comment to selected images"), 
	  dlg_edit_comment, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_PROP, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Comment"), N_("Delete comments from selected images"),
	  delete_comment_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Add to Catalog..."), " ", 
	  add_to_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_BOOK_BLUE, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("R_emove from Catalog"), " ", 
	  remove_from_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_CLOSE, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Go to Container Directory"), " ",
	  go_to_container_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_JUMP_TO,
	  0, 0, NULL },
	
	GNOMEUIINFO_END
};


GnomeUIInfo catalog_popup_menu_data[] = {
	{ GNOME_APP_UI_ITEM, 
	  N_("_Rename Catalog..."), " ", 
	  rename_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Catalog..."), " ", 
	  delete_catalog_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH, 
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Move Catalog To..."), " ", 
	  move_to_catalog_dir_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Edit Search..."), " ",
	  dlg_catalog_edit_search, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("Redo _Search"), " ",
	  dlg_catalog_search, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_REFRESH, 
	  0, 0, NULL },

	GNOMEUIINFO_END
};


GnomeUIInfo image_popup_menu_data[] = {
	{ GNOME_APP_UI_ITEM,
	  N_("Zoom In"), " ",
	  zoom_in_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Zoom Out"), " ",
	  zoom_out_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Actual Size"), " ",
	  no_zoom_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM,
	  N_("Zoom to Fit"), " ",
	  zoom_to_fit_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_TOGGLEITEM, 
	  N_("Full Screen"), " ", 
	  fullscreen_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Open with..."), N_("Open selected files with an application"), 
	  open_with_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_OPEN,
	  0, 0, NULL },

	GNOMEUIINFO_SEPARATOR,

	{ GNOME_APP_UI_ITEM, 
	  N_("_Rename File..."), " ", 
	  rename_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Delete Files..."), " ", 
	  delete_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_STOCK, GNOME_STOCK_MENU_TRASH,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Copy Files To..."), " ", 
	  copy_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	{ GNOME_APP_UI_ITEM, 
	  N_("_Move Files To..."), " ", 
	  move_cb, NULL, NULL,
	  GNOME_APP_PIXMAP_NONE, 0,
	  0, 0, NULL },

	GNOMEUIINFO_END
};
#endif /* MENU_H */
