/* interface.h --- interface definitions */

/* Copyright (c) E. Lassauge, 2000-2001.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted,
 * provided that the above copyright notice appear in all copies and that
 * both that copyright notice and this permission notice appear in
 * supporting documentation.
 *
 * This file is provided AS IS with no warranties of any kind.  The author
 * shall have no liability with respect to the infringement of copyrights,
 * trade secrets or any patents by this file or any part thereof.  In no
 * event will the author be liable for any lost revenue or profits or
 * other special, indirect and consequential damages.
 *
 * mailto:lassauge@mail.dotcom.fr
 * http://lassauge.free.fr/
 *
 * REVISION HISTORY: see Changelog
 *
 */

#ifndef _INTERFACE_H
#define _INTERFACE_H

/* Convenient defines */
#define ALIAS_CLIST_COLS	2
#define KEY_COL			0
#define VAL_COL			1

#define SCRIPT_CLIST_COLS	3
#define SCRIPT_COL		0
#define SHOW_COL		1
#define SAVE_COL		2
#define SHOWN_PROVIDER	1
#define SAVED_PROVIDER	2
#define IS_SAVED(flag)	((flag & SAVED_PROVIDER) == SAVED_PROVIDER)
#define IS_SHOWN(flag)	((flag & SHOWN_PROVIDER) == SHOWN_PROVIDER)

/* Common widgets */
extern GtkWidget   *About;
extern GtkWidget   *Scripts_fs;
extern GtkWidget   *Preference;
extern GtkWidget   *Alias;
extern GtkWidget   *Scripts;
extern GtkWidget   *GnomeSmssend;
extern GtkWidget   *Notebook;
extern GtkWidget   *Appbar;
extern GtkTooltips *Tooltips;
extern gint	    NumProvider;

/* creation functions */
GtkWidget *create_message(void);
GtkWidget *create_about(void);
GtkWidget *create_scripts_file_selection(void);
GtkWidget *create_preferences(void);
GtkWidget *create_aliases(void);
GtkWidget *create_scripts(void);
GtkWidget *create_gnome_smssend(void);

extern PProvider_t create_provider(const char filename[]);
extern void show_provider(gchar *filename,PProvider_t Pv);
extern void create_notebook(void);

#endif
