/*
 * Groach default 'theme' header
 * Provides default callback routines for 'theme'.
 * I'm trying to emulate xroach-1.5's motion.
 *
 * Copyright INOUE Seiichiro <inoue@ainet.or.jp>, licensed under the GPL.
 */
#ifndef __GRO_THEME_DEFAULT_H__
#define __GRO_THEME_DEFAULT_H__

/** Library private **/
#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

/* Constant numbers */
/* Number of GroMove stats */
#define DEFAULT_NUM_GSTAT	2	/* GRO_STAT_WAKE and GRO_STAT_SQUISH */
/* Number of directions */
#define DEFAULT_NUM_DIRECT	16
/* Pixmap sizes */
#define DEFAULT_PIX_WIDTH	48	
#define DEFAULT_PIX_HEIGHT	48	
/* Number of step pixels */
#define DEFAULT_STEP_PIXEL	12


/* Global function declarations */
/* GroThemeMoveInit */
extern gint move_init(const GroController *controller, GroMove *gmove);

/* GroThemeMoveCompute */
extern GroMoveRet move_compute(const GroController *controller, GroMove *gmove, const GdkRegion *vis_region, GroVector *ret_vec);

/* GroThemeMoveFinalize */
extern gint move_finalize(const GroController *controller, GroMove *gmove);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __GRO_THEME_DEFAULT_H__ */
