/*
    GQ -- a GTK-based LDAP client
    Copyright (C) 1998-2003 Bert Vermeulen
    Copyright (C) 2002-2003 by Peter Stamfest and Bert Vermeulen

    This program is released under the Gnu General Public License with
    the additional exemption that compiling, linking, and/or using
    OpenSSL is allowed.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* $Id: dt_int.h,v 1.2 2003/11/02 07:20:43 stamfest Exp $ */

#ifndef DT_INT_H_INCLUDED
#define DT_INT_H_INCLUDED

#include "formfill.h"
#include "syntax.h"

#include "dt_entry.h"
#include "i18n.h"

typedef dt_entry_handler dt_int_handler;
#define DT_INT(objpointer) ((dt_int_handler*)(objpointer))

display_type_handler *dt_int_get_handler();

/* Methods, only to be used by subclasses */
GtkWidget *dt_int_get_widget(int error_context,
			     struct formfill *form, GByteArray *data,
			     GtkSignalFunc *activatefunc,
			     gpointer funcdata);
GByteArray *dt_int_get_data(struct formfill *form, GtkWidget *widget);
void dt_int_set_data(struct formfill *form, GByteArray *data,
		     GtkWidget *widget);

GtkWidget *dt_int_retrieve_inputbox(GtkWidget *hbox);

#endif

/* 
   Local Variables:
   c-basic-offset: 5
   End:
 */
