/* -*- Mode: C; indent-tabs-mode: nil; c-basic-offset: 4 c-style: "K&R" -*- */

/*----------------------------------------------------------------------
 
  gpiv - Graphic program for Particle Image Velocimetry, based on gtk/gnome
         libraries.

   Copyright (C) 2002 Gerber van der Graaf

   This file is part of gpiv.

   Gpiv is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

----------------------------------------------------------------------*/

/*
 * widgets prototypes of display
 * $Log: display_interface.h,v $
 * Revision 1.7  2006/01/31 14:28:12  gerber
 * version 0.3.0
 *
 * Revision 1.5  2004/06/14 21:19:23  gerber
 * Image depth up to 16 bits.
 * Improvement "single int" and "drag int" in Eval tab.
 * Viewer's pop-up menu.
 * Adaption for gpiv_matrix_* and gpiv_vector_*.
 * Resizing console.
 * See Changelog for further info.
 *
 * Revision 1.4  2003/09/01 11:17:14  gerber
 * improved monitoring of interrogation process
 *
 * Revision 1.3  2003/07/31 11:43:26  gerber
 * display images in gnome canvas (HOERAreset)
 *
 * Revision 1.2  2003/06/27 13:47:26  gerber
 * display ruler, line/point evaluation
 *
 * Revision 1.1.1.1  2003/06/17 17:10:52  gerber
 * Imported gpiv
 *
 */

#ifndef DISPLAY_INTERFACE_H
#define DISPLAY_INTERFACE_H

#include "console_interface.h"


typedef struct _Image Image;
struct _Image {
    GtkWidget *img_display1;
    GtkWidget *img_display2;
    GpivImagePar image_par;
    guint16 **img1;
    guint16 **img2;
/*
 * Image is displayed at gnome canvas
 */
    GdkPixbuf *pixbuf1;
    GdkPixbuf *pixbuf2;
    guchar *rgbbuf_img1;
    guchar *rgbbuf_img2;
    gint rgb_img_width;
    float img_mean;
    GnomeCanvasItem *gci_img1;
    GnomeCanvasItem *gci_img2;
    gboolean exist_img;

};

typedef struct _Intreg Intreg;
struct _Intreg {
    gint row_start_old;
    gint row_start;
    gint row_end;
    gint col_start_old;
    gint col_start;
    gint col_end;
    gint int_size_1;
    gint int_size_2;
    gint int_shift;
    gint pre_shift_row;
    gint pre_shift_col;
    GpivPivData data;
    gboolean exist_int;
    GnomeCanvasItem *gci_intreg1[MAX_DATA][MAX_DATA];
    GnomeCanvasItem *gci_intreg2[MAX_DATA][MAX_DATA];
};


typedef struct _GpivData GpivData;
struct _GpivData {
    GpivEvalPar piv_eval_par;
    GpivPivData piv_data;
    GpivPivData piv_data_scaled;
    gboolean exist_piv;
    gboolean saved_piv;
    gboolean scaled_piv;
    gboolean averaged_piv;
 
    GnomeCanvasItem *gci_vector[MAX_DATA][MAX_DATA];
    gboolean exist_vec;

    Covariance cov/* [MAX_DATA][MAX_DATA] */;
    gboolean exist_cov;

/*     float **intreg1[MAX_DATA][MAX_DATA]; */
/*     float **intreg2[MAX_DATA][MAX_DATA]; */
    float **intreg1;
    float **intreg2;

    GpivValidPar piv_valid_par;
    gboolean exist_valid;
    GpivBinData klass;
    gboolean exist_histo;
    gboolean saved_histo;

    GpivPostPar piv_post_par;
    GpivScalarData vor_data;
    GpivScalarData vor_data_scaled;
    gboolean exist_vor;
    gboolean exist_vor_scaled;
    gboolean saved_vor;
    GnomeCanvasItem *gci_scalar_vor[MAX_DATA][MAX_DATA];

    GpivScalarData sstrain_data;
    GpivScalarData sstrain_data_scaled;
    gboolean exist_sstrain;
    gboolean exist_sstrain_scaled;
    gboolean saved_sstrain;
    GnomeCanvasItem *gci_scalar_sstrain[MAX_DATA][MAX_DATA];

    GpivScalarData nstrain_data;
    GpivScalarData nstrain_data_scaled;
    gboolean exist_nstrain;
    gboolean exist_nstrain_scaled;
    gboolean saved_nstrain;
    GnomeCanvasItem *gci_scalar_nstrain[MAX_DATA][MAX_DATA];

};

typedef struct _Display Display;
struct _Display {
    char fname_base[GPIV_MAX_CHARS];
    gint id;

    GtkWidget *mwin;                   /* main window for display */
    GtkWidget *vbox;
    GtkWidget *table;
    GtkWidget *button_origin;
    GtkWidget *arrow_origin;
    GtkWidget *hruler;
    GtkWidget *vruler;
    GtkWidget *scrolledwindow;
    GtkObject *scrolledwindow_hadj;
    GtkObject *scrolledwindow_vadj;
    GtkWidget *canvas;
    GtkWidget *view_options;
    GtkWidget *appbar;
    GtkWidget *nav_ebox;

    gboolean stretch_window_tmp;
    gint zoom_index;
    gfloat zoom_factor_old;
    gfloat zoom_factor;
    gint vector_scale;
    gint vector_color;
    gchar msg_display_default[GPIV_MAX_CHARS];

    GtkWidget *display_menu;
    GnomeCanvasItem *gci_bg;


    Image img;
    Intreg  intreg;
    GpivData gpd;

    gboolean display_img1;
    gboolean display_img2;
    gboolean display_intregs;
    gboolean display_piv;
    gboolean display_vor;
    gboolean display_sstrain;
    gboolean display_nstrain;

    gboolean index_old;
    gint index_x_old;
    gint index_y_old;
    gint xgrab_first;
    gint ygrab_first;

};


Display *
create_display (gchar *fname, 
                gint buf, 
                GpivConsole * gpiv);

/*
 * widget for display menu
 */
GtkWidget 
*create_display_menu (Display * disp);


/*
 * OBSOLETE
 */
/*
 * widgets for create_img_display
 */
/* GtkWidget *create_img_display (gchar *fname,  */
/*                                GpivImagePar image_par); */
/* GtkWidget *img_display_window; */
/* GtkWidget *darea; */


#endif /*  DISPLAY_INTERFACE_H */
