indexing

	description:

		"Eiffel tokens"

	library:    "Gobo Eiffel Tools Library"
	author:     "Eric Bezault <ericb@gobosoft.com>"
	copyright:  "Copyright (c) 1999, Eric Bezault and others"
	license:    "Eiffel Forum Freeware License v1 (see forum.txt)"
	date:       "$Date: 2000/02/02 10:57:23 $"
	revision:   "$Revision: 1.1 $"

class ET_TOKEN

creation

	make

feature {NONE} -- Initialization

	make (a_text: like text; a_position: like position) is
			-- Create a new token.
		require
			a_text_not_void: a_text /= Void
			a_position_not_void: a_position /= Void
		do
			text := a_text
			position := a_position
		ensure
			text_set: text = a_text
			position_set: position = a_position
		end

feature -- Access

	text: STRING
			-- Text of token

	position: ET_POSITION
			-- Position in source code

invariant

	text_not_void: text /= Void
	position_not_void: position /= Void

end -- class ET_TOKEN
