indexing

	description: "Parser token codes"
	generator: "geyacc version 2.0"

class ET_LACE_TOKENS

inherit

	YY_PARSER_TOKENS

feature -- Access

	token_name (a_token: INTEGER): STRING is
			-- Name of token `a_token'
		do
			inspect a_token
			when 0 then
				Result := "EOF token"
			when -1 then
				Result := "Error token"
			when L_SYSTEM then
				Result := "L_SYSTEM"
			when L_ROOT then
				Result := "L_ROOT"
			when L_END then
				Result := "L_END"
			when L_CLUSTER then
				Result := "L_CLUSTER"
			when L_DEFAULT then
				Result := "L_DEFAULT"
			when L_EXTERNAL then
				Result := "L_EXTERNAL"
			when L_OPTION then
				Result := "L_OPTION"
			when L_ABSTRACT then
				Result := "L_ABSTRACT"
			when L_ALL then
				Result := "L_ALL"
			when L_EXCLUDE then
				Result := "L_EXCLUDE"
			when L_IDENTIFIER then
				Result := "L_IDENTIFIER"
			when L_STRING then
				Result := "L_STRING"
			when L_STRERR then
				Result := "L_STRERR"
			else
				Result := yy_character_token_name (a_token)
			end
		end

feature -- Token codes

	L_SYSTEM: INTEGER is 258
	L_ROOT: INTEGER is 259
	L_END: INTEGER is 260
	L_CLUSTER: INTEGER is 261
	L_DEFAULT: INTEGER is 262
	L_EXTERNAL: INTEGER is 263
	L_OPTION: INTEGER is 264
	L_ABSTRACT: INTEGER is 265
	L_ALL: INTEGER is 266
	L_EXCLUDE: INTEGER is 267
	L_IDENTIFIER: INTEGER is 268
	L_STRING: INTEGER is 269
	L_STRERR: INTEGER is 270

end -- class ET_LACE_TOKENS
