/* Josh Pieper, (c) 2000 */

/* This file is distruted under the GPL, see file COPYING for details */

#ifndef GNUT_THREADS_H
#define GNUT_THREADS_H

/* 0.4.28.c17 */
#include "sh_sys_types.h"

#include <netinet/in.h>
#include <sys/socket.h>

#include "td.h"

#include "connection.h"
#include "lib.h"
#include "protocol.h"
#include "qry.h"
#include "share.h"
#include "transfer.h"

typedef struct _incoming_arg incoming_arg;

struct _incoming_arg {
  int s;
  struct sockaddr_in sin;
};

typedef struct {
  share_item *si;
  uchar ip[4];
  uchar port_le[2];
} push_arg;

typedef struct bad_ip {
  uint32 ip;
  time_t when;
} bad_ip;

#ifdef __cplusplus
extern "C" {
#endif

  extern int gh_did_receive;
  extern int num_uploads;

  void fre_bip(bad_ip **x, int bugnum);
  void fre_gs(GnutSearch **x, int bugnum);
  void fre_ia(incoming_arg **x, int bugnum);
  void fre_pa(push_arg **x, int bugnum);

  GnutSearch *gnut_search_add(char *guid, char *query);
  void        gnut_search_remove(GnutSearch *s);
  void        gnut_search_foreach(void (*cb)(GnutSearch *search,
					     void       *data),
				  void  *data);
  GnutSearch *gnut_search_find(char (*cb)(GnutSearch *search,
					  void       *data),
			       void  *data);
  GnutSearch *gnut_search_find_by_guid(char *guid);
  GnutSearch *gnut_search_find_by_query(char *query);
  int         gnut_search_count();

  int gnut_threads_num_incoming();
  int gnut_threads_num_outgoing();
  int gnut_threads_num_uploads();
  int gnut_threads_count_downloads();
  int gnut_threads_count_uploads();
  int gnut_threads_num_downloads();

  void *gnut_threads_outgoing(void *arg);
  void *gnut_threads_incoming(void *arg);

  int gtdh_1(gnut_transfer *a_gt, int startp, int overlap,
	     char **overlap_buf, query_resp *a_qrp1, int *rtr_en1,
	     int *tried_push);
  int gnut_threads_dl_handle(query_resp *qr, gnut_transfer *gt,
			     int *retry_enable, int *tried_push);

  void *gnut_th_dl(gnut_transfer *gt, query_resp *a_qrp2, int *retry_enable,
		   int *tried_push, int sl);
  gnut_transfer * gtdl_alloc1(query_resp * a_qrp3);
  void *gnut_threads_dl(void *arg);

  void *gnut_threads_push(void *arg);

  extern gnutella_packet * current_query_packet;
  extern GnutSearch *current_searches;

#ifdef PTHREADS_DRAFT4
  extern pthread_mutex_t gc_list_mutex, send_mutex, _g_debug_mutex,
    make_connection_mutex, transfer_mutex, host_mutex,
    monitor_mutex, push_mutex, query_mutex, route_mutex, 
    share_mutex, cache_mutex;
  void gnut_mutexes_init();

#ifdef hpux
  /*
   * HP-UX does some icky things at 10.20
   */
 
#ifdef sigaction
#undef sigaction
#define sigaction(a,b,c) cma_sigaction(a,b,c)
#endif

#ifdef select
#undef select
#define select(a,b,c,d,e) cma_select(a,(int *)b,(int *)c,(int *)d,e)
#endif

  typedef union {
    pthread_t pthreadpart;
    long  longpart;
  } HPUX_hack;

#endif /* hpux */
#endif /* PTHREADS_DRAFT4 */

  time_t check_push_ip(uint32 tip);
  void remove_push_ip(uint32 tip);
  void add_push_ip(uint32 tip, uint32 wait);

  int send_welcome_message(int sock, char *message);
  int read_welcome_message(int sock, char *hname);
  int incoming_gnutella(int sock, struct sockaddr_in *sin);

  int incoming_transfer_error(int sock, int err, char *message);
  int incoming_transfer(int sock, struct sockaddr_in *sin, char *request_line);
  int incoming_transfer_handle(gnut_transfer *gt, struct sockaddr_in *sin,
			       char *request_line);

#ifdef __cplusplus
}
#endif

#endif /* GNUT_THREADS_H */
