/*
**  EditWindow.m
**
**  Copyright (c) 2001, 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "EditWindow.h"
#include "ExtendedTextView.h"
#include "AutoCompletingTextField.h"

#include "Constants.h"
#include "LabelWidget.h"

@implementation EditWindow

//
//
//
- (void) dealloc
{
  NSDebugLog(@"EditWindow: -dealloc");

  RELEASE(scrollView);
  RELEASE(textView);

  RELEASE(fromLabel);
  RELEASE(accountPopUpButton);
  RELEASE(usingLabel);
  RELEASE(transportMethodPopUpButton);

  RELEASE(toLabel);
  RELEASE(toText);

  RELEASE(ccLabel);
  RELEASE(ccText);

  RELEASE(bccLabel);
  RELEASE(bccText);

  RELEASE(subjectLabel);
  RELEASE(subjectText);

  RELEASE(sizeLabel);

  RELEASE(send);
  RELEASE(insert);
  RELEASE(addBcc);
  RELEASE(addCc);
  RELEASE(addresses);
  
  [super dealloc];
}

//
//
//
- (void) layoutWindow
{ 
  send = [[NSButton alloc] initWithFrame: NSMakeRect(24,445,64,64)];
  [send setTitle: _(@"Send")];
  [send setFont: [NSFont systemFontOfSize: 8]];
  [send setTarget: [self windowController]];
  [send setAction: @selector(sendMessage:)];
  [send setImagePosition: NSImageAbove];
  [send setImage: [NSImage imageNamed: @"send_48.tiff"]];
  [send setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:send];
  
  insert = [[NSButton alloc] initWithFrame: NSMakeRect(96,445,64,64)];
  [insert setTitle: _(@"Attach")];
  [insert setFont:[NSFont systemFontOfSize: 8]];
  [insert setTarget: [self windowController]];
  [insert setAction: @selector(insertFile:)];
  [insert setImagePosition: NSImageAbove];
  [insert setImage: [NSImage imageNamed: @"attach_48.tiff"]];
  [insert setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview:insert];

  addCc = [[NSButton alloc] initWithFrame: NSMakeRect(168,445,64,64)];
  [addCc setTitle: _(@"Add Cc")];
  [addCc setFont:[NSFont systemFontOfSize: 8]];
  [addCc setTarget: [self windowController]];
  [addCc setAction: @selector(showCc:)];
  [addCc setImagePosition: NSImageAbove];
  [addCc setImage: [NSImage imageNamed: @"add_cc_48.tiff"]];
  [addCc setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: addCc];

  addBcc = [[NSButton alloc] initWithFrame: NSMakeRect(240,445,64,64)];
  [addBcc setTitle: _(@"Add Bcc")];
  [addBcc setFont:[NSFont systemFontOfSize: 8]];
  [addBcc setTarget: [self windowController]];
  [addBcc setAction: @selector(showBcc:)];
  [addBcc setImagePosition: NSImageAbove];
  [addBcc setImage: [NSImage imageNamed: @"add_bcc_48.tiff"]];
  [addBcc setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: addBcc];

  addresses = [[NSButton alloc] initWithFrame: NSMakeRect(312,445,64,64)];
  [addresses setTitle: _(@"Addresses")];
  [addresses setFont:[NSFont systemFontOfSize: 8]];
  [addresses setTarget: [NSApp delegate]];
  [addresses setAction: @selector(showAddressBook:)];
  [addresses setImagePosition: NSImageAbove];
  [addresses setImage: [NSImage imageNamed: @"addresses_48.tiff"]];
  [addresses setAutoresizingMask: NSViewMinYMargin];
  [[self contentView] addSubview: addresses];

  // From
  fromLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,410,50,21) 
			   label: _(@"From:")
			   alignment: NSRightTextAlignment];
  [fromLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(fromLabel);
  
  accountPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(65,410,300,ButtonHeight)];
  [accountPopUpButton setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [accountPopUpButton setTarget: [self windowController]];
  [accountPopUpButton setAction: @selector(accountSelectionHasChanged:)];
  
  // Using
  usingLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(370,410,50,21) 
			    label: _(@"Using:")
			    alignment: NSRightTextAlignment];
  [usingLabel setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin];
  RETAIN(usingLabel);
  
  transportMethodPopUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(430,410,300,ButtonHeight)];
  [transportMethodPopUpButton setAutoenablesItems: NO];
  [transportMethodPopUpButton setAutoresizingMask: NSViewMinXMargin|NSViewMinYMargin];
  [transportMethodPopUpButton addItemWithTitle: @"smtp.server.com"];

  // To 
  toLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,385,50,21) 
			 label: _(@"To:")
			 alignment: NSRightTextAlignment];
  [toLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(toLabel);
  
  toText = [[AutoCompletingTextField alloc] initWithFrame: NSMakeRect(65,385,665,21)];
  [toText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [toText setDelegate: [self windowController]];
 
  // Cc
  ccLabel = [LabelWidget labelWidgetWithFrame: NSZeroRect
			 label: _(@"Cc:")
			 alignment: NSRightTextAlignment];
  [ccLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(ccLabel);

  ccText = [[AutoCompletingTextField alloc] init];
  [ccText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [ccText setDelegate: [self windowController]];

  // Bcc
  bccLabel = [LabelWidget labelWidgetWithFrame: NSZeroRect
			  label: _(@"Bcc:")
			  alignment: NSRightTextAlignment];
  [bccLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(bccLabel);

  bccText = [[AutoCompletingTextField alloc] init];
  [bccText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [bccText setDelegate: [self windowController]];

  // Subject
  subjectLabel = [LabelWidget labelWidgetWithFrame: NSZeroRect
			      label: _(@"Subject:")
			      alignment: NSRightTextAlignment];
  [subjectLabel setAutoresizingMask: NSViewMinYMargin];
  RETAIN(subjectLabel);

  subjectText = [[NSTextField alloc] init];
  [subjectText setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  [subjectText setDelegate: [self windowController]];

  // Size
  sizeLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,340,740,TextFieldHeight)
			   label: @"0 KB"];
  [sizeLabel setFont: [NSFont systemFontOfSize: 10]];
  [sizeLabel setTextColor: [NSColor darkGrayColor]];
  [sizeLabel setAutoresizingMask: NSViewMinYMargin|NSViewWidthSizable];
  RETAIN(sizeLabel);

  // Scrollview and text view
  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,5,740,335)];
  [scrollView setBorderType: NSBezelBorder];
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setAutoresizingMask: NSViewHeightSizable|NSViewWidthSizable];
  [[scrollView contentView] setAutoresizingMask: NSViewHeightSizable|NSViewWidthSizable];
  [[scrollView contentView] setAutoresizesSubviews:YES];
  
  textView = [[ExtendedTextView alloc] initWithFrame: [[scrollView contentView] frame]];
  [textView setDelegate: [self windowController]];
  [textView setTextContainerInset: NSMakeSize(5,5)];
  [textView setBackgroundColor: [NSColor textBackgroundColor]];
  [textView setRichText: YES];
  [textView setUsesFontPanel: YES];
  [textView setHorizontallyResizable: NO];
  [textView setVerticallyResizable: YES];
  [textView setMinSize: NSMakeSize (0, 0)];
  [textView setMaxSize: NSMakeSize (1E7, 1E7)];
  [textView setAutoresizingMask: NSViewWidthSizable];
  [[textView textContainer] setContainerSize: NSMakeSize([[scrollView contentView] frame].size.width, 
  							 1E7)];
  [[textView textContainer] setWidthTracksTextView: YES];
  [textView setEditable: YES];
  [textView setString: @""];
  [textView registerForDraggedTypes: [NSArray arrayWithObjects: MessagePboardType, NSFilenamesPboardType,nil]];

  [subjectText setNextKeyView: textView];

  [scrollView setDocumentView: textView];
  
  // We add our UI elemnts
  [[self contentView] addSubview: fromLabel];
  [[self contentView] addSubview: accountPopUpButton];
  [[self contentView] addSubview: usingLabel];
  [[self contentView] addSubview: transportMethodPopUpButton];

  [[self contentView] addSubview: toLabel];
  [[self contentView] addSubview: toText];

  [[self contentView] addSubview: subjectLabel];
  [[self contentView] addSubview: subjectText];

  [[self contentView] addSubview: sizeLabel];
  [[self contentView] addSubview: scrollView];

  [self setMinSize: NSMakeSize(700,450)];
}

@end


