/*
**  PasswordPanelController.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "PasswordPanelController.h"

#import "GNUMail.h"
#import "GNUMailConstants.h"

#ifndef MACOSX
#import "PasswordPanel.h"
#endif

#import <Pantomime/LocalStore.h>

@implementation PasswordPanelController


//
//
//
- (id) initWithWindowNibName: (NSString *) windowNibName
{

#ifdef MACOSX
  
  self = [super initWithWindowNibName: windowNibName];
 
#else
  PasswordPanel *passwordPanel;

  passwordPanel = [[PasswordPanel alloc] initWithContentRect: NSMakeRect(200,200,290,150)
					 styleMask: (NSTitledWindowMask |
						     NSMiniaturizableWindowMask)
					 backing: NSBackingStoreBuffered
					 defer: YES];
  
  self = [super initWithWindow: passwordPanel];
  
  [passwordPanel layoutPanel];
  [passwordPanel setDelegate: self];
 
  // We link our outlets 
  passwordSecureField = [passwordPanel passwordSecureField];

  RELEASE(passwordPanel);
#endif

  return self;
}


- (void) dealloc
{
  NSLog(@"PasswordPanelController: -dealloc");

  [super dealloc];
}


//
// action methods
//

- (IBAction) okClicked: (id) sender
{
  [self setPassword: [passwordSecureField stringValue]];
  [NSApp stopModal];
  [self close];
}


- (IBAction) cancelClicked: (id) sender
{
  [self setPassword: nil];
  [NSApp abortModal];
  [self close];
}

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification
{
  
}

//
// access/mutation methods
//

- (NSString *) password
{
  return password;
}


- (void) setPassword: (NSString *) thePassword
{
  if ( thePassword )
    {
      RETAIN(thePassword);
      RELEASE(password);
      password = thePassword;
    }
  else
    {
      RELEASE(password);
      password = nil;
    }
}

@end
