/*
**  MailboxManagerController.h
**
**  Copyright (C) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**  Author: Jonathan B. Leffert <jonathan@leffert.net> 
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@interface MailboxManagerController: NSWindowController
{
  // Outlets
  IBOutlet NSPopUpButton *transfer;
  IBOutlet NSOutlineView *outlineView;
  IBOutlet NSButton *openOnStartup;

  // Other ivar
  NSMutableArray *allFolders;
  NSArray *allLocalFolders;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// delegate methods
//
- (void) windowWillClose: (NSNotification *) theNotification;


//
// action methods
//

- (IBAction) openOnStartupClicked: (id) sender;

- (IBAction) open: (id) sender;
- (IBAction) transfer: (id) sender;
- (IBAction) create: (id) sender;
- (IBAction) delete: (id) sender;
- (IBAction) rename: (id) sender;

- (void) receivingValuesHaveChanged: (id) sender;

//
// access/mutation methods
//

- (NSOutlineView *) outlineView;

//
// class methods
//

+ (id) singleInstance;


//
// Other methods
//
- (void) openLocalFolderWithName: (NSString *) theFolderName;

- (void) openIMAPFolderWithName: (NSString *) theFolderName
                     serverName: (NSString *) theServerName;

- (void) reloadAllFolders;

@end


//
// Private methods
//
@interface MailboxManagerController (Private)

- (NSString *) _passwordForServerName: (NSString *) theName;

- (NSString *) _serverNameForSelectedItem: (id) theItem;

@end
