/*
**  GNUMailConstants.m
**
**  Copyright (c) 2001, 2002
** 
**  Author: Jonathan B. Leffert <jonathan@leffert.net>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "GNUMailConstants.h"

// GNUMail.app version number string
const NSString *GNUMAIL_VERSION = @"1.0.0";

// Contants for the whole application
const int MANUALLY = 0;
const int AUTOMATICALLY = 1;

const int SHOW_ALL_HEADERS = 1;
const int HIDE_ALL_HEADERS = 2;

const int DELETE_MESSAGE = 1;
const int UNDELETE_MESSAGE = 2;

const int MARK_AS_READ = 1; 
const int MARK_AS_UNREAD = 2;

const int SHOW_DELETED_MESSAGES = 1;
const int HIDE_DELETED_MESSAGES = 2;

const int SHOW_SIZES = 1;
const int HIDE_SIZES = 2;

const int POP3 = 1;
const int IMAP = 2;
 
const int TRANSPORT_MAILER = 1; 
const int TRANSPORT_SMTP = 2;

const int SIGNATURE_BEGINNING = 0;
const int SIGNATURE_END = 1;
const int SIGNATURE_HIDDEN = 2;

// Constants for the UI
const int TextFieldHeight = 21;
const int ButtonHeight = 25;

const int FilterTextFieldTag = 1001;

// Identifiers
const id MimeTypeColumnIdentifier = @"mime-type";
const id FileExtensionsColumnIdentifier = @"file-extensions";
const id MailcapWindowCommandColumnIdentifier = @"command";

const id MainTabViewItemIdentifier = @"main";
const id ServerTypeTabViewItemIdentifier = @"servertype";

const id SendingViewTransportMethodColumnIdentifier = @"transport-method";
const id SendingViewTransportValueColumnIdentifier = @"transport-value";
const id SendingViewHeaderKeyColumnIdentifier = @"header-key";
const id SendingViewHeaderValueColumnIdentifier = @"header-value";

const id FilteringViewRulesColumnIdentifier = @"rules";

const id FilterHeaderEditorTableColumnIdentifier = @"header";

// Notifications used in GNUMail.app
NSString *MimeTypesHaveChanged = @"MimeTypesHaveChanged";
NSString *SelectionOfMessageHasChanged = @"SelectionOfMessageHasChanged";
NSString *ShouldCloseMailbox = @"ShouldCloseMailbox";
NSString *ReceivingValuesHaveChanged = @"ReceivingValuesHaveChanged";

NSString *ShouldStartLocalInboxTimer = @"ShouldStartLocalInboxTimer";
NSString *ShouldStopLocalInboxTimer = @"ShouldStoptLocalInboxTimer";

NSString *FiltersHaveChanged = @"FiltersHaveChanged";

NSString *ReplyToMessageWasSuccessful = @"ReplyToMessageWasSuccessful";

NSString *PersonalProfilesHaveChanged = @"PersonalProfilesHaveChanged";
NSString *TransportMethodsHaveChanged = @"TransportMethodsHaveChanged";
