/*
**  GNUMailBundle.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class NSArray;
@class NSString;
@class NSTextView;

@class Message;
@class MimeBodyPart;

@class PreferencesModule;

extern NSString *PersonalProfilesHaveChanged;

@protocol GNUMailBundle <NSObject>
//
//
//
- (id) initWithOwner: (id) theOwner;
- (void) dealloc;

+ (id) singleInstance;


//
// access / mutation methods
//
- (NSString *) name;
- (NSString *) description;
- (NSString *) version;

- (void) setOwner: (id) theOwner;           // You must not retain the theOwner.

//
// UI elements
//
- (BOOL) hasPreferencesPanel;               // YES/NO. If YES, preferencesModule must not return nil.
- (PreferencesModule *) preferencesModule;  // the panel in the pref panel and its controller



- (BOOL) hasComposeViewAccessory;                                            // If the bundle provide a compose/viewing accessory 
- (id) composeViewAccessory;                                                 // view, it MUST return yes to hasComposeViewAccessory
- (void) composeViewAccessoryWillBeRemovedFromSuperview: (NSView *) theView;

                                                    // or hasViewingViewAccessory. the composeViewAccessory 
- (BOOL) hasViewingViewAccessory;                   // and the viewingViewAccessory MUST return a different
- (id) viewingViewAccessory;                        // instance on each call. setCurrentSuperview will
- (void) viewingViewAccessoryWillBeRemovedFromSuperview: (NSView *) theView;

                                                    // be called each time one of the compose/viewing 
- (void) setCurrentSuperview: (NSView *) theView;   // accessory view is 'the current one'. You must NOT
                                                    // retain the superview.

- (NSArray *) submenuForMenu: (NSMenu *) theMenu;   // Called so that the bundle can return a list of its own
                                                    // submenus for the predefined menus in GNUMail.app
- (NSArray *) menuItemsForMenu: (NSMenu *) theMenu; // Called so that the bundle can return a list of menu items
                                                    // for its own menus or the prefedefined
                                                    // menus in GNUMail.app

//
// The following methods are called if they are implemented. They are used
// by the bundle to be informed when Mail-related operations are 
// currently active.
//
- (MimeBodyPart *) bodyWillBeEncoded: (MimeBodyPart *) theBodyPart
                          forMessage: (Message *) theMessage;

- (MimeBodyPart *) bodyWasEncoded: (MimeBodyPart *) theBodyPart
                       forMessage: (Message *) theMessage;

- (MimeBodyPart *) bodyWillBeDecoded: (MimeBodyPart *) theBodyPart
                          forMessage: (Message *) theMessage;

- (MimeBodyPart *) bodyWasDecoded: (MimeBodyPart *) theBodyPart
                       forMessage: (Message *) theMessage;

- (void) messageWillBeDisplayed: (Message *) theMessage
                         inView: (NSTextView *) theTextView;

- (void) messageWasDisplayed: (Message *) theMessage
                      inView: (NSTextView *) theTextView;

@end

