/*
**  GNUMail.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <Foundation/NSAutoreleasePool.h>
#import <AppKit/AppKit.h>

@class AddressBookController;
@class EditWindowController;
@class LocalStore;
@class Message;

@interface GNUMail : NSObject
{
  // Outlets
  IBOutlet NSMenu *compose;
  IBOutlet NSMenu *drafts;
  IBOutlet NSMenu *edit;
  IBOutlet NSMenu *filters;
  IBOutlet NSMenu *find;
  IBOutlet NSMenu *format;
  IBOutlet NSMenu *info;
  IBOutlet NSMenu *mailbox;
  IBOutlet NSMenu *menu;
  IBOutlet NSMenu *message;
  IBOutlet NSMenu *print;
  IBOutlet NSMenu *saveAttachment;
  IBOutlet NSMenu *sendToAddressBook;
  IBOutlet NSMenu *services;
  IBOutlet NSMenu *sorting;
  IBOutlet NSMenu *windows;
  
  IBOutlet NSMenuItem *deleteOrUndelete;
  IBOutlet NSMenuItem *markAsReadOrUnread;
  IBOutlet NSMenuItem *showAllHeaders;
  IBOutlet NSMenuItem *showOrHideDeleted;
  IBOutlet NSMenuItem *showOrHideSizes;
  IBOutlet NSMenuItem *enterSelection;
  IBOutlet NSMenuItem *saveInDrafts;

  // Other ivar
  LocalStore *localStore;
}

- (id) init;

//
// action methods
//
- (IBAction) bounceMessage: (id) sender;

- (IBAction) compactMailbox: (id) sender;

- (IBAction) composeMessage: (id) sender;

- (IBAction) deleteOrUndeleteMessage: (id) sender;

- (IBAction) enterSelectionInFindPanel: (id) sender;

- (IBAction) findNext: (id) sender;
- (IBAction) findPrevious: (id) sender;

- (IBAction) forwardMessage: (id) sender;
- (IBAction) getNewMessages: (id) sender;

- (IBAction) markMessageAsReadOrUnread: (id) sender;

- (IBAction) print: (id) sender;

- (IBAction) replyAllMessage: (id) sender;
- (IBAction) replyMessage: (id) sender;

- (IBAction) selectAllMessages: (id) sender;

- (IBAction) restoreDraft: (id) sender;

- (IBAction) saveAttachment: (id) sender;
- (IBAction) saveInDrafts: (id) sender;
- (IBAction) saveTextFromMessage: (id) sender;

- (IBAction) sortByNumber: (id) sender;
- (IBAction) sortByDate: (id) sender;
- (IBAction) sortByName: (id) sender;
- (IBAction) sortBySubject: (id) sender;
- (IBAction) sortBySize: (id) sender;

- (IBAction) showAddressBook: (id) sender;
- (IBAction) showAllHeaders: (id) sender;
- (IBAction) showFindWindow: (id) sender;
- (IBAction) showMailboxManager: (id) sender;

- (IBAction) showOrHideDeletedMessages: (id) sender;
- (IBAction) showOrHideSizesForMailWindow: (id) sender;

- (IBAction) showPreferencesWindow: (id) sender;
- (IBAction) showRAWSource: (id) sender;


//
// delegate methods
//
- (BOOL) applicationShouldTerminate: (NSApplication *) sender;

- (void) applicationWillFinishLaunching: (NSNotification *)not;

- (void) applicationDidFinishLaunching: (NSNotification *) not;


//
// methods invoked by notifications
//
- (void) selectionInTextViewHasChanged: (id) sender;

- (void) selectionOfMessageHasChanged: (id) sender;

//
// access / mutation methods
//
+ (NSArray *) allBundles;

+ (NSArray *) allMailWindows;

- (LocalStore *) localStore;

+ (NSString *) currentWorkingPath;
+ (void) setCurrentWorkingPath: (NSString *) thePath;

+ (id) lastAddressTakerWindowOnTop;
+ (void) setLastAddressTakerWindowOnTop: (id) aWindow;

+ (id) lastMailWindowOnTop;
+ (void) setLastMailWindowOnTop: (id) aWindow;


- (NSMenu *) saveAttachmentMenu;

- (void) setEnableSaveInDraftsMenuItem: (BOOL) aBOOL;

//
// other methods
// 
- (void) addItemToMenuFromTextAttachment: (NSTextAttachment *) theTextAttachment;

+ (void) addMailWindow: (id) theMailWindow;

- (void) addToAddressBook: (id) sender;

- (void) loadBundles;

- (void) removeAllItemsFromMenu: (NSMenu *) theMenu;

+ (void) removeMailWindow: (id) theMailWindow;

- (void) showFoldersToOpen;

- (void) updateFilterMenuItems: (id) sender;

- (void) updateMenuItemsForMessage: (Message *) theMessage;

- (void) updateShowOrHideDeletedMenuItem: (BOOL) aBOOL;

//
// services methods
//
- (void) newMessageWithContent: (NSPasteboard *) pboard
	              userData: (NSString *) userData
                         error: (NSString **) error;

- (void) newMessageWithRecipient: (NSPasteboard *) pboard
	                userData: (NSString *) userData
                           error: (NSString **) error;

@end

//
// 
//
@interface ExtentedMenuItem : NSMenuItem
{
  NSTextAttachment *textAttachment;
}

- (NSTextAttachment *) textAttachment;
- (void) setTextAttachment: (NSTextAttachment *) theTextAttachment;

@end
