/*
**  FindWindowController.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@interface FindWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSTextField *findField;
  IBOutlet NSTextField *replaceWithField;
  IBOutlet NSTextField *foundLabel;
  IBOutlet NSButton *ignoreCaseButton;
  IBOutlet NSButton *regularExpressionButton;
  
  IBOutlet NSMatrix *matrix;

  // Other ivar
  NSMutableArray *indexes;
  int location;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;


//
// action methods
//

- (IBAction) findAll : (id) sender;
- (IBAction) nextMessage: (id) sender;
- (IBAction) previousMessage: (id) sender;

//
// delegate methods
//

- (void) windowDidLoad;

//
// access/mutation methods
//
- (void) updateLabel: (NSTextField *) theLabel
           withValue: (int) theValue;

- (NSTextField *) findField;

//
// class methods
//

+ (id) singleInstance;

@end

