/*
**  FilterManager.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <Foundation/Foundation.h>

@class Filter;
@class Message;

NSString *PathToFilters();

@interface FilterManager: NSObject <NSCoding>
{
  NSMutableArray *filters;
}

- (id) init;
- (void) dealloc;

- (BOOL) synchronize;

//
// NSCoding protocol
//

- (void) encodeWithCoder: (NSCoder *) theCoder;
- (id) initWithCoder: (NSCoder *) theCoder;

//
// access/mutation methods
//
- (Filter *) filterAtIndex: (int) theIndex;
- (void) addFilter: (Filter *) theFilter;
- (void) addFilter: (Filter *) theFilter
           atIndex: (int) theIndex;
- (void) removeFilter: (Filter *) theFilter;

- (NSArray *) filters;
- (void) setFilters: (NSArray *) theFilters;


- (Filter *) matchedFilterForMessage: (Message *) theMessage;

- (NSColor *) colorForMessage: (Message *) theMessage;

//
// class methods
//

+ (id) filtersFromDisk;

@end

//
// private methods
//
@interface FilterManager (Private)

- (BOOL) _matchString: (NSString *) theString
            operation: (int) theOperation
             criteria: (NSString *) theCriteria;

- (NSArray *) _stringsFromMessage: (Message *) theMessage
                           filter: (Filter *) theFilter;


@end
