/*
**  EditWindowController.h
**
**  Copyright (c) 2001, 2002
**
**  Ludovic Marcotte <ludovic@Sophos.ca>
**  Jonathan B. Leffert <jonathan@leffert.net>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

#import "AddressTaker.h"

@class Address;
@class EditWindow;
@class Folder;
@class Message;
@class MimeTypeManager;
@class Part;

@interface EditWindowController: NSWindowController <AddressTaker>
{
  // Outlets
  IBOutlet NSTextField *subjectText;
  IBOutlet NSTextField *toText;
  IBOutlet NSTextField *ccText;
  IBOutlet NSTextField *bccText;

  IBOutlet NSTextField *subjectLabel;
  IBOutlet NSTextField *toLabel;
  IBOutlet NSTextField *ccLabel;
  IBOutlet NSTextField *bccLabel;

  IBOutlet NSScrollView *scrollView;
  IBOutlet NSTextView *textView;

  IBOutlet NSButton *icon;
  IBOutlet NSButton *send;
  IBOutlet NSButton *insert;
  IBOutlet NSButton *addBcc;
  IBOutlet NSButton *addCc;
  IBOutlet NSButton *addresses;
  IBOutlet NSButton *cancel;

  IBOutlet NSPopUpButton *personalProfilePopUpButton;
  IBOutlet NSPopUpButton *transportMethodPopUpButton;

  // Other ivars
  Message *message;
  Message *unmodifiedMessage;

  MimeTypeManager *mimeTypeManager;

  BOOL messageWasSent;
  BOOL showCc;
  BOOL showBcc;

  int signaturePosition;

  NSConnection *connection;
  NSArray *ports;
  
  NSTimer *animation;
  int animation_index;

  NSMutableDictionary *passwordCache;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;

- (void) dealloc;

//
// action methods
//

- (IBAction) insertFile: (id) sender;

- (IBAction) sendMessage: (id) sender;

- (IBAction) showBcc: (id) sender;
- (IBAction) showCc: (id) sender;

- (IBAction) personalProfilesSelectionHasChanged: (id) sender;

- (IBAction) updateAnimatedIcon: (id) sender;

//
// delegate methods
//

- (void) controlTextDidChange: (NSNotification *) aNotification;
- (void) textDidChange: (NSNotification *) aNotification;
- (BOOL) windowShouldClose: (id) sender;
- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidBecomeMain: (NSNotification *) theNotification;
- (void) windowDidLoad;

//
// access/mutation methods
//

- (Message *) message;
- (void) setMessage: (Message *) theMessage;

- (Message *) unmodifiedMessage;
- (void) setUnmodifiedMessage: (Message *) theUnmodifiedMessage;

- (void) setMessageFromDraftsFolder: (Message *) theMessage;

- (BOOL) showCc;
- (void) setShowCc: (BOOL) theBOOL;

- (BOOL) showBcc;
- (void) setShowBcc: (BOOL) theBOOL;

- (BOOL) messageWasSent;
- (void) setMessageWasSent: (BOOL) theBOOL;

- (int) signaturePosition;
- (void) setSignaturePosition: (int) thePosition;


//
// other methods
//

- (void) authenticationFailedForServer: (NSString *) theServer;
- (void) errorOccuredWhenSendingMessage;
- (void) messageWasSentFromRAWSource: (NSData *) theRAWSource
                              window: (id) theWindow
                        outboxFolder: (Folder *) theFolder;
- (BOOL) updateMessageContentFromTextView: (BOOL) verifyRecipients;

@end

//
// private methods
//
@interface EditWindowController (Private)

- (void) _adjustWidgetsPosition;

- (void) _loadPersonalProfiles;

- (void) _loadTransportMethods;

- (void) _loadSignature;

- (void) _loadMimeTypes;

- (NSString *) _passwordForServerName: (NSString *) theName
                               prompt: (BOOL) aBOOL;

- (NSString *) _plainTextContentFromTextView;

- (NSArray *) _recipientsFromString: (NSString *) theString;

- (void) _sendMessageUsingPorts: (NSArray *) thePorts;

- (void) _setPlainTextContentFromString: (NSString *) theString
                                 inPart: (Part *) thePart;

- (void) _showAlertPanelWithString: (NSString *) theString;

- (void) _updateViewWithMessage: (Message *) theMessage
                appendSignature: (BOOL) aBOOL;

@end
