/*
**  EditWindow.h
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import <AppKit/AppKit.h>

@class LabelWidget;

@interface EditWindow : NSWindow
{
  NSTextView *textView;
  NSTextField *toText;
  NSTextField *ccText;
  NSTextField *bccText;
  NSTextField *subjectText;

  LabelWidget *fromLabel;
  LabelWidget *usingLabel;
  LabelWidget *toLabel;
  LabelWidget *ccLabel;
  LabelWidget *bccLabel;
  LabelWidget *subjectLabel;

  NSScrollView *scrollView;
  
  NSButton *icon;
  NSButton *send;
  NSButton *insert;
  NSButton *addCc;
  NSButton *addBcc;
  NSButton *addresses;
  NSButton *cancel;

  NSPopUpButton *personalProfilePopUpButton;
  NSPopUpButton *transportMethodPopUpButton;
}

- (void) dealloc;

- (void) layoutWindow;

//
// access/mutation methods
//

- (NSTextField *) subjectText;
- (NSTextField *) toText;
- (NSTextField *) ccText;
- (NSTextField *) bccText;

- (LabelWidget *) subjectLabel;
- (LabelWidget *) toLabel;
- (LabelWidget *) ccLabel;
- (LabelWidget *) bccLabel;
- (LabelWidget *) fromLabel;
- (LabelWidget *) usingLabel;

- (NSScrollView *) scrollView;
- (NSTextView *) textView;

- (NSButton *) icon;
- (NSButton *) send;
- (NSButton *) insert;
- (NSButton *) addBcc;
- (NSButton *) addCc;
- (NSButton *) addresses;
- (NSButton *) cancel;

- (NSPopUpButton *) personalProfilePopUpButton;
- (NSPopUpButton *) transportMethodPopUpButton;

@end



