/*
**  PersonalView.m
**
**  Copyright (c) 2001, 2002
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#import "PersonalView.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation PersonalView

- (id) initWithParent: (id) theParent
{
  self = [super init];

  parent = theParent;

  return self;
}

//
//
//
- (void) dealloc
{
  //NSLog(@"PersonalView: -dealloc");
  
  RELEASE(box);

  RELEASE(popUpButton);

  RELEASE(defaultProfileButton);

  RELEASE(nameField);
  RELEASE(emailField);
  RELEASE(replytoField);
  RELEASE(organizationField);

  RELEASE(signaturePopUp);
  RELEASE(signatureField);
  
  [super dealloc];
}


//
//
//
- (void) layoutView
{
  LabelWidget *nameLabel, *emailLabel, *replytoLabel, *organizationLabel, *signatureLabel, *availableLabel;
  NSButton *addButton, *deleteButton, *signatureButton;
  NSBox *box2;

  // Add our UI elements used for editing personal profiles 
  availableLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(5,320,155,TextFieldHeight)
				label: _(@"Available personal profiles:")];
  [self addSubview: availableLabel];

  popUpButton = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(170,320,135,ButtonHeight)];
  [popUpButton setTarget: parent];
  [popUpButton setAction: @selector(changePersonalSelection:)];
  [self addSubview: popUpButton];
  
  addButton = [[NSButton alloc] initWithFrame: NSMakeRect(310,320,60,ButtonHeight)];
  [addButton setTitle: _(@"Add")];
  [addButton setTarget: parent];
  [addButton setAction: @selector(addClicked:)];
  [self addSubview: addButton];
  RELEASE(addButton);

  deleteButton = [[NSButton alloc] initWithFrame: NSMakeRect(375,320,60,ButtonHeight)];
  [deleteButton setTitle: _(@"Delete")];
  [deleteButton setTarget: parent];
  [deleteButton setAction: @selector(deleteClicked:)];
  [self addSubview: deleteButton];
  RELEASE(deleteButton);

  defaultProfileButton = [[NSButton alloc] initWithFrame: NSMakeRect(5,290,200,ButtonHeight)];
  [defaultProfileButton setButtonType: NSSwitchButton];
  [defaultProfileButton setBordered: NO];
  [defaultProfileButton setTitle: _(@"Set this profile as default")];
  [defaultProfileButton setTarget: parent];
  [defaultProfileButton setAction: @selector(defaultProfileButtonClicked:)];
  [self addSubview: defaultProfileButton];

  // We initialize our box
  box = [[NSBox alloc] initWithFrame: NSMakeRect(5,145,430,135)];
  [box setTitlePosition: NSNoTitle];
  [box setBorderType: NSGrooveBorder];
  
  // We add our UI elements to our box
  nameLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,95,75,TextFieldHeight)
			   label: _(@"Your name:")];
  [box addSubview: nameLabel];
  
  nameField = [[NSTextField alloc] initWithFrame: NSMakeRect(145,95,265,TextFieldHeight)];
  [nameField setEditable: YES];
  [box addSubview:nameField];
  
  emailLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,65,125,TextFieldHeight)
			    label: _(@"Your E-Mail address:")];
  [box addSubview:emailLabel];
  

  emailField = [[NSTextField alloc] initWithFrame: NSMakeRect(145,65,265,TextFieldHeight)];
  [emailField setEditable: YES];
  [box addSubview:emailField];
  
  replytoLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,35,115,TextFieldHeight)
			      label: _(@"Reply-to address:")];
  [box addSubview:replytoLabel];

  
  replytoField = [[NSTextField alloc] initWithFrame: NSMakeRect(145,35,265,TextFieldHeight)];
  [replytoField setEditable: YES];
  [box addSubview: replytoField];
    
  organizationLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,5,100,TextFieldHeight)
				   label: _(@"Organization:")];
  [box addSubview:organizationLabel];
  
  organizationField = [[NSTextField alloc] initWithFrame: NSMakeRect(145,5,265,TextFieldHeight)];
  [organizationField setEditable: YES];
  [box addSubview: organizationField];
  
  // We add our box to our view
  [self addSubview: box];

  // We initialize our box for our signature
  box2 = [[NSBox alloc] initWithFrame: NSMakeRect(5,45,430,90)];
  [box2 setContentViewMargins: NSMakeSize(0,0)];
  [box2 setTitlePosition: NSAtTop];
  [box2 setTitle: _(@"Signature")];
  [box2 setBorderType: NSGrooveBorder];

  // We add the rest of our UI elements for setting the signature and our 'wait panels'
  signatureLabel = [LabelWidget labelWidgetWithFrame: NSMakeRect(10,35,125,TextFieldHeight)
				label: _(@"Obtain signature from")];
  [box2 addSubview: signatureLabel];

  signaturePopUp = [[NSPopUpButton alloc] initWithFrame: NSMakeRect(140,32,125,ButtonHeight)];
  [signaturePopUp setAutoenablesItems: NO];
  [signaturePopUp addItemWithTitle: _(@"content of file")];
  [signaturePopUp addItemWithTitle: _(@"program's output")];
  [box2 addSubview: signaturePopUp];

  signatureField = [[NSTextField alloc] initWithFrame: NSMakeRect(270,35,140,TextFieldHeight)];
  [signatureField setEditable: YES];
  [signatureField setSelectable: YES];
  [box2 addSubview: signatureField];
  
  signatureButton = [[NSButton alloc] initWithFrame: NSMakeRect(345,1,65,ButtonHeight)];
  [signatureButton setTitle: _(@"Choose")];
  [signatureButton setTarget: parent];
  [signatureButton setAction: @selector(getSignature:)];
  [box2 addSubview:signatureButton];
  RELEASE(signatureButton);
 
  // We add our signature box to our view
  [self addSubview: box2];

  showWaitPanels = [[NSButton alloc] initWithFrame: NSMakeRect(5,5,425,ButtonHeight)];
  [showWaitPanels setButtonType: NSSwitchButton];
  [showWaitPanels setBordered: NO];
  [showWaitPanels setTitle: _(@"Show Wait Panels (this might slow down the application)")];
  [self addSubview: showWaitPanels];

  // We set the next key views
  [nameField setNextKeyView: emailField];
  [emailField setNextKeyView: replytoField];
  [replytoField setNextKeyView: organizationField];
  [organizationField setNextKeyView: signatureField];
  [signatureField setNextKeyView: signatureButton];
  [signatureButton setNextKeyView: nameField];
}


//
// access methods
//

- (NSBox *) box
{
  return box;
}

- (NSPopUpButton *) popUpButton
{
  return popUpButton;
}

- (NSTextField *) nameField
{
  return nameField;
}

- (NSTextField *) emailField
{
  return emailField;
}

- (NSTextField *) replytoField
{
  return replytoField;
}

- (NSTextField *) organizationField
{
  return organizationField;
}

- (NSPopUpButton *) signaturePopUp
{
  return signaturePopUp;
}

- (NSTextField *) signatureField
{
  return signatureField;
}

- (NSButton *) showWaitPanels
{
  return showWaitPanels;
}

- (NSButton *) defaultProfileButton
{
  return defaultProfileButton;
}

@end
