/*
**  MailcapWindow.m
**
**  Copyright (c) 2001
**
**  Author: Vincent Ricard <vricard@wanadoo.fr>
**          Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "MailcapWindow.h"

#import "GNUMailConstants.h"
#import "LabelWidget.h"

@implementation MailcapWindow

//
//
//
- (void) dealloc
{
  NSLog(@"MailcapWindow: -dealloc");
  
  RELEASE(mimeTypesColumn);
  RELEASE(commandColumn);
  RELEASE(tableView);

  [super dealloc];
}


//
//
//
- (void) layoutWindow
{
  NSButton *importButton, *cancelButton;
  NSScrollView *scrollView;

  mimeTypesColumn = [[NSTableColumn alloc] initWithIdentifier: MimeTypeColumnIdentifier];
  [mimeTypesColumn setEditable: NO];
  [[mimeTypesColumn headerCell] setStringValue: _(@"Mime-Type")];
  [mimeTypesColumn setMinWidth: 245];
  [mimeTypesColumn setMaxWidth: 245];

  commandColumn = [[NSTableColumn alloc] initWithIdentifier: MailcapWindowCommandColumnIdentifier];
  [commandColumn setEditable: NO];
  [[commandColumn headerCell] setStringValue: _(@"Command")];
  [commandColumn setMinWidth: 245];
  [commandColumn setMaxWidth: 245];

  tableView = [[NSTableView alloc] initWithFrame: NSMakeRect(5,55,490,200)];
  [tableView setDrawsGrid:NO];
  [tableView setAllowsColumnSelection: NO];
  [tableView setAllowsColumnReordering: NO];
  [tableView setAllowsEmptySelection: NO];
  [tableView setAllowsMultipleSelection: YES];
  [tableView addTableColumn: mimeTypesColumn];
  [tableView addTableColumn: commandColumn];
  [tableView setDataSource: [self windowController]];
  [tableView setDelegate: [self windowController]];

  scrollView = [[NSScrollView alloc] initWithFrame: NSMakeRect(5,55,490,200)];
  AUTORELEASE(scrollView);
  [scrollView setHasHorizontalScroller: NO];
  [scrollView setHasVerticalScroller: YES];
  [scrollView setDocumentView:tableView];
  [[self contentView] addSubview: scrollView];

  cancelButton = [[NSButton alloc] initWithFrame: NSMakeRect(405,5,90,ButtonHeight)];
  AUTORELEASE(cancelButton);
  [cancelButton setTitle: _(@"Cancel")];
  [cancelButton setTarget: [self windowController]];
  [cancelButton setAction: @selector(cancelClicked:)];
  [[self contentView] addSubview: cancelButton];

  importButton = [[NSButton alloc] initWithFrame: NSMakeRect(305,5,90,ButtonHeight)];
  AUTORELEASE(importButton);
  [importButton setTitle: _(@"Import")];
  [importButton setTarget: [self windowController]];
  [importButton setAction: @selector(importClicked:)];
  [[self contentView] addSubview: importButton];
}


- (NSTableView *) tableView
{
  return tableView;
}

- (NSTableColumn *) mimeTypesColumn
{
  return mimeTypesColumn;
}

- (NSTableColumn *) commandColumn
{
  return commandColumn;
}

@end
