/*
**  FilterEditorWindowController.h
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import <AppKit/AppKit.h>

@class Filter;
@class FilterManager;

@interface FilterEditorWindowController: NSWindowController
{
  // Outlets
  IBOutlet NSTextField *descriptionField;
  IBOutlet NSButton *activeButton;
  
  IBOutlet NSPopUpButton *criteriaSourcePopUpButton;
  IBOutlet NSPopUpButton *criteriaFindOperationPopUpButton;
  IBOutlet NSTextField *criteriaStringField;

  IBOutlet NSMatrix *matrix;
  IBOutlet NSPopUpButton *actionColorPopUpButton;
  IBOutlet NSPopUpButton *actionFolderNamePopUpButton;
  IBOutlet NSPopUpButton *actionEMailStringPopUpButton;
  IBOutlet NSTextField *actionEMailStringField;
  IBOutlet NSButton *actionEMailStringButton;
 
  // Other ivar
  Filter *filter;
  FilterManager *filterManager;
}

- (id) initWithWindowNibName: (NSString *) windowNibName;
- (void) dealloc;

//
// delegate methods
//

- (void) windowWillClose: (NSNotification *) theNotification;
- (void) windowDidLoad;

//
// action methods
//
- (IBAction) okClicked: (id) sender;

- (IBAction) cancelClicked: (id) sender;

- (IBAction) selectionHasChanged : (id) sender;

- (IBAction) setMessage: (id) sender;

- (IBAction) criteriaSourceSelectionHasChanged: (id) sender;

//
// access/mutation methods
//

- (FilterManager *) filterManager;
- (void) setFilterManager: (FilterManager *) theFilterManager;

- (Filter *) filter;
- (void) setFilter: (Filter *) theFilter;

//
// other methods
//
- (void) _addItemsToFolderNamePopUpButton;

@end

