/*
**  ComposeViewController.m
**
**  Copyright (c) 2001
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#import "ComposeViewController.h"

#import "GNUMailConstants.h"

#ifndef MACOSX
#import "ComposeView.h"
#endif

static ComposeViewController *singleInstance = nil;

@implementation ComposeViewController

- (id) initWithNibName: (NSString *) theName
{
  self = [super init];

#ifdef MACOSX
  
  if (! [NSBundle loadNibNamed: theName
		  owner: self] )
    {
      NSLog(@"Fatal error occured while loading the ComposeView nib file");
      AUTORELEASE(self);
      return nil;
    }

  RETAIN(view);

#else
  // We link our view
  view = [[ComposeView alloc] initWithParent: self];
  [view layoutView];

  // We link our outlets
  replyPopUpButton = [view replyPopUpButton];
  forwardPopUpButton = [view forwardPopUpButton];
  lineWrapLimitField = [view lineWrapLimitField];
  
#endif
    
  // We get our defaults for this panel
  [self initializeFromDefaults];

  return self;
}

//
// action methods
//
- (IBAction) selectionOfReplyPopUpButtonHasChanged: (id) sender
{
  //NSLog(@"reply");
}

- (IBAction) selectionOfForwardPopUpButtonHasChanged: (id) sender
{
  //NSLog(@"forward");
}

- (void) dealloc
{
  singleInstance = nil;
  RELEASE(view);

  [super dealloc];
}


//
// access methods
//

- (NSImage *) image
{
  NSBundle *aBundle;
  
  aBundle = [NSBundle bundleForClass: [self class]];
  
  return AUTORELEASE([[NSImage alloc] initWithContentsOfFile:
					[aBundle pathForResource: @"MailIcon_create" ofType: @"tiff"]]);
}

- (NSString *) name
{
  return _(@"Compose");
}

- (NSView *) view
{
  return view;
}

- (BOOL) hasChangesPending
{
  return YES;
}


//
//
//
- (void) initializeFromDefaults
{
  [replyPopUpButton selectItemAtIndex: [[NSUserDefaults standardUserDefaults]
					 integerForKey: @"SIGNATURE_REPLY_POSITION"] ];
  
  [forwardPopUpButton selectItemAtIndex: [[NSUserDefaults standardUserDefaults]
					   integerForKey: @"SIGNATURE_FORWARD_POSITION"] ];

  if ( [[NSUserDefaults standardUserDefaults] integerForKey: @"LINE_WRAP_LIMIT"] )
    {
      [lineWrapLimitField setIntValue: [[NSUserDefaults standardUserDefaults] integerForKey: @"LINE_WRAP_LIMIT"] ];
    }
  else
    {
      [lineWrapLimitField setIntValue: 998];
    }
}


- (void) saveChanges
{
  int value;

  // We sync our titles with our selected items for all our popup button
  [replyPopUpButton synchronizeTitleAndSelectedItem];
  [forwardPopUpButton synchronizeTitleAndSelectedItem];

  // We save the preferences
  [[NSUserDefaults standardUserDefaults] setInteger: [replyPopUpButton indexOfSelectedItem]
					 forKey: @"SIGNATURE_REPLY_POSITION"];
  
  [[NSUserDefaults standardUserDefaults] setInteger: [forwardPopUpButton indexOfSelectedItem]
					 forKey: @"SIGNATURE_FORWARD_POSITION"];
  
  value = [lineWrapLimitField intValue];
  
  if (value <= 0 || value > 998)
    {
      value = 998;
    }
  
  [[NSUserDefaults standardUserDefaults] setInteger: value
					 forKey:  @"LINE_WRAP_LIMIT"];
}

//
// class methods
//
+ (id) singleInstance
{
  if (! singleInstance)
    {
      singleInstance = [[ComposeViewController alloc] initWithNibName: @"ComposeView"];
    }

  return singleInstance;
}

@end
