/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*  This file is part of gnome-spell bonobo component

    Copyright (C) 1999, 2000 Helix Code, Inc.
    Authors:                 Radek Doulik <rodo@helixcode.com>

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.

 */

#include <config.h>
#include <gnome.h>
#include <liboaf/liboaf.h>
#include <bonobo.h>
#include "Spell.h"
#include "dictionary.h"
#include "checker.h"
#include "control.h"

CORBA_Environment ev;
CORBA_ORB orb;

static BonoboGenericFactory *dictionary_factory;
static BonoboGenericFactory    *checker_factory;
static BonoboGenericFactory    *control_factory;

static int active_dictionary_servers = 0;
static int active_checker_servers = 0;
static int active_control_servers = 0;

typedef enum {
	TYPE_DICTIONARY,
	TYPE_CHECKER,
	TYPE_CONTROL,
} SpellObjectType;

static void
init_server_factory (int argc, char **argv)
{
        gnome_init_with_popt_table("gnome-spell-component", VERSION,
				   argc, argv,
				   oaf_popt_options, 0, NULL); 
	orb = oaf_init (argc, argv);

	if (bonobo_init (orb, NULL, NULL) == FALSE)
		g_error (_("I could not initialize Bonobo"));

	glade_gnome_init ();
}

static void
try_quit ()
{
	/* printf ("Try quit:\n\tchecker: %d\n\tdictionary: %d\n\tcontrol: %d\n",
	   active_checker_servers, active_dictionary_servers, active_control_servers); */

	if (active_checker_servers || active_dictionary_servers || active_control_servers)
		return;
	bonobo_object_unref (BONOBO_OBJECT (checker_factory));
	bonobo_object_unref (BONOBO_OBJECT (dictionary_factory));
	bonobo_object_unref (BONOBO_OBJECT (control_factory));

	gtk_main_quit ();
}

static void
object_destroyed (GtkObject *checker_object, gpointer data)
{
	(*(gint *) data) --;

	try_quit ();
}

static BonoboObject *
factory_object_new (BonoboGenericFactory *this_factory, gpointer data)
{
	BonoboObject *new_object;
	gint *counter;

	switch (GPOINTER_TO_INT (data)) {
	case TYPE_DICTIONARY:
		new_object = gnome_spell_dictionary_new ();
		counter    = &active_dictionary_servers;
		break;
	case TYPE_CHECKER:
		new_object = gnome_spell_checker_new ();
		counter    = &active_checker_servers;
		break;
	case TYPE_CONTROL:
		new_object = gnome_spell_control_new ();
		counter    = &active_control_servers;
		break;
	default:
		g_warning ("Dunno how to create object of this unknown type");
		return NULL;
	}
	if (!new_object)
		return NULL;

	(*counter) ++;

	gtk_signal_connect (GTK_OBJECT (new_object), "destroy", object_destroyed, counter);

	return new_object;
}

static void
factory_init (void)
{
	checker_factory = bonobo_generic_factory_new
		("OAFIID:GNOME_Spell_CheckerFactory:" API_VERSION,
		 factory_object_new, GINT_TO_POINTER (TYPE_CHECKER));
	dictionary_factory = bonobo_generic_factory_new
		("OAFIID:GNOME_Spell_DictionaryFactory:" API_VERSION,
		 factory_object_new, GINT_TO_POINTER (TYPE_DICTIONARY));
	control_factory = bonobo_generic_factory_new
		("OAFIID:GNOME_Spell_ControlFactory:" API_VERSION,
		 factory_object_new, GINT_TO_POINTER (TYPE_CONTROL));

	if (!checker_factory)
		g_error ("It was not possible to register a new checker factory");
	if (!dictionary_factory)
		g_error ("It was not possible to register a new dictionary factory");
	if (!control_factory)
		g_error ("It was not possible to register a new spell control factory");
}

int
main (int argc, char *argv [])
{
	/* Initialize the i18n support */
	bindtextdomain(PACKAGE, GNOMELOCALEDIR);
	textdomain(PACKAGE);

	CORBA_exception_init (&ev);

	init_server_factory (argc, argv);
	factory_init ();
	bonobo_activate ();

	gtk_main ();
	CORBA_exception_free (&ev);

	return 0;
}
