/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4:ts=4:
 *
 * Gnome Apt frontend
 *
 * 	(C) 1999 Olivier Gravel Aubin <ogaubin@ucalgary.ca>
 * 	    2002, 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GNOME_APT_SOURCES_WIZARD_H
#define GNOME_APT_SOURCES_WIZARD_H

#include <libgnomeui/gnome-druid.h>

class SourcesWizard {
public:
  SourcesWizard();
  ~SourcesWizard();

	void add (GtkWidget*);

private:

  typedef enum {
    PageInvalid,
    PageDist,
    PageURI,
    PageSection
  } SourcesWizardPage;
  
  GtkWidget* wizard_;

  GtkWidget* drud_;

  GtkWidget* page_dist_;
  GtkWidget* page_uri_;
  GtkWidget* page_section_;

  GtkWidget* dist_stable_;
  GtkWidget* dist_unstable_;
  GtkWidget* dist_other_;
  GtkWidget* dist_entry_box_;

  GtkWidget* uri_entry_box_;

  GtkWidget* section_main_;
  GtkWidget* section_contrib_;
  GtkWidget* section_non_free_;
  GtkWidget* section_non_us_;

  SourcesWizardPage current_page_;

  static gint close_cb(GtkWidget* w, GdkEvent* e, gpointer data);
  void close();

	static void finish_cb (GnomeDruidPage*, gpointer, gpointer);
  void finish();

	static void cancel_cb (GnomeDruid*, gpointer);
  void cancel();

	static gboolean next_cb (GnomeDruidPage*, gpointer, gpointer);
  gboolean next();

	static gboolean back_cb (GnomeDruidPage*, gpointer, gpointer);
  gboolean back();

  static void toggled_cb(GtkToggleButton* b, gpointer data);
  void toggled(GtkToggleButton *b);

  void config_current_page();
};

SourcesWizard* gnome_apt_sources_wizard();
void gnome_apt_sources_wizard_shutdown();

#endif
