//  main executable for GDeb standalone
//  Copyright (C) 1998 Lalo Martins <lalo@debian.org>

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  (at your option) any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

#include <config.h>
#include <gnome.h>

#include "gdeb.h"

// This is just a dummy class now, but eventually would not be.
class DebPackage : public GDeb::Package
{
public:
  DebPackage(const string & filename);
  virtual ~DebPackage() {}

  // Stuff to display
  virtual string Name() { return _("packagename"); }
  virtual string Version() { return "1.0"; }
  virtual string Description_Short()  { return "This is a sample package"; }
  virtual string Description_Long()  { return "This is a sample package.\nIt does all kinds of cool stuff.\nScattered, smothered, covered...\nLa la la la la\n"; }
  virtual string Section()  { return "coolo"; }
  virtual string Priority()  { return "Essential"; }
  virtual string Size()  { return "100k"; }
  virtual string Installed_Size()  { return "400k"; }
  virtual string Maintainer()  { return "Jane P. Debian"; }
  virtual string Status()  { return "Installed"; }
  virtual string Current_Version()  { return "1.0"; }
  virtual string Architecture()  { return "i386"; }
  virtual string Source()  { return "source?"; }
  virtual string Filename()  { return "packagename_1.0.deb"; }
  virtual bool   Essential() { return true; }
  virtual bool   Downloadable() { return true; }
  virtual bool   Automatic()  { return false; }
  virtual vector<string> Provides() { return vector<string>(0); }
  virtual vector<string> PreDepends()  { return vector<string>(0); }
  virtual vector<string> Depends()  { return vector<string>(0); }
  virtual vector<string> Recommends()  { return vector<string>(0); }
  virtual vector<string> Suggests()  { return vector<string>(0); }
  virtual vector<string> Conflicts()  { return vector<string>(0); }
  virtual vector<string> Replaces()  { return vector<string>(0); }
  
  // Actions
  virtual void Install() { g_warning(__FUNCTION__); }
  virtual void Delete() { g_warning(__FUNCTION__); }
  virtual void Keep() { g_warning(__FUNCTION__); }
};

DebPackage::DebPackage(const string & filename)
{


}

int main ( int argc, char ** argv )
{
  // i18n
  bindtextdomain ("gdeb", GNOMELOCALEDIR);
  textdomain ("gdeb");

  // For now we have no arg parser
  gnome_init ("gdeb", "0.1", argc, argv);
  
#ifdef GNOME_ENABLE_DEBUG
  // so we don't have to install
  gtk_rc_parse("./gdebrc");
#endif

  gtk_rc_parse(GDEBRC);

  DebPackage dp("testing.deb");

  GDeb gd(_("GNOME .deb viewer"));

  gd.set_package(&dp);

  GtkWidget* window = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  gtk_container_add(GTK_CONTAINER(window), gd.widget());

  gtk_widget_show_all(window);

  gtk_main();
    
  exit(EXIT_SUCCESS);
}

