/*
 * GNoise
 *
 * Copyright (C) 1999-2001 Dwight Engen
 *
 * This code was originally based on the sample display code from:
 * The Real SoundTracker - GTK+ sample display widget which is
 * Copyright (C) 1998 Michael Krause
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: gtklevels.h,v 1.4 2001/01/20 19:40:11 dengen Exp $
 *
 */

#ifndef __GTK_LEVELS_H__
#define __GTK_LEVELS_H__

#include <gdk/gdk.h>
#include <gtk/gtkbox.h>

#define GTK_TYPE_LEVELS            (gtk_levels_get_type ())
#define GTK_LEVELS(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_LEVELS, GtkLevels))
#define GTK_LEVELS_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_LEVELS, GtkLevelsClass))
#define GTK_IS_LEVELS(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_LEVELS))
#define GTK_IS_LEVELS_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_LEVELS))

typedef struct _GtkLevels       GtkLevels;
typedef struct _GtkLevelsClass  GtkLevelsClass;


struct _GtkLevels
{
    GtkVBox       widget;
    GtkWidget    *ClipHBox;
    GtkWidget    *MetersHBox;
    GtkWidget    *LMeter;
    GtkWidget    *RMeter;
    GtkWidget    *LClip;
    GtkWidget    *RClip;
};

struct _GtkLevelsClass
{
    GtkVBoxClass parent_class;
};

GtkType     gtk_levels_get_type   (void);
GtkWidget  *gtk_levels_new        (void);
void        gtk_levels_set_levels (GtkLevels *levels, guint8 l, guint8 r);
void	    gtk_levels_set_clip	  (GtkLevels *levels, guint8 channel);

#endif /* __GTK_LEVELS_H__ */
