#ifndef __UTILS_H
#define __UTILS_H

#define UNUSED(x) x=x

#define DOSPATH(x) str_trans(x, '/', '\\')
#define UNIXPATH(x) str_trans(x, '\\', '/')

#define ITER_LIST(y) for(iter_ptr=y; iter_ptr; iter_ptr=iter_ptr->next)
#define LIST_DATA(x) x = iter_ptr->data; if (!x) continue

#define SET_WIDGET(x,y) gtk_object_set_data(GTK_OBJECT(x), #y, y)
#define GET_WIDGET(x,y) y = gtk_object_get_data(GTK_OBJECT(x), #y)

#define SET_DATA(x,y,z) gtk_object_set_data(GTK_OBJECT(x), y, z)
#define GET_DATA(x,y) gtk_object_get_data(GTK_OBJECT(x), y)

#define LIST_APPEND(x,y) x = g_list_append(x, y)
#define LIST_REMOVE(x,y) x = g_list_remove(x, y)
#define LIST_REMOVE_NTH(x,y) x = g_list_remove(x, g_list_nth_data(x, y))
#define LIST_PREPEND(x, y) x = g_list_prepend(x, y)
#define LIST_POP(x) g_list_nth_data(x, 0); LIST_REMOVE_NTH(x, 0)
#define LIST_INSERT(x,y,z) x = g_list_insert(x, y, z)
#define LIST_LENGTH(x) g_list_length(x)

struct _Account {
   char *user;
   char *pass;
   
   int primary;
};

/* prototypes */
void tint_color(GdkColor *c, int r, int g, int b);
FILE *get_file_handle();
void close_file_handle(FILE *f);
void setup_sigchld();
void handle_child(int num);
void bg_exec(char *cmd);
void set_conn_info(STab *stab, char *ip, unsigned short port, char *server, Account *acnt);
void unshare_files(STab *stab);
void transfer_init(Transfer *t);
void rem_trail(char *s, char t);
char *translate_args(char *args, int argcount);
void get_xfer_stats(STab *stab, unsigned long *d, unsigned long *u, unsigned long *td, unsigned long *tu, float *d_kps, float *u_kps, float *td_kps, float *tu_kps);
void set_tog_widgets(GtkItemFactory *ifact);
void char_list_free(GList *list);
int sort_get_data(GtkCList *clist, const void *p1, const void *p2, char **t1, char **t2);
int int_sort(GtkCList *clist, const void *p1, const void *p2);
int string_sort(GtkCList *clist, const void *p1, const void *p2);
void *get_sort_function(char c);
void column_sort(GtkWidget *w, int column, void *data);
int j_strlen(char *s);
int j_strcmp(char *s1, char *s2);
int j_strcasecmp(char *s1, char *s2);
Account *get_account(char *user);
int get_user_info();
char *str_trans(char *s, char o, char n);
char *complete_data(void *data);
void j_complete_free();
char *j_complete(GList *list, GList **ret, char *s);
GList *j_comp_items(STab *stab, GtkCList *clist);
GtkWidget *find_prop(STab *stab, int key);
void get_conn_pixmap(int c, GdkPixmap **p, GdkBitmap **b);
void pending_upload(STab *stab, char *user, char *file);
void remove_pending_upload(Transfer *upload);
int is_upload(STab *stab, char *user, char *file);
int total_conn();
GtkWidget *find_stab_vbox(GtkWidget *w);
void conn_info_init(ConnInfo *ci);
char *true_id(char *id);
void j_error(char *func, ...);
void print_bits(int x);
char *trunc_file(char *path);
GList *remove_nick(GList *nick_history, char *user);
STab *get_stab(int pn);
void load_stabs();
STab *get_current_stab();
ConnInfo *get_conn_info(int pn);
int cancels(ConnInfo *ci);
int cancels_inc(ConnInfo *ci, int inc);
int debug(ConnInfo *ci);
int connected(ConnInfo *ci);
int connecting(ConnInfo *ci);
int searching(ConnInfo *ci);
int browsing(ConnInfo *ci);
int sharing(ConnInfo *ci);
int safe_exit(ConnInfo *ci);
char *global_path(char *subdir, char *file);
char *local_path(char *subdir, char *file);
int is_comment(char *text);
char *hack_n(char *s);
char *hack_chr(char *s, char c);
void read_file_free(GList *list);
GList *read_file_full(const char *file, int line, FILE *f, int allow_n);
GList *read_file(const char *file, int line, FILE *f);
GList *read_file_with_n(const char *file, int line, FILE *f);
int get_type(void *data);
void set_type(void *data, int t);
char *all_lower(char *s);
void conv_file(char *s);
int file_exists(char *file);
char *next_arg_full_max_length(char *s, char **next, char end, int max);
char *next_arg_full(char *s, char **next, char end);
char *next_arg_first(char *s, char **next, char **first);
char *next_arg(char *s, char **next);
char *last_arg(char *s, char **next);
void convert(char *s, char *type, void *c);
long my_atol(const char *nptr);
int my_atoi(const char *nptr);
char *simplify_size(unsigned long int size);
void mp3_list_free(STab *stab);
void connection_free(char *file, int line, void *data);
void search_tab_free(char *file, int line, void *data);
void browse_tab_free(char *file, int line, void *data);
void download_tab_free(char *file, int line, void *data);
void upload_tab_free(char *file, int line, void *data);
void console_tab_free(char *file, int line, void *data);
void motd_tab_free(char *file, int line, void *data);
void stab_free(char *file, int line, void *data);
void cbpack_free(char *file, int line, void *data);
void account_free(char *file, int line, void *data);
void conn_info_free(char *file, int line, void *data);
void gmain_free(char *file, int line, void *data);
void file_entry_free(char *file, int line, void *data);
void theme_free(char *file, int line, void *data);
void hook_free(char *file, int line, void *data);
void property_free(char *file, int line, void *data);
void transfer_free(char *file, int line, void *data);
void share_free(char *file, int line, void *data);
void search_free(char *file, int line, void *data);
void server_free(char *file, int line, void *data);
void user_free(char *file, int line, void *data);
void channel_free(char *file, int line, void *data);
void resume_free(char *file, int line, void *data);
void j_dbg_free(char *file, int line, int type, void *data);
void gnapster_destroy(gpointer data);
int same_color(GdkColor col1, GdkColor col2);
void unlink_log();
int copy_file(char *opath, char *npath);
void relocate_config(char *home);
void create_priv_dir();
FILE *open_local_path(char *dir, char *file, char *flags);
FILE *open_log(char *file, char *flags);
void log_add_hooks(char *place, ...);
int hook_log(char *hook);
int match_date(char *path, FILE *f);
void move_file(char *path, FILE **f);
void rotate_logs(char *path, FILE **f);
void console_log(char *hook, char *text);
/* !prototypes */

#endif /* __UTILS_H */
