/* regexp.c - used to match wildcards with the server ignore stuff */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include <ctype.h>

#include <netinet/in.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>

#include "gnapster.h"

#include "regexp.h"

/* Taken from BitchX source coz panasync told me to :) */

#ifndef HAVE_STRLCPY
size_t strlcpy(char *dst, const char *src, size_t size) {
   char *d = dst;
   const char *s = src;
   size_t n = size;
   
   if (n != 0 && --n != 0) {
      do {
	 if ((*d++ = *s++) == 0)
	   break;
      } while(--n != 0);
   }
   if (n == 0) {
      if (size != 0)
	*d = '\0';
      while(*s++);
   }
   return (s - src - 1);
}
#endif

#ifndef HAVE_STRLCAT
size_t strlcat(char *dst, const char *src, size_t size) {
   char *d = dst;
   const char *s = src;
   size_t n = size;
   size_t dlen;
   
   while(*d != '\0' && n-- != 0)
     d++;
   dlen = d - dst;
   n = size - dlen;
   if (n == 0)
     return (dlen + strlen(s));
   while(*s != '\0') {
      if (n != 1) {
	 *d++ = *s;
	 n--;
      }
      s++;
   }
   *d = '\0';
   
   return (dlen + (s - src));
}
#endif

int new_match(const unsigned char *pattern, const unsigned char *string) {
   int count = 1, asterisk = 0, percent = 0, last_asterisk_count = 0,
       last_percent_count = 0, sanity = 0;
   const char *last_asterisk_point = NULL,
              *last_percent_point = NULL,
              *after_wildcard = NULL,
              *old_pattern = pattern, *old_string = string;
   for(;;) {
      if (sanity++ > 100000) {
	 fprintf(stderr, "Infinite loop in match! pattern = %s, string = %s",
		 old_pattern, old_string);
	 return 0;
      }
      if (asterisk) {
	 if (!*string)
	   return 0;
	 if (*pattern == '\\') {
	    pattern++;
	    if (tolower(*string) != tolower(*pattern))
	      continue;
	 } else if (*pattern == '?' ||
		    (tolower(*string) == tolower(*pattern))) {
	    asterisk = 0;
	    last_asterisk_point = string;
	    last_asterisk_count = count;
	 } else
	   string++;
	 
	 continue;
      }
      
      if (percent) {
	 if (!*string) {
	    if (*pattern)
	      return 0;
	    else
	      return count;
	 }

	 if (*pattern == '\\') {
	    pattern++;
	    if (tolower(*string) != tolower(*pattern))
	      continue;
	 }

	 if (*string == ' ') {
	    percent = 0;
	    last_percent_point = NULL;
	 } else if (tolower(*string) != tolower(*pattern)) {
	    string++;
	 } else {
	    percent = 0;
	    last_percent_point = string;
	    last_percent_count = count;
	 }
	 continue;
      }
      switch (*pattern) {
       case ('*'): case ('%'):
	   {
	      asterisk = 0, percent = 0;
	      do {
		 if (*pattern == '*')
		   asterisk = 1;
		 pattern++;
	      } while(*pattern == '*' || *pattern == '%');
	      after_wildcard = pattern;
	      if (asterisk) {
		 last_asterisk_point = string;
		 last_asterisk_count = count;
	      } else {
		 percent = 1;
		 last_percent_point = string;
		 last_percent_count = count;
	      }
	      if (asterisk && !*pattern)
		return count;
	      
	      break;
	   }
       case ('?'): 
	   {
	      pattern++;
	      if (!*string)
		return 0;
	      string++;
	      break;
	   }
       case ('\\'):
	   {
	      pattern++;
		if (!*pattern)
		  return 0;
	      if (tolower(*pattern) != tolower(*string))
		return 0;
	      
	      count++, string++, pattern++;
	      break;
	   }
       default:
	   {
	      if (!*pattern && !*string)
		return count;
	      
	      if (tolower(*pattern) == tolower(*string)) {
		 count++, pattern++, string++;
	      } else if (last_asterisk_point) {
		 asterisk = 1;
		 string = last_asterisk_point + 1;
		 pattern = after_wildcard;
		 count = last_asterisk_count;
	      } else if (last_percent_point) {
		 percent = 1;
		 string = last_percent_point + 1;
		 pattern = after_wildcard;
		 count = last_percent_count;
	      } else
		return 0;
	      break;
	   }
      }
   }
   return 0;
}

int wild_match(register const unsigned char *p, 
	       register const unsigned char *str) {
   if (strstr(p, "\\[")) {
      char *pattern, *ptr, *ptr2, *arg, *placeholder;
      int nest = 0;
      
      /* Evil evil panasync */
      pattern = strcpy(alloca(strlen((p)) + 1), p);
      
      placeholder = ptr = ptr2 = strstr(pattern, "\\[");
      
      do {
	 switch(ptr[1]) {
	  case '[':
	    ptr2 = ptr + 2;
	    nest++;
	    break;
	  case ']':
	    ptr2 = ptr + 2;
	    nest--;
	    break;
	  default:
	    ptr2 = ptr + 2;
	    break;
	 }
      } while(nest && (ptr = strchr(ptr2, '\\')));
      
      if (ptr) {
	 int best_total = 0;
	 
	 *ptr = 0;
	 ptr += 2;
	 *placeholder = 0;
	 placeholder += 2;

	 while((arg = next_arg(placeholder, &placeholder))) {
	    int tmpval;
	    char buf[2048 + 1];
	    
	    strlcpy(buf, pattern, 2048);
	    strlcat(buf, arg, 2048);
	    strlcat(buf, ptr, 2048);
	    
	    if ((tmpval = wild_match(buf, str))) {
	       if (tmpval > best_total)
		 best_total = tmpval;
	    }
	 }
	 
	 NA_RESET();
	 
	 return best_total;
      } else
	return new_match(pattern, str);
   } else
       return new_match(p, str);
}

