.TH PSMASK l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
psmask \- To clip or mask areas of no data on a map
.SH SYNOPSIS
\fBpsmask\fP [\fIxyzfile\fP] \fB\-I\fP\fIxinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP][/\fIyinc\fP[\fIunit\fP][\fB=\fP|\fB+\fP]] \fB\-J\fP\fIparameters\fP \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] [ \fB\-B\fP[\fBp\fP|\fBs\fP]\fIparameters\fP ]  
[ \fB\-D\fP\fIdumpfile\fP ] [ \fB\-E\fP\fIazimuth\fP/\fIelevation\fP ] [ \fB\-F\fP ] 
[ \fB\-G\fP\fIfill\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-K\fP ] [ \fB\-M\fP[\fIflag\fP] ] [ \fB\-N\fP ] [ \fB\-O\fP ] 
[ \fB\-P\fP ] [ \fB\-S\fP\fIsearch_radius\fP[\fBm\fP|\fBc\fP|\fBk\fP|\fBK\fP] ] [ \fB\-T\fP ] [ \fB\-U\fP[/\fIdx\fP/\fIdy\fP/][\fIlabel\fP] ] 
[ \fB\-V\fP ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIx-shift\fP[\fBu\fP]] ] [ \fB\-X\fP[\fBa\fP|\fBc\fP|\fBr\fP][\fIy-shift\fP[\fBu\fP]] ] [ \fB\-c\fP\fIcopies\fP ]  [ \fB\-:\fP[\fBi\fP|\fBo\fP] ] [ \fB\-bi\fP[\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ]
.br
.sp
\fBpsmask\fP \fB\-C\fP [ \fB\-K\fP ] [ \fB\-O\fP ]
.SH DESCRIPTION
\fBpsmask\fP reads a (\fIx\fP,\fIy\fP,\fIz\fP) file [or standard input] and uses this information to find out
which grid cells are reliable.  Only gridcells which have one or more data points are considered
reliable.  As an option, you may specify a radius of influence. Then, all gridcells that are
within \fIradius\fP of a data point are considered reliable.  Furthermore, an option is provided to
reverse the sense of the test.  Having found the reliable/not reliable points, \fBpsmask\fP will
either paint tiles to mask these nodes (with the \fB\-T\fP switch), or use contouring to create
polygons that will clip out regions of no interest.  When clipping is initiated, it will stay in
effect until turned off by a second call to \fBpsmask\fP using the \fB\-C\fP option.
.TP
\fIxyzfile\fP
File with (\fIx\fP,\fIy\fP,\fIz\fP) values (e.g., that was used to run \fBsurface\fP).  If no file
is given, standard input is read.  For binary files, see \fB\-b\fP.
.TP
.B \-I
\fIx_inc\fP [and optionally \fIy_inc\fP] is the grid spacing. Append \fBm\fP to
indicate minutes or \fBc\fP to indicate seconds.  If one of the units \fBe\fP, \fBk\fP, \fBi\fP,
or \fBn\fP is appended instead, the increment will be assumed to be in meter, km, miles, or
nautical miles, respectively, and will be converted to the equivalent degrees longitude at
the middle latitude of the region (the conversion depends on \fBELLIPSOID\fP).  If /\fIy_inc\fP is given but set to 0 it will be reset equal to
\fIx_inc\fP; otherwise it will be converted to degrees latitude.  If \fB=\fP is appended then
the corresponding max \fIx\fP (\fIeast\fP) or \fIy\fP (\fInorth\fP) may be slightly adjusted to fit exactly the given increment
[by default the increment may be adjusted slightly to fit the given domain].  Finally, instead
of giving an increment you may specify the \fInumber of nodes\fP desired by appending \fB+\fP to
the supplied increment; the increment is then recalculated from the number of nodes and the domain.
The resulting increment value depends on whether you have selected a gridline-registered or pixel-
registered grid; see Appendix B for details.
.TP
.B \-J
Selects the map projection. Scale is UNIT/degree, 1:xxxxx, or width in UNIT (upper case modifier).
UNIT is cm, inch, or m, depending on the \fBMEASURE_UNIT\fP setting in \.gmtdefaults4, but this can be
overridden on the command line by appending \fBc\fP, \fBi\fP, or \fBm\fP to the scale/width value.
For map height, max dimension, or min dimension, append \fBh\fP, \fB+\fP, or \fB-\fP to the width,
respectively.
.br
More details can be found in the \fBpsbasemap\fP man pages.
.br
.sp
\fBCYLINDRICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jc\fP\fIlon0/lat0/scale\fP (Cassini)
.br
\fB\-Jj\fP\fIlon0/scale\fP (Miller)
.br
\fB\-Jm\fP\fIscale\fP (Mercator - Greenwich and Equator as origin)
.br
\fB\-Jm\fP\fIlon0/lat0/scale\fP (Mercator - Give meridian and standard parallel)
.br
\fB\-Joa\fP\fIlon0/lat0/azimuth/scale\fP (Oblique Mercator - point and azimuth)
.br
\fB\-Job\fP\fIlon0/lat0/lon1/lat1/scale\fP (Oblique Mercator - two points)
.br
\fB\-Joc\fP\fIlon0/lat0/lonp/latp/scale\fP (Oblique Mercator - point and pole)
.br
\fB\-Jq\fP\fIlon0/scale\fP (Equidistant Cylindrical Projection (Plate Carree))
.br
\fB\-Jt\fP\fIlon0/scale\fP (TM - Transverse Mercator, with Equator as y = 0)
.br
\fB\-Jt\fP\fIlon0/lat0/scale\fP (TM - Transverse Mercator, set origin)
.br
\fB\-Ju\fP\fIzone/scale\fP (UTM - Universal Transverse Mercator)
.br
\fB\-Jy\fP\fIlon0/lats/scale\fP (Basic Cylindrical Projection) 
.br
.sp
\fBAZIMUTHAL PROJECTIONS:\fP
.br
.sp
\fB\-Ja\fP\fIlon0/lat0/scale\fP (Lambert)
.br
\fB\-Je\fP\fIlon0/lat0/scale\fP (Equidistant)
.br
\fB\-Jf\fP\fIlon0/lat0/horizon/scale\fP (Gnomonic)
.br
\fB\-Jg\fP\fIlon0/lat0/scale\fP (Orthographic)
.br
\fB\-Js\fP\fIlon0/lat0/\fP[\fIslat/\fP]\fIscale\fP (General Stereographic)
.br
.sp
\fBCONIC PROJECTIONS:\fP
.br
.sp
\fB\-Jb\fP\fIlon0/lat0/lat1/lat2/scale\fP (Albers)
.br
\fB\-Jd\fP\fIlon0/lat0/lat1/lat2/scale\fP (Equidistant)
.br
\fB\-Jl\fP\fIlon0/lat0/lat1/lat2/scale\fP (Lambert)
.br
.sp
\fBMISCELLANEOUS PROJECTIONS:\fP
.br
.sp
\fB\-Jh\fP\fIlon0/scale\fP (Hammer)
.br
\fB\-Ji\fP\fIlon0/scale\fP (Sinusoidal)
.br
\fB\-Jk\fP[\fBf|s\fP]\fIlon0/scale\fP (Eckert IV (f) and VI (s))
.br
\fB\-Jn\fP\fIlon0/scale\fP (Robinson)
.br
\fB\-Jr\fP\fIlon0/scale\fP (Winkel Tripel)
.br
\fB\-Jv\fP\fIlon0/scale\fP (Van der Grinten)
.br
\fB\-Jw\fP\fIlon0/scale\fP (Mollweide)
.br
.sp
\fBNON-GEOGRAPHICAL PROJECTIONS:\fP
.br
.sp
\fB\-Jp\fP[\fBa\fP]\fIscale\fP[\fI/origin\fP][\fBr\fP|\fBz\fP] (Polar coordinates (theta,r))
.br
\fB\-Jx\fP\fIx-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP][\fI/y-scale\fP[\fBd|l|p\fP\fIpow\fP\fB|t|T\fP]] (Linear, log, and power scaling)
.br
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.SH OPTIONS
No space between the option flag and the associated arguments.
.sp
.TP
.B \-B
Sets map boundary annotation and tickmark intervals; see the
\fBpsbasemap\fP man page for all the details.
.TP
.B \-C
Mark end of existing clip path.  No input file is needed.  Implicitly sets \fB\-O\fP.
.TP
.B \-D
Dumps out the resulting clipping polygons to disk.  Ignored if \fB\-T\fP is set.
If no dumpprefix is given we use mask (Files will be called mask_*.d).
.TP
.B \-E
Sets the viewpoint's azimuth and elevation for perspective plots [180/90].\"'
.TP
.B \-F
Force pixel registration.  [Default is grid registration].
.TP
.B \-G
Paint the clip polygons [or tiles] with selected fill [Default is no fill].
Specify the grey shade (0\-255) or color (r/g/b, each in range 0\-255; h-s-v, ranges
0\-360, 0\-1, 0\-1; or c/m/y/k, each in range 0\-100%; or valid color name).
Alternatively, specify \fB\-Gp\fP\fIdpi/pattern\fP, where \fIpattern\fP gives
the number of the built-in pattern (1-90) \fIor\fP the name of a Sun 1-, 8-,
or 24-bit raster file. The \fIdpi\fP sets the resolution of the image. For
1-bit rasters: use \fB\-GP\fP for inverse video, or append
\fB:F\fP\fIcolor\fP[\fBB\fP[\fIcolor\fP]] to specify fore- and background
colors (use \fIcolor\fP = - for transparency).
See \fBGMT\fP Cookbook & Technical Reference Appendix E for information
on individual patterns.
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
Not used with binary data.
.TP
.B \-K
More \fIPostScript\fP code will be appended later [Default terminates the plot system].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-N
Invert the sense of the test, i.e. clip regions where there is data coverage.
.TP
.B \-O
Selects Overlay plot mode [Default initializes a new plot system].
.TP
.B \-P
Selects Portrait plotting mode [\fBGMT\fP Default is Landscape, see \fBgmtdefaults\fP to change this].
.TP
.B \-S
Sets radius of influence. Grid nodes within \fIradius\fP of a data point are considered reliable. [Default is 0, which
means that only grid cells with data in them are reliable].  Append \fBm\fP to indicate minutes
or \fBc\fP to indicate seconds.  Append \fBk\fP to indicate km (implies \fB\-R\fP and \fB\-I\fP are in degrees, and
we will use a fast flat Earth approximation to calculate distance).  For more accuracy, use uppercase \fBK\fP
if distances should be calculated along geodesics.
However, if the current \fBELLIPSOID\fP is set to Sphere then spherical great circle calculations are used.
.TP
.B \-T
Plot tiles instead of clip polygons.  Use \fB\-G\fP to set tile color or pattern.
.TP
.B \-U
Draw Unix System time stamp on plot.  User may specify where the lower left corner
of the stamp should fall on the page relative to lower left corner of plot.  Optionally,
append a label, or \fBc\fP (which will plot the command string.).  The \fBGMT\fP parameters
\fBUNIX_TIME\fP and \fBUNIX_TIME_POS\fP can affect the appearance; see the \fBgmtdefaults\fP man
page for details.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-X \-Y
Shift origin of plot by (\fIx-shift,y-shift\fP), and
opetionally append units (\fBc\fP, \fBi\fP, \fBm\fP, \fBp\fP).
Prepend \fBa\fP for absolute coordinates;
the default (\fBr\fP) will reset plot origin.
Give \fBc\fP to center plot using current page size.
.TP
.B \-:
Toggles between (longitude,latitude) and (latitude,longitude) input and/or output.  [Default is (longitude,latitude)].
Append \fBi\fP to select input only or \fBo\fP to select output only.  [Default affects both].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
[Default is 2 input columns].
.TP
.B \-c
Specifies the number of plot copies. [Default is 1].
.SH EXAMPLES
To make an overlay \fIPostScript\fP file that will mask out the regions of a contour map
where there is no control data using clip polygons, use:
.br
.sp
\fBpsmask\fP africa_grav.xyg \fB\-R\fP20/40/20/40 \fB\-I\fP5\fBm \-J\fPM10\fBi\fP \fB\-O \-K\fP > mask.ps
.br
.sp
The same example but this time we use white tiling:
.br
.sp
\fBpsmask\fP africa_grav.xyg \fB\-R\fP20/40/20/40 \fB\-I\fP5\fBm \-J\fPM10\fBi\fP \fB\-T \-O \-K \-G\fP255 > mask.ps
.SH "SEE ALSO"
.IR GMT (l),
.IR grdmask (l),
.IR surface (l),
.IR psbasemap (l),
.IR psclip (l)
