.TH GRD2CPT l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
grd2cpt \- Read a grdfile and make a color palette file
.SH SYNOPSIS
\fBgrd2cpt\fP \fIgrdfile\fP [ \fB\-C\fP\fIcptmaster\fP ] [ \fB\-D\fP ] [ \fB\-E\fP\fInlevels\fP ] [ \fB\-I\fP ] 
[ \fB\-L\fP\fIminlimit/maxlimit\fP ] [ \fB\-N\fP ] [ \fB\-Q\fP[\fBi|o\fP] ] 
[ \fB\-R\fP\fIwest\fP/\fIeast\fP/\fIsouth\fP/\fInorth\fP[\fBr\fP] ] [ \fB\-S\fP\fIzstart/zstop/zinc\fP ] [ \fB\-V\fP ] [ \fB\-Z\fP ]
.SH DESCRIPTION
\fBgrd2cpt\fP reads a grdfile and writes a color palette (cpt) file to
standard output.  The cpt file is based on an existing master cptfile of
your choice, and the mapping from data value to colors is through the
data's cumulative distribution function (CDF), so that the colors are\"'
histogram equalized.  Thus if the resulting cpt file is used with the
grdfile and grdimage with a linear projection, the colors will be uniformly
distributed in area on the plot.  Let z be the data values in the grdfile. 
Define CDF(Z) = (# of z < Z) / (# of z in grdfile).  (NaNs are ignored).
These z-values are then normalized to the master cptfile and colors are
sampled at the desired intervals.
.TP
\fIgrdfile\fP
The 2-D binary grdfile used to derive the color palette table.
.SH OPTIONS
.TP
.B \-C
Selects the master color table to use in the interpolation.  Choose among
the built-in tables (type \fBgrd2cpt\fP to see the list) or give the
name of an existing cptfile [Default gives a rainbow cpt file].
.TP
.B \-D
Select the color values for lowest and highest \fIz\fP-values in the output cpt file
as the back- and foreground values that will be written to the cpt file [Default uses
the \fBGMT\fP default values, normally black and white].
.TP
.B \-E
Create a linear color table by dividing the grid z-range into \fInlevels\fP equidistant slices.
.TP
.B \-I
Reverses the sense of color progression in the master cptfile.
.TP
.B \-L
Limit range of cptfile to \fIminlimit/maxlimit\fP, and don't count data\"'
outside range when estimating CDF(Z).  [Default uses min and max of data.] 
.TP
.B \-N
Do Not write out the background, foreground, and NaN-color fields [Default will write the parameters
\fBCOLOR_BACKGROUND\fP, \fBCOLOR_FOREGROUND\fP, and \fBCOLOR_NAN\fP in your .gmtdefaults4 file.
.TP
.B \-Q
Selects a logarithmic interpolation scheme [Default is linear].  \fB\-Qi\fP expects input z-values to be log10(z), assigns colors, and writes out z [Default].
\fB\-Qo\fP takes log10(z) first, assigns colors, and writes out z.
.TP
.B \-R
\fIxmin\fP, \fIxmax\fP, \fIymin\fP, and \fIymax\fP specify the Region of interest.  For geographic
regions, these limits correspond to \fIwest, east, south,\fP and \fInorth\fP and you may specify them
in decimal degrees or in [+-]dd:mm[:ss.xxx][W|E|S|N] format.  Append \fBr\fP if lower left and upper right
map coordinates are given instead of wesn.  The two shorthands \fB\-Rg \-Rd\fP stand for global domain
(0/360 or -180/+180 in longitude respectively, with -90/+90 in latitude).
For calendar time coordinates you may either give relative
time (relative to the selected \fBTIME_EPOCH\fP and in the selected \fBTIME_UNIT\fP; append \fBt\fP to \fB\-JX|x\fP),
or absolute time of the form [\fIdate\fP]\fBT\fP[\fIclock\fP] (append \fBT\fP to \fB\-JX|x\fP).  At least one of \fIdate\fP and \fIclock\fP
must be present; the \fBT\fP is always required.  The \fIdate\fP string must be of the form [-]yyyy[-mm[-dd]]
(Gregorian calendar) or yyyy[-Www[-d]] (ISO week calendar), while the \fIclock\fP string must be of
the form hh:mm:ss[.xxx].  The use of delimiters and their type and positions must be as indicated
(however, input/output and plotting formats are flexible). 
.TP
.B \-S
Set steps in cpt file.  Calculate entries in cptfile from \fIzstart\fP to \fIzstop\fP
in steps of (\fIzinc\fP).  [Default chooses arbitrary values by a crazy scheme.]
.TP
.B \-V
Verbose operation.  This will write CDF(Z) estimates to stderr.  [Default is silent.] 
.TP
.B \-Z
Will create a continuous color palette.
[Default is discontinuous, i.e., constant color intervals]
.SH EXAMPLES
Sometimes you don't want to make a cpt file (yet) but would find it helpful\"'
to know that 90% of your data lie between z1 and z2, something you cannot
learn from \fBgrdinfo\fP.  So you can do this to see some points on the
CDF(Z) curve (use \fB\-V\fP option to see more):
.br
.sp
\fBgrd2cpt\fP mydata.grd \fB\-V\fP > /dev/null
.br
.sp
To make a cpt file with entries from 0 to 200 in steps of 20, and ignore
data below zero in computing CDF(Z), and use the built-in master cptfile
relief, run
.br
.sp
\fBgrd2cpt\fP mydata.grd \fB\-C\fP\fIrelief\fP \fB-L\fP0/10000 \fB-S\fP0/200/20 > mydata.cpt
.SH "SEE ALSO"
.IR gmtdefaults (l),
.IR GMT (l),
.IR grdhisteq (l),
.IR grdinfo (l),
.IR makecpt (l)
