.TH GMTMATH l "15 May 2006" "GMT4.1.2" "GMT4.1.2"
.SH NAME
gmtmath \- Reverse Polish Notation calculator for data tables
.SH SYNOPSIS
\fBgmtmath\fP [ \fB\-A\fP\fIt_f(t).d\fP ] [ \fB\-C\fP\fIcols\fP ] [ \fB\-F\fP\fIcols\fP ] [ \fB\-H\fP[\fBi\fP][\fInrec\fP] ] [ \fB\-I\fP ] 
[ \fB\-M\fP[\fBi\fP|\fBo\fP][\fIflag\fP] ] [ \fB\-N\fP\fIn_col\fP/\fIt_col\fP ] [ \fB\-Q\fP ] [ \fB\-S\fP[\fBf\fP|\fBl\fP] ] 
[ \fB\-T\fP\fIt_min\fP/\fIt_max\fP/\fIt_inc\fP|\fItfile\fP ] [ \fB\-V\fP ] [ \fB\-b\fP[\fBi\fP|\fBo\fP][\fBs\fP|\fBS\fP|\fBd\fP|\fBD\fP][\fIncol\fP] ] 
[ \fB\-f\fP[\fBi\fP|\fBo\fP]\fP\fIcolinfo\fP ] \fIoperand\fP [ \fIoperand\fP ] \fBOPERATOR\fP [ \fIoperand\fP ] 
\fBOPERATOR\fP ... \fB=\fP [ \fIoutfile\fP ]
.SH DESCRIPTION
\fBgmtmath\fP will perform operations like add, subtract, multiply, and divide
on one or more table data files or constants using Reverse Polish Notation (RPN)
syntax (e.g., Hewlett-Packard calculator-style).  Arbitrarily complicated expressions
may therefore be evaluated; the final result is written to an output file
[or standard output].  When two data tables are on the stack, each element in file A
is modified by the corresponding element in file B.  However, some operators only
require one operand (see below).  If no data tables are used in the expression then options
\fB\-T\fP, \fB\-N\fP can be set (and optionally \fB\-b\fP to indicate the data domain.  If STDIN
is given, <stdin> will be read and placed on the stack as if a file with that content
had been given on the command line.  By default, all columns except the
"time" column are operated on, but this can be changed (see \fB\-C\fP).
.TP
\fIoperand\fP
If \fIoperand\fP can be opened as a file it will be read as an ASCII (or binary, see \fB\-bi\fP) table data file.
If not a file, it is interpreted as a numerical constant or a special symbol (see below).  The special argument
STDIN means that \fIstdin\fP will be read and placed on the stack; STDIN can appear more than once if necessary.
.TP
\fIoutfile\fP is a table data file that will hold the final result.  If not given then the output is sent to stdout.
.TP
.B OPERATORS
Choose among the following operators:
.br
Operator	n_args	Returns
.br
.sp
\fBABS\fP		1	abs (A).
.br
\fBACOS\fP		1	acos (A).
.br
\fBACOSH\fP	1	acosh (A).
.br
\fBADD\fP		2	A + B.
.br
\fBAND\fP		2	NaN if A and B == NaN, B if A == NaN, else A.
.br
\fBASIN\fP		1	asin (A).
.br
\fBASINH\fP	1	asinh (A).
.br
\fBATAN\fP		1	atan (A).
.br
\fBATAN2\fP	2	atan2 (A, B).
.br
\fBATANH\fP	1	atanh (A).
.br
\fBBEI\fP		1	bei (A).
.br
\fBBER\fP		1	ber (A).
.br
\fBCEIL\fP		1	ceil (A) (smallest integer >= A).
.br
\fBCHICRIT\fP	2	Critical value for chi-squared-distribution, with alpha = A and n = B.
.br
\fBCHIDIST\fP	2	chi-squared-distribution P(chi2,n), with chi2 = A and n = B.
.br
\fBCORRCOEFF\fP		2	Correlation coefficient r(A, B).
.br
\fBCOL\fP		1	Places column A on the stack.
.br
\fBCOS\fP		1	cos (A) (A in radians).
.br
\fBCOSD\fP		1	cos (A) (A in degrees).
.br
\fBCOSH\fP		1	cosh (A).
.br
\fBCPOISS\fP		2	Cumulative Poisson distribution F(x,lambda), with x = A and lambda = B.
.br
\fBD2DT2\fP		1	d^2(A)/dt^2 2nd derivative.
.br
\fBD2R\fP		1	Converts Degrees to Radians.
.br
\fBDILOG\fP	1	dilog (A).
.br
\fBDIV\fP		2	A / B.
.br
\fBDDT\fP		1	d(A)/dt 1st derivative.
.br
\fBDUP\fP		1	Places duplicate of A on the stack.
.br
\fBERF\fP		1	Error function erf (A).
.br
\fBERFC\fP		1	Complementary Error function erfc (A).
.br
\fBERFINV\fP	1	Inverse error function of A.
.br
\fBEQ\fP		2	1 if A == B, else 0.
.br
\fBEXCH\fP		2	Exchanges A and B on the stack.
.br
\fBEXP\fP		1	exp (A).
.br
\fBFCRIT\fP	3	Critical value for F-distribution, with alpha = A, n1 = B, and n2 = C.
.br
\fBFDIST\fP	3	F-distribution Q(F,n1,n2), with F = A, n1 = B, and n2 = C.
.br
\fBFLIPUD\fP		1	Reverse order of each column
.br
\fBFLOOR\fP	1	floor (A) (greatest integer <= A).
.br
\fBFMOD\fP		2	A % B (remainder).
.br
\fBGE\fP		2	1 if A >= B, else 0.
.br
\fBGT\fP		2	1 if A > B, else 0.
.br
\fBHYPOT\fP	2	hypot (A, B) = sqrt (A*A + B*B).
.br
\fBI0\fP		1	Modified Bessel function of A (1st kind, order 0).
.br
\fBI1\fP		1	Modified Bessel function of A (1st kind, order 1).
.br
\fBIN\fP		2	Modified Bessel function of A (1st kind, order B).
.br
\fBINT\fP		1	Numerically integrate A.
.br
\fBINV\fP		1	1 / A.
.br
\fBISNAN\fP	1	1 if A == NaN, else 0.
.br
\fBJ0\fP		1	Bessel function of A (1st kind, order 0).
.br
\fBJ1\fP		1	Bessel function of A (1st kind, order 1).
.br
\fBJN\fP		2	Bessel function of A (1st kind, order B).
.br
\fBK0\fP		1	Modified Kelvin function of A (2nd kind, order 0).
.br
\fBK1\fP		1	Modified Bessel function of A (2nd kind, order 1).
.br
\fBKN\fP		2	Modified Bessel function of A (2nd kind, order B).
.br
\fBKEI\fP		1	kei (A).
.br
\fBKER\fP		1	ker (A).
.br
\fBLE\fP		2	1 if A <= B, else 0.
.br
\fBLMSSCL\fP	1	LMS scale estimate (LMS STD) of A.
.br
\fBLOG\fP		1	log (A) (natural log).
.br
\fBLOG10\fP	1	log10 (A) (base 10).
.br
\fBLOG1P\fP	1	log (1+A) (accurate for small A).
.br
\fBLOG2\fP		1	log2 (A) (base 2).
.br
\fBLOWER\fP	1	The lowest (minimum) value of A.
.br
\fBLRAND\fP		2	Laplace random noise with mean A and std. deviation B.
.br
\fBLSQFIT\fP	1	Let current table be [A | b]; return least squares solution x = A \\ b.
.br
\fBLT\fP		2	1 if A < B, else 0.
.br
\fBMAD\fP		1	Median Absolute Deviation (L1 STD) of A.
.br
\fBMAX\fP		2	Maximum of A and B.
.br
\fBMEAN\fP		1	Mean value of A.
.br
\fBMED\fP		1	Median value of A.
.br
\fBMIN\fP		2	Minimum of A and B.
.br
\fBMODE\fP		1	Mode value (Least Median of Squares) of A.
.br
\fBMUL\fP		2	A * B.
.br
\fBNAN\fP		2	NaN if A == B, else A.
.br
\fBNEG\fP		1	-A.
.br
\fBNEQ\fP		2	1 if A != B, else 0.
.br
\fBNRAND\fP	2	Normal, random values with mean A and std. deviation B.
.br
\fBOR\fP		2	NaN if A or B == NaN, else A.
.br
\fBPLM\fP		3	Associated Legendre polynomial P(-1<A<+1) degree B order C.
.br
\fBPOP\fP		1	Delete top element from the stack.
.br
\fBPOW\fP		2	A ^ B.
.br
\fBR2\fP		2	R2 = A^2 + B^2.
.br
\fBR2D\fP		1	Convert Radians to Degrees.
.br
\fBRAND\fP		2	Uniform random values between A and B.
.br
\fBRINT\fP		1	rint (A) (nearest integer).
.br
\fBROOTS\fP		2	Treats col A as f(t) = 0 and returns its roots
.br
\fBROTT\fP		2	Rotate A by the (constant) shift B in the t-direction.
.br
\fBSIGN\fP		1	sign (+1 or -1) of A.
.br
\fBSIN\fP		1	sin (A) (A in radians).
.br
\fBSINC\fP		1	sinc (A) (sin (pi*A)/(pi*A)).
.br
\fBSIND\fP		1	sin (A) (A in degrees).
.br
\fBSINH\fP		1	sinh (A).
.br
\fBSQRT\fP		1	sqrt (A).
.br
\fBSTD\fP		1	Standard deviation of A.
.br
\fBSTEP\fP		1	Heaviside step function H(A).
.br
\fBSTEPT\fP	1	Heaviside step function H(t-A).
.br
\fBSUB\fP		2	A - B.
.br
\fBSUM\fP		1	Cumulative sum of A
.br
\fBTAN\fP		1	tan (A) (A in radians).
.br
\fBTAND\fP		1	tan (A) (A in degrees).
.br
\fBTANH\fP		1	tanh (A).
.br
\fBTN\fP		2	Chebyshev polynomial Tn(-1<A<+1) of degree B.
.br
\fBTCRIT\fP	2	Critical value for Student's t-distribution, with alpha = A and n = B.\"'
.br
\fBTDIST\fP	2	Student's t-distribution A(t,n), with t = A, and n = B.\"'
.br
\fBUPPER\fP	1	The highest (maximum) value of A.
.br
\fBXOR\fP		2	B if A == NaN, else A.
.br
\fBY0\fP		1	Bessel function of A (2nd kind, order 0).
.br
\fBY1\fP		1	Bessel function of A (2nd kind, order 1).
.br
\fBYN\fP		2	Bessel function of A (2nd kind, order B).
.br
\fBZCRIT\fP	1	Critical value for the normal-distribution, with alpha = A.
.br
\fBZDIST\fP		1	Cumulative normal-distribution C(x), with x = A.
.br
.TP
.B SYMBOLS
The following symbols have special meaning:
.br
.sp
\fBPI\fP	3.1415926...
.br
\fBE \fP	2.7182818...
.br
\fBT \fP	Table with t-coordinates
.br
.SH OPTIONS
.TP
.B \-A
Requires \fB\-N\fP and will partially initialize a table with values from the given file containing
\fIt\fP and \fIf(t)\fP only.  The \fIt\fP is placed in column \fIt_col\fP while \fIf(t)\fP goes into
column \fIn_col\fP - 1 (see \fB\-N\fP).
.TP
.B \-C
Select the columns that will be operated on until next occurrence of \fB\-C\fP.
List columns separated by commas; ranges like 1,3-5,7 are allowed.  \fB\-C\fP
(no arguments) resets the default action of using all columns except time column (see \fB\-N\fP). 
\fB\-Ca\fP selects all columns, including time column, while \fB\-Cr\fP reverses (toggles) the current
choices.
.TP
.B \-F
Give a comma-separated list of desired columns or ranges that should be part of the output
(0 is first column) [Default outputs all columns].
.TP
.B \-H
Input file(s) has Header record(s).  Number of header records can be changed by editing
your \.gmtdefaults4 file.  If used, \fBGMT\fP default is 1 header record. Use \fB\-Hi\fP
if only input data should have header records [Default will write out header records if the
input data have them].
.TP
.B \-I
Reverses the output row sequence from ascending time to descending [ascending].
.TP
.B \-M
Multiple segment file(s).  Segments are separated by a special record.
For ASCII files the first character must be \fIflag\fP [Default is '>'].
For binary files all fields must be NaN and \fB\-b\fP must
set the number of output columns explicitly.  By default the \fB\-M\fP
setting applies to both input and output.  Use \fB\-Mi\fP and \fB\-Mo\fP
to give separate settings.
.TP
.B \-N
Select the number of columns and the column number that contains the
"time" variable.  Columns are numbered starting at 0 [2/0].
.TP
.B \-Q
Quick mode for scalar calculation.  Shorthand for \fB\-Ca \-N\fP1/0 \fB\-T\fP0/0/1.
.TP
.B \-S
Only report the first or last row of the results [Default is all rows].  This is useful if
you have computed a statistic (say the \fBMODE\fP) and only want to report a single number
instead of numerous records with identical values.
Append \fBl\fP to get the last row and \fBf\fP to get the first row only
[Default].
.TP
.B \-T
Required when no input files are given.  Sets the t-coordinates of the first
and last point and the equidistant sampling interval for the "time" column (see \fB\-N\fP).
If there is no time column (only data columns), give \fB\-T\fP with no arguments; this
also implies \fB\-Ca\fP.  Alternatively, give the name of a file whose first column
contains the desired t-coordinates which may be irregular.
.TP
.B \-V
Selects verbose mode, which will send progress reports to stderr [Default runs "silently"].
.TP
.B \-bi
Selects binary input.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.
Optionally, append \fIncol\fP, the number of columns in your binary file
if it exceeds the columns needed by the program.
.TP
.B \-bo
Selects binary output.  Append \fBs\fP for single precision [Default is \fBd\fP (double)].
Uppercase \fBS\fP (or \fBD\fP) will force byte-swapping.  Optionally, append
\fIncol\fP, the number of desired columns in your binary output file.
[Default is same as input, but see \fB\-F\fP]
.SH ASCII FORMAT PRECISION
The ASCII output formats of numerical data are controlled by parameters in
your .gmtdefaults4 file.  Longitude and latitude are formatted according to
\fBOUTPUT_DEGREE_FORMAT\fP, whereas other values are formatted according
to \fBD_FORMAT\fP.  Be aware that the format in effect can lead to loss of
precision in the output, which can lead to various problems downstream.  If
you find the output is not written with enough precision, consider switching
to binary output (\fB\-bo\fP if available) or specify more decimals using
the \fBD_FORMAT\fP setting.
.SH BEWARE
(1) The operator \fBPLM\fP calculates the associated Legendre polynomial
of degree L and order M, and its argument is the cosine of the colatitude
which must satisfy -1 <= x <= +1. \fBPLM\fP is not normalized.
.br
.sp
(2) All derivatives are based on central finite differences, with natural
boundary conditions.
.SH EXAMPLES
To take the square root of the content of the second data column being piped through \fBgmtmath\fP
by process1 and pipe it through a 3rd process, use
.br
.sp
process1 | \fBgmtmath\fP STDIN \fBSQRT \=\fP | process3
.br
.sp
To take log10 of the average of 2 data files, use
.br
.sp
\fBgmtmath\fP file1.d file2.d \fBADD\fP 0.5 \fBMUL LOG10 \=\fP file3.d
.br
.sp
Given the file samples.d, which holds seafloor ages in m.y. and seafloor depth in m, use the relation
depth(in m) = 2500 + 350 * sqrt (age) to print the depth anomalies:
.br
.sp
\fBgmtmath\fP samples.d \fBT SQRT\fP 350 \fBMUL \fP2500 \fBADD SUB \=\fP | lpr
.br
.sp
To take the average of columns 1 and 4-6 in the three data sets sizes.1, sizes.2, and sizes.3, use
.br
.sp
\fBgmtmath\fP \fB\-C\fP1,4-6 sizes.1 sizes.2 \fBADD\fP sizes.3 \fBADD 3 DIV \=\fP ave.d
.br
.sp
To take the 1-column data set ages.d and calculate the modal value and assign it to a variable, try
.br
.sp
set mode_age = `\fBgmtmath\fP \fB\-S \-T\fP ages.d \fBMODE \=\fP`
.br
.sp
To evaluate the dilog(x) function for coordinates given in the file t.d:
.br
.sp
\fBgmtmath\fP \fB\-T\fPt.d \fBT DILOG \=\fP dilog.d
.br
.sp
To use gmtmath as a RPN Hewlett-Packard calculator on scalars (i.e., no input
files) and calculate arbitrary expressions, use the \fB\-Q\fP option.
As an example, we will calculate the value of Kei (((1 + 1.75)/2.2) + cos (60))
and store the result in the shell variable z:
.br
.sp
set z = `\fBgmtmath\fP \fB\-Q\fP 1 1.75 \fBADD\fP 2.2 \fBDIV\fP 60 \fBCOSD ADD KEI \=\fP`
.br
.sp
To use \fBgmtmath\fP as a general least squares equation solver, imagine that the current table is the
augmented matrix [ A | b ] and you want the least squares solution x to the matrix equation A * x = b.
The operator \fBLSQFIT\fP does this; it is your job to populate the matrix correctly first.  The \fB\-A\fP
option will facilitate this.  Suppose you have a 2-column file ty.d with \fIt\fP and \fIb(t)\fP and you would
like to fit a the model y(t) = a + b*t + c*H(t-t0), where H is the Heaviside step function for a given t0 = 1.55.
Then, you need a 4-column augmented table loaded with t in column 0 and your observed y(t) in column 3.
The calculation becomes
.br
.sp
\fBgmtmath\fP \fB\-N\fP4/1 \fB\-A\fPty.d \fB-C\fP0 1 \fBADD \-C\fP2 1.55 \fBSTEPT ADD \-Ca LSQFIT \=\fP solution.d
.br
.sp
Note we use the \fB\-C\fP option to select which columns we are working on, then make active all the
columns we need (here all of them, with \fB\-Ca\fP) before calling \fBLSQFIT\fP.  The second and fourth
columns are preloaded with t and y(t), respectively, the other columns are zero.  If you already have
a precalculated table with the augmented matrix [ A | b ] in a file (say lsqsys.d), the least squares
solution is simply
.br
.sp
\fBgmtmath\fP \fB\-T\fP lsqsys.d \fBLSQFIT \=\fP solution.d
.SH BEWARE
(1) Files that have the same names as some operators, e.g., \fBADD\fP, \fBSIGN\fP, \fB=\fP, etc. should be
identified by prepending the current directory (i.e., ./LOG).
.br
(2) The stack depth limit is hard-wired to 100.
.br
(3) All functions expecting a positive radius (e.g., \fBLOG\fP, \fBKEI\fP, etc.) are passed the
absolute value of their argument..br
(4) The \fBDDT\fP and \fBD2DT2\fP functions only work on regularly spaced data.
.br
(5) \fBROOTS\fP must be the last operator on the stack, only followed by \fB=\fP.
.SH REFERENCES
Abramowitz, M., and I. A. Stegun, 1964, \fIHandbook of Mathematical
Functions\fP, Applied Mathematics Series, vol. 55, Dover, New York.
.br
Press, W. H.,  S. A. Teukolsky, W. T. Vetterling, B. P. Flannery, 1992, 
\fINumerical Recipes\fP, 2nd edition, Cambridge Univ., New York.
.SH "SEE ALSO"
.IR GMT (l),
.IR grd2xyz (l),
.IR grdedit (l),
.IR grdinfo (l),
.IR grdmath (l),
.IR xyz2grd (l)
